/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.yasgl;

import edu.illinois.yasgl.DFSTask;
import edu.illinois.yasgl.DirectedGraphBuilder;
import edu.illinois.yasgl.Graph;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;

public class GraphUtils<V> {
    private final double ERR = 0.001;
    private final double d = 0.85;
    private boolean changed = true;
    private Map<V, Double> pr;

    public static DirectedGraphBuilder<String> buildDirectedGraphFromFile(String fileName) {
        DirectedGraphBuilder<String> builder = new DirectedGraphBuilder<String>();
        try (BufferedReader filescan = Files.newBufferedReader(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8);){
            String line;
            while ((line = filescan.readLine()) != null) {
                String[] edges = line.split(" ");
                builder.addEdge(edges[0].trim(), edges[1].trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder;
    }

    public static <V> GraphUtils<V> getInstance() {
        return new GraphUtils<V>();
    }

    public static <V> Map<V, Set<V>> computeTransitiveClosure(Graph<V> graph) {
        ConcurrentHashMap forwardReach = new ConcurrentHashMap();
        new DFSTask<V>(graph, forwardReach).run();
        return forwardReach;
    }

    public static <V> Map<V, Set<V>> computeBackwardsTransitiveClosure(Graph<V> graph) {
        ConcurrentHashMap backwardReach = new ConcurrentHashMap();
        new DFSTask<V>(graph.inverse(), backwardReach).run();
        return backwardReach;
    }

    public static <V> Map<V, Integer> longestPaths(Graph<V> graph) {
        HashMap lengths = new HashMap();
        graph.getVertices().stream().forEach(vertex -> GraphUtils.longestPaths(vertex, graph, lengths));
        return lengths;
    }

    private static <V> int longestPaths(V vertex, Graph<V> graph, Map<V, Integer> lengths) {
        if (!lengths.containsKey(vertex)) {
            lengths.put((Integer)vertex, 0);
            OptionalInt optional = graph.getSuccessors(vertex).stream().mapToInt(v -> GraphUtils.longestPaths(v, graph, lengths)).max();
            lengths.put((Integer)vertex, optional.orElse(0) + 1);
        }
        return lengths.get(vertex);
    }

    public static <V> List<V> computeAnyPath(Graph<V> graph, V source, Set<V> destinations) {
        Stack<V> stack = new Stack<V>();
        stack.push(source);
        HashSet<V> visited = new HashSet<V>();
        LinkedList<V> path = new LinkedList<V>();
        HashMap<V, V> parents = new HashMap<V, V>();
        Object current = source;
        while (!stack.isEmpty() && !destinations.contains(current = stack.pop())) {
            for (V vertex : graph.getSuccessors(current)) {
                if (!visited.add(vertex)) continue;
                stack.push(vertex);
                parents.put(vertex, current);
            }
        }
        while (current != null) {
            path.addFirst(current);
            current = parents.get(current);
        }
        return path;
    }

    public static <V> int computeDFS(Graph<V> graph, V source, Set<V> destinations) {
        HashSet<V> visited = new HashSet<V>();
        visited.add(source);
        return GraphUtils.computeDFSHelper(graph, source, destinations, visited);
    }

    private static <V> int computeDFSHelper(Graph<V> graph, V source, Set<V> destinations, Set<V> visited) {
        if (destinations.contains(source)) {
            return 1;
        }
        for (V vertex : graph.getSuccessors(source)) {
            int val;
            if (!visited.add(vertex) || (val = GraphUtils.computeDFSHelper(graph, vertex, destinations, visited)) <= 0) continue;
            return val + 1;
        }
        return 0;
    }

    public static <V> List<V> computeShortestPath(Graph<V> graph, V source, Set<V> destinations) {
        int maxDepth = GraphUtils.computeDFS(graph, source, destinations);
        LinkedList<V> path = new LinkedList<V>();
        if (maxDepth == 0) {
            return path;
        }
        for (int i = 0; i < maxDepth && !GraphUtils.computeDepthLimitedDFS(graph, source, destinations, i, path); ++i) {
        }
        path.add(0, source);
        return path;
    }

    private static <V> boolean computeDepthLimitedDFS(Graph<V> graph, V source, Set<V> destinations, int limit, LinkedList<V> path) {
        if (destinations.contains(source)) {
            return true;
        }
        if (limit <= 0) {
            return false;
        }
        for (V vertex : graph.getSuccessors(source)) {
            if (!GraphUtils.computeDepthLimitedDFS(graph, vertex, destinations, limit - 1, path)) continue;
            path.addFirst(vertex);
            return true;
        }
        return false;
    }

    public Map<V, Double> pageRank(Graph<V> g) {
        this.pr = new IdentityHashMap<V, Double>();
        long N = g.getVertices().size();
        double uniform = 1.0 / (double)N;
        g.getVertices().stream().forEach(v -> this.pr.put((Double)v, uniform));
        double ct = 0.15000000000000002 / (double)N;
        boolean i = false;
        while (this.changed) {
            this.changed = false;
            IdentityHashMap<Double, Double> newPr = new IdentityHashMap<Double, Double>();
            for (V v2 : g.getVertices()) {
                double computedPr = 0.0;
                for (V pred : g.getPredecessors(v2)) {
                    computedPr += this.pr.get(pred) / (1.0 * (double)g.getSuccessors(pred).size());
                }
                double currentRank = this.pr.get(v2);
                if (Math.abs((computedPr = ct + 0.85 * computedPr) - currentRank) > 0.001) {
                    this.changed = true;
                }
                newPr.put((Double)v2, computedPr);
            }
            this.pr = newPr;
        }
        return this.pr;
    }
}

