/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.yasgl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import edu.illinois.yasgl.LabeledDirectedGraph;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

public class LabeledDirectedGraphBuilder<V, E> {
    private final ImmutableMultimap.Builder<V, VertexEntry<V, E>> forward = ImmutableSetMultimap.builder();
    private final Collection<V> vertices = new HashSet<V>();

    public LabeledDirectedGraphBuilder() {
    }

    public LabeledDirectedGraphBuilder(LabeledDirectedGraph<V, E> g) {
        this.vertices.addAll(g.vertices);
        for (Object pre : g.forward.keys()) {
            for (VertexEntry suc : g.forward.get(pre)) {
                this.addEdge(pre, suc.getVertex(), suc.getEdge());
            }
        }
    }

    public synchronized void addEdge(V vertex1, V vertex2, E edge) {
        this.addVertex(vertex1);
        this.addVertex(vertex2);
        this.forward.put(vertex1, new VertexEntry<V, E>(vertex2, edge));
    }

    public synchronized void addVertex(V vertex) {
        this.vertices.add(vertex);
    }

    public LabeledDirectedGraph<V, E> build() {
        ImmutableMultimap multi = this.forward.build();
        return new LabeledDirectedGraph(multi, ImmutableSet.copyOf(this.vertices));
    }

    public static class VertexEntry<V, E>
    implements Serializable {
        private static final long serialVersionUID = -1772155319994626054L;
        private final V vertex;
        private final E edge;

        public VertexEntry(V vertex, E edge) {
            this.vertex = vertex;
            this.edge = edge;
        }

        public V getVertex() {
            return this.vertex;
        }

        public E getEdge() {
            return this.edge;
        }

        public String toString() {
            return this.vertex + "\t" + this.edge;
        }

        public int hashCode() {
            return this.vertex.hashCode() + this.edge.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof VertexEntry) {
                VertexEntry casted = (VertexEntry)o;
                return this == casted || this.vertex.equals(casted.vertex) && this.edge.equals(casted.edge);
            }
            return false;
        }
    }
}

