/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsFindAttributeDefNamesResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestFindAttributeDefNamesRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcFindAttributeDefNames {
    private String serviceRole;
    private WsSubjectLookup subjectLookup;
    private String inheritanceSetRelation;
    private String attributeDefType;
    private String attributeAssignType;
    private String scope;
    private Boolean splitScope;
    private String clientVersion;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Set<String> attributeDefNameNames = new LinkedHashSet<String>();
    private Set<String> attributeDefNameUuids = new LinkedHashSet<String>();
    private Set<Long> attributeDefNameIdIndexes = new LinkedHashSet<Long>();
    private String nameOfAttributeDef;
    private String uuidOfAttributeDef;
    private Long idIndexOfAttributeDef;
    private Boolean ascending;
    private Integer pageNumber;
    private Integer pageSize;
    private String sortString;
    private Boolean pageIsCursor;
    private String pageLastCursorField;
    private String pageLastCursorFieldType;
    private Boolean pageCursorFieldIncludesLastRetrieved;

    public GcFindAttributeDefNames assignServiceRole(String theServiceRole) {
        this.serviceRole = theServiceRole;
        return this;
    }

    public GcFindAttributeDefNames assignSubjectLookup(WsSubjectLookup theSubjectLookup) {
        this.subjectLookup = theSubjectLookup;
        return this;
    }

    public GcFindAttributeDefNames assignInheritanceSetRelation(String theInheritanceRelation) {
        this.inheritanceSetRelation = theInheritanceRelation;
        return this;
    }

    public GcFindAttributeDefNames assignAttributeDefType(String theAttributeDefType) {
        this.attributeDefType = theAttributeDefType;
        return this;
    }

    public GcFindAttributeDefNames assignAttributeAssignType(String theAttributeAssignType) {
        this.attributeAssignType = theAttributeAssignType;
        return this;
    }

    public GcFindAttributeDefNames assignScope(String theScope) {
        this.scope = theScope;
        return this;
    }

    public GcFindAttributeDefNames assignSplitScope(Boolean theSplitScope) {
        this.splitScope = theSplitScope;
        return this;
    }

    public GcFindAttributeDefNames assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcFindAttributeDefNames addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcFindAttributeDefNames addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcFindAttributeDefNames assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.scope) && GrouperClientUtils.length(this.attributeDefNameUuids) == 0 && GrouperClientUtils.length(this.attributeDefNameNames) == 0 && GrouperClientUtils.length(this.attributeDefNameIdIndexes) == 0) {
            throw new RuntimeException("Need to pass in a scope, or attributeDefNameNames or attributeDefNameUuids or attributeDefNameIdIndexes: " + this);
        }
    }

    public GcFindAttributeDefNames assignAscending(Boolean isAscending) {
        this.ascending = isAscending;
        return this;
    }

    public GcFindAttributeDefNames assignPageNumber(Integer thePageNumber) {
        this.pageNumber = thePageNumber;
        return this;
    }

    public GcFindAttributeDefNames assignPageSize(Integer thePageSize) {
        this.pageSize = thePageSize;
        return this;
    }

    public GcFindAttributeDefNames assignSortString(String theSortString) {
        this.sortString = theSortString;
        return this;
    }

    public GcFindAttributeDefNames assignPageIsCursor(Boolean pageIsCursor) {
        this.pageIsCursor = pageIsCursor;
        return this;
    }

    public GcFindAttributeDefNames assignPageLastCursorField(String pageLastCursorField) {
        this.pageLastCursorField = pageLastCursorField;
        return this;
    }

    public GcFindAttributeDefNames assignPageLastCursorFieldType(String pageLastCursorFieldType) {
        this.pageLastCursorFieldType = pageLastCursorFieldType;
        return this;
    }

    public GcFindAttributeDefNames assignPageCursorFieldIncludesLastRetrieved(Boolean pageCursorFieldIncludesLastRetrieved) {
        this.pageCursorFieldIncludesLastRetrieved = pageCursorFieldIncludesLastRetrieved;
        return this;
    }

    public WsFindAttributeDefNamesResults execute() {
        this.validate();
        WsFindAttributeDefNamesResults wsFindAttributeDefNamesResults = null;
        try {
            WsRestFindAttributeDefNamesRequest findAttributeDefNames = new WsRestFindAttributeDefNamesRequest();
            findAttributeDefNames.setActAsSubjectLookup(this.actAsSubject);
            if (this.params.size() > 0) {
                findAttributeDefNames.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            ArrayList<WsAttributeDefNameLookup> attributeDefNameLookups = new ArrayList<WsAttributeDefNameLookup>();
            for (String attributeDefNameName : this.attributeDefNameNames) {
                attributeDefNameLookups.add(new WsAttributeDefNameLookup(attributeDefNameName, null));
            }
            for (String attributeDefNameUuid : this.attributeDefNameUuids) {
                attributeDefNameLookups.add(new WsAttributeDefNameLookup(null, attributeDefNameUuid));
            }
            for (Long attributeDefNameIdIndex : this.attributeDefNameIdIndexes) {
                attributeDefNameLookups.add(new WsAttributeDefNameLookup(null, null, attributeDefNameIdIndex.toString()));
            }
            findAttributeDefNames.setWsAttributeDefNameLookups(GrouperClientUtils.toArray(attributeDefNameLookups, WsAttributeDefNameLookup.class));
            if (!(GrouperClientUtils.isBlank(this.nameOfAttributeDef) && GrouperClientUtils.isBlank(this.uuidOfAttributeDef) && GrouperClientUtils.isBlank(this.idIndexOfAttributeDef))) {
                WsAttributeDefLookup attributeDefLookup = null;
                attributeDefLookup = new WsAttributeDefLookup(this.nameOfAttributeDef, this.uuidOfAttributeDef, this.idIndexOfAttributeDef == null ? null : this.idIndexOfAttributeDef.toString());
                findAttributeDefNames.setWsAttributeDefLookup(attributeDefLookup);
            }
            if (!GrouperClientUtils.isBlank(this.attributeAssignType)) {
                findAttributeDefNames.setAttributeAssignType(this.attributeAssignType);
            }
            if (!GrouperClientUtils.isBlank(this.attributeDefType)) {
                findAttributeDefNames.setAttributeDefType(this.attributeDefType);
            }
            if (!GrouperClientUtils.isBlank(this.inheritanceSetRelation)) {
                findAttributeDefNames.setWsInheritanceSetRelation(this.inheritanceSetRelation);
            }
            if (!GrouperClientUtils.isBlank(this.sortString)) {
                findAttributeDefNames.setSortString(this.sortString);
            }
            if (this.ascending != null) {
                findAttributeDefNames.setAscending(this.ascending != false ? "T" : "F");
            }
            if (this.pageNumber != null) {
                findAttributeDefNames.setPageNumber(Integer.toString(this.pageNumber));
            }
            if (this.pageSize != null) {
                findAttributeDefNames.setPageSize(Integer.toString(this.pageSize));
            }
            if (!GrouperClientUtils.isBlank(this.scope)) {
                findAttributeDefNames.setScope(this.scope);
            }
            if (this.splitScope != null) {
                findAttributeDefNames.setSplitScope(this.splitScope != false ? "T" : "F");
            }
            if (this.serviceRole != null) {
                findAttributeDefNames.setServiceRole(this.serviceRole);
            }
            if (this.subjectLookup != null) {
                findAttributeDefNames.setSubjectLookup(this.subjectLookup);
            }
            if (this.pageIsCursor != null) {
                findAttributeDefNames.setPageIsCursor(this.pageIsCursor != false ? "T" : "F");
            }
            if (this.pageCursorFieldIncludesLastRetrieved != null) {
                findAttributeDefNames.setPageCursorFieldIncludesLastRetrieved(this.pageCursorFieldIncludesLastRetrieved != false ? "T" : "F");
            }
            findAttributeDefNames.setPageLastCursorField(this.pageLastCursorField);
            findAttributeDefNames.setPageLastCursorFieldType(this.pageLastCursorFieldType);
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsFindAttributeDefNamesResults = (WsFindAttributeDefNamesResults)grouperClientWs.executeService("attributeDefNames", findAttributeDefNames, "findAttributeDefNames", this.clientVersion, true);
            String resultMessage = wsFindAttributeDefNamesResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsFindAttributeDefNamesResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsFindAttributeDefNamesResults;
    }

    public GcFindAttributeDefNames addAttributeDefNameName(String theAttributeDefNameName) {
        this.attributeDefNameNames.add(theAttributeDefNameName);
        return this;
    }

    public GcFindAttributeDefNames addAttributeDefNameUuid(String theAttributeDefNameUuid) {
        this.attributeDefNameUuids.add(theAttributeDefNameUuid);
        return this;
    }

    public GcFindAttributeDefNames addAttributeDefNameIdIndex(Long theAttributeDefNameIdIndex) {
        this.attributeDefNameIdIndexes.add(theAttributeDefNameIdIndex);
        return this;
    }

    public GcFindAttributeDefNames assignNameOfAttributeDef(String theNameOfAttributeDef) {
        this.nameOfAttributeDef = theNameOfAttributeDef;
        return this;
    }

    public GcFindAttributeDefNames assignUuidOfAttributeDef(String theUuidOfAttributeDef) {
        this.uuidOfAttributeDef = theUuidOfAttributeDef;
        return this;
    }

    public GcFindAttributeDefNames assignIdIndexOfAttributeDef(Long theIdIndexOfAttributeDef) {
        this.idIndexOfAttributeDef = theIdIndexOfAttributeDef;
        return this;
    }
}

