/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupDeleteResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGroupDeleteRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.List;

public class GcGroupDelete {
    private List<WsGroupLookup> groupLookups = new ArrayList<WsGroupLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private GcTransactionType txType;
    private Boolean includeGroupDetail;
    private String clientVersion;

    public GcGroupDelete addGroupLookup(WsGroupLookup wsGroupLookup) {
        this.groupLookups.add(wsGroupLookup);
        return this;
    }

    public GcGroupDelete addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGroupDelete addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGroupDelete assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.groupLookups) == 0) {
            throw new RuntimeException("Need at least one group to delete: " + this);
        }
    }

    public GcGroupDelete assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public GcGroupDelete assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGroupDelete assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public WsGroupDeleteResults execute() {
        this.validate();
        WsGroupDeleteResults wsGroupDeleteResults = null;
        try {
            WsRestGroupDeleteRequest groupDelete = new WsRestGroupDeleteRequest();
            groupDelete.setActAsSubjectLookup(this.actAsSubject);
            groupDelete.setTxType(this.txType == null ? null : this.txType.name());
            if (this.includeGroupDetail != null) {
                groupDelete.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            groupDelete.setWsGroupLookups(GrouperClientUtils.toArray(this.groupLookups, WsGroupLookup.class));
            if (this.params.size() > 0) {
                groupDelete.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGroupDeleteResults = (WsGroupDeleteResults)grouperClientWs.executeService("groups", groupDelete, "groupDelete", this.clientVersion, false);
            String resultMessage = wsGroupDeleteResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGroupDeleteResults, wsGroupDeleteResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGroupDeleteResults;
    }
}

