/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.examples;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapExample2 {
    public static DirContext context(String url, String user, String pass) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "uid=" + user + ",ou=entities,dc=upenn,dc=edu");
        env.put("java.naming.security.credentials", pass);
        InitialDirContext context = new InitialDirContext(env);
        return context;
    }

    public static void main(String[] args) throws Exception {
        LdapExample2.testLdap();
    }

    private static void testLdap() throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(new File("r:/accounts/penngroups.properties")));
        String user = properties.getProperty("user");
        String pass = properties.getProperty("pass");
        String url = properties.getProperty("url");
        DirContext dirContext = LdapExample2.context(url, user, pass);
        SearchControls sc = new SearchControls();
        String[] attributeFilter = new String[]{"hasMember"};
        sc.setReturningAttributes(attributeFilter);
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search("ou=groups", "(cn=test:isc:ait:apps:atlassian*)", sc);
        System.out.println("grouperSession = GrouperSession.startRootSession();\n");
        StringBuilder memberships = new StringBuilder();
        while (namingEnumeration.hasMore()) {
            SearchResult nextElement;
            SearchResult searchResult = nextElement = namingEnumeration.next();
            String groupName = searchResult.getNameInNamespace();
            groupName = groupName.substring("cn=".length(), groupName.length() - ",ou=groups,dc=upenn,dc=edu".length()).trim();
            System.out.println("new GroupSave(grouperSession).assignName(\"" + groupName + "\").assignCreateParentStemsIfNotExist(true).save();");
            Attributes attributes = searchResult.getAttributes();
            NamingEnumeration<? extends Attribute> attributeEnumeration = attributes.getAll();
            while (attributeEnumeration.hasMore()) {
                Attribute attribute = attributeEnumeration.next();
                if (!"hasMember".equals(attribute.getID())) continue;
                NamingEnumeration<?> attributeValues = attribute.getAll();
                while (attributeValues.hasMore()) {
                    String netId = (String)attributeValues.next();
                    memberships.append("addMember(\"" + groupName + "\", \"" + netId + "\");\n");
                }
            }
        }
        System.out.println("");
        System.out.println(memberships.toString());
    }
}

