/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.failover;

import edu.internet2.middleware.grouperClient.GrouperClientState;
import edu.internet2.middleware.grouperClient.failover.FailoverConfig;
import edu.internet2.middleware.grouperClient.failover.FailoverLogic;
import edu.internet2.middleware.grouperClient.failover.FailoverLogicBean;
import edu.internet2.middleware.grouperClient.util.ExpirableCache;
import edu.internet2.middleware.grouperClient.util.GrouperClientCommonUtils;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FailoverClient
implements Serializable {
    private static Log LOG = GrouperClientUtils.retrieveLog(FailoverClient.class);
    private transient FailoverConfig failoverConfig;
    private static Map<String, FailoverConfig> failoverConfigMap = new TreeMap<String, FailoverConfig>();
    static boolean failoverStateFileSet = false;
    static File failoverStateFile = null;
    static TreeMap<String, FailoverClient> instanceMapFromType = null;
    Map<String, ExpirableCache<Long, Long>> errorCountPerMinute = new HashMap<String, ExpirableCache<Long, Long>>();
    ExpirableCache<Boolean, String> connectionAffinityCache = null;
    static long fatalProblemCountForTesting = 0L;
    static long timeoutCountForTesting = 0L;
    static long errorCountForTesting = 0L;
    private static Random random = new Random();
    private static Long startupMillis = null;

    public FailoverConfig getFailoverConfig() {
        return this.failoverConfig;
    }

    public void setFailoverConfig(FailoverConfig failoverConfig1) {
        this.failoverConfig = failoverConfig1;
    }

    private FailoverClient() {
    }

    static File fileSaveFailoverClientState() {
        int saveStateEverySeconds;
        boolean hasSaveStateEverySeconds;
        boolean hasCacheDirectory;
        if (failoverStateFileSet) {
            return failoverStateFile;
        }
        String cacheDirectoryName = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.cacheDirectory");
        boolean bl = hasCacheDirectory = !GrouperClientUtils.isBlank(cacheDirectoryName);
        if (hasCacheDirectory) {
            cacheDirectoryName = GrouperClientUtils.cacheDirectoryName();
        }
        boolean bl2 = hasSaveStateEverySeconds = (saveStateEverySeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.saveFailoverStateEverySeconds", -1)) >= 0;
        if (hasSaveStateEverySeconds && !hasCacheDirectory) {
            throw new RuntimeException("You have grouperClient.saveFailoverStateEverySeconds set in the grouper.properties but you do not have grouperClient.cacheDirectory set, you need a directory to save the file");
        }
        failoverStateFileSet = true;
        if (!hasSaveStateEverySeconds) {
            return null;
        }
        failoverStateFile = new File(cacheDirectoryName + File.separator + "grouperClientFailoverState.bin");
        return failoverStateFile;
    }

    public static void main(String[] args) {
        File saveStateFile = FailoverClient.fileSaveFailoverClientState();
        TreeMap map = (TreeMap)GrouperClientUtils.unserializeObjectFromFile(saveStateFile, false, true);
        System.out.println("map size: " + map.size());
        for (String key : map.keySet()) {
            FailoverClient failoverClient2 = (FailoverClient)map.get(key);
            System.out.println("affinity: " + key + " affinity: " + (failoverClient2.connectionAffinityCache == null ? null : failoverClient2.connectionAffinityCache.get(Boolean.TRUE)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TreeMap<String, FailoverClient> instanceMapFromType() {
        if (instanceMapFromType == null) {
            LinkedHashMap<String, String> debugMap = new LinkedHashMap<String, String>();
            if (debugMap != null) {
                debugMap.put("method", "FailoverClient.instanceMapFromType");
            }
            try {
                int saveStateEverySeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.saveFailoverStateEverySeconds", -1);
                File saveStateFile = FailoverClient.fileSaveFailoverClientState();
                if (saveStateEverySeconds >= 0) {
                    try {
                        if (debugMap != null) {
                            debugMap.put("read failover state from file", saveStateFile.getAbsolutePath());
                        }
                        instanceMapFromType = (TreeMap)GrouperClientUtils.unserializeObjectFromFile(saveStateFile, false, true);
                        if (debugMap != null) {
                            debugMap.put("success", "true");
                            if (instanceMapFromType != null) {
                                for (String key : instanceMapFromType.keySet()) {
                                    FailoverClient failoverClient = instanceMapFromType.get(key);
                                    debugMap.put("failoverClient " + key + " hash", Integer.toHexString(failoverClient.hashCode()));
                                    debugMap.put("failoverClient " + key + " cache hash", Integer.toHexString(failoverClient.connectionAffinityCache.hashCode()));
                                    debugMap.put("failoverClient " + key + " affinity", failoverClient.connectionAffinityCache == null ? null : failoverClient.connectionAffinityCache.get(Boolean.TRUE));
                                }
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        if (debugMap != null) {
                            debugMap.put("success", "false");
                        }
                        LOG.error("Cant unserialize failover state file, deleting it: " + (saveStateFile == null ? null : saveStateFile.getAbsolutePath()), e);
                        GrouperClientUtils.deleteFile(saveStateFile);
                    }
                }
                if (instanceMapFromType == null) {
                    instanceMapFromType = new TreeMap();
                }
            }
            finally {
                if (debugMap != null) {
                    LOG.debug(GrouperClientUtils.mapToString(debugMap));
                }
            }
        }
        return instanceMapFromType;
    }

    static FailoverClient failoverClient(String connectionType) {
        FailoverClient failoverClient = FailoverClient.instanceMapFromType().get(connectionType);
        if (failoverClient == null) {
            throw new RuntimeException("Why is failover client not initialized for type: '" + connectionType + "', call the initFailoverClient() method before this method");
        }
        if (failoverClient.failoverConfig == null) {
            failoverClient.failoverConfig = failoverConfigMap.get(connectionType);
        }
        return failoverClient;
    }

    private static long minutesSince1970() {
        return System.currentTimeMillis() / 1000L / 60L;
    }

    private void incrementErrorForConnection(String connectionName) {
        Long currentCount;
        ExpirableCache<Long, Long> errorCount = this.errorCountPerMinute(connectionName);
        Long minutesSince1970 = FailoverClient.minutesSince1970();
        Long l = currentCount = GrouperClientUtils.defaultIfNull(errorCount.get(minutesSince1970), 0L);
        Long l2 = currentCount = Long.valueOf(currentCount + 1L);
        errorCount.put(minutesSince1970, currentCount);
    }

    private long errorsForConnection(String connectionName, long minutesSince1970) {
        long errors = 0L;
        ExpirableCache<Long, Long> errorCache = this.errorCountPerMinute(connectionName);
        for (int i = 0; i < this.failoverConfig.getMinutesToKeepErrors() + 1; ++i) {
            Long currentErrors = errorCache.get(minutesSince1970 - (long)i);
            if (currentErrors == null) continue;
            errors += currentErrors.longValue();
        }
        return errors;
    }

    private ExpirableCache<Long, Long> errorCountPerMinute(String connectionName) {
        ExpirableCache<Long, Long> errorCache = this.errorCountPerMinute.get(connectionName);
        if (errorCache == null) {
            int minutesToCheck = this.failoverConfig.getMinutesToKeepErrors();
            errorCache = new ExpirableCache(minutesToCheck + 1);
            this.errorCountPerMinute.put(connectionName, errorCache);
        }
        return errorCache;
    }

    public static synchronized void initFailoverClient(FailoverConfig failoverConfig) {
        FailoverClient failoverClient = FailoverClient.instanceMapFromType().get(failoverConfig.getConnectionType());
        if (failoverClient == null) {
            failoverClient = new FailoverClient();
            FailoverClient.instanceMapFromType().put(failoverConfig.getConnectionType(), failoverClient);
        }
        failoverClient.setFailoverConfig(failoverConfig);
        failoverConfigMap.put(failoverConfig.getConnectionType(), failoverConfig);
        failoverConfig.getAffinitySeconds();
        int affinitySeconds = failoverConfig.getAffinitySeconds();
        if (affinitySeconds < 1) {
            affinitySeconds = 1;
        }
        if (failoverClient.connectionAffinityCache == null || failoverClient.connectionAffinityCache.getDefaultTimeToLiveInMillis() / 1000L != (long)affinitySeconds) {
            failoverClient.connectionAffinityCache = new ExpirableCache(ExpirableCache.ExpirableCacheUnit.SECOND, affinitySeconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> orderedListOfConnectionNames() {
        LinkedHashMap<String, String> debugMap;
        LinkedHashSet resultConnectionNames = new LinkedHashSet();
        LinkedHashSet<String> connectionNamesInPool = new LinkedHashSet<String>();
        connectionNamesInPool.addAll(GrouperClientUtils.nonNull(this.failoverConfig.getConnectionNames()));
        connectionNamesInPool.addAll(GrouperClientUtils.nonNull(this.failoverConfig.getConnectionNamesSecondTier()));
        if (GrouperClientCommonUtils.length(this.failoverConfig.getConnectionNames()) + GrouperClientCommonUtils.length(this.failoverConfig.getConnectionNamesSecondTier()) == 1) {
            resultConnectionNames.addAll(connectionNamesInPool);
            return new ArrayList<String>(resultConnectionNames);
        }
        LinkedHashMap<String, String> linkedHashMap = debugMap = LOG.isDebugEnabled() ? new LinkedHashMap<String, String>() : null;
        if (debugMap != null) {
            debugMap.put("method", "FailoverClient.orderedListOfConnections");
            if (this.failoverConfig != null) {
                debugMap.put("connectionType", this.failoverConfig.getConnectionType());
            }
            debugMap.put("failoverClient hash", Integer.toHexString(this.hashCode()));
            debugMap.put("failoverClient cache hash", Integer.toHexString(this.connectionAffinityCache.hashCode()));
        }
        try {
            String affinityConnectionName = this.connectionAffinityCache.get(Boolean.TRUE);
            if (debugMap != null) {
                debugMap.put("affinityConnection", affinityConnectionName);
            }
            LinkedHashSet availableConnectionsFewestErrorsFirst = new LinkedHashSet();
            long minutesSince1970 = FailoverClient.minutesSince1970();
            HashMap<Long, LinkedHashSet<String>> connectionsForErrorCount = new HashMap<Long, LinkedHashSet<String>>();
            TreeSet<Long> numberOfErrors = new TreeSet<Long>();
            int i = 0;
            for (String connectionName : connectionNamesInPool) {
                long errors = this.errorsForConnection(connectionName, minutesSince1970);
                numberOfErrors.add(errors);
                LinkedHashSet<String> connectionNames = (LinkedHashSet<String>)connectionsForErrorCount.get(errors);
                if (connectionNames == null) {
                    connectionNames = new LinkedHashSet<String>();
                    connectionsForErrorCount.put(errors, connectionNames);
                }
                connectionNames.add(connectionName);
                if (debugMap != null) {
                    debugMap.put("connection." + i, connectionName + ", errors: " + errors);
                }
                ++i;
            }
            Object object = numberOfErrors.iterator();
            while (object.hasNext()) {
                long errors = (Long)object.next();
                Set connectionNames = (Set)connectionsForErrorCount.get(errors);
                if (connectionNames.size() == 1) {
                    availableConnectionsFewestErrorsFirst.add(connectionNames.iterator().next());
                    continue;
                }
                if (availableConnectionsFewestErrorsFirst.size() == 0) {
                    if (!GrouperClientUtils.isBlank(affinityConnectionName) && connectionNames.contains(affinityConnectionName)) {
                        if (debugMap != null) {
                            debugMap.put("found affinity", affinityConnectionName);
                        }
                        availableConnectionsFewestErrorsFirst.add(affinityConnectionName);
                        connectionNames.remove(affinityConnectionName);
                        availableConnectionsFewestErrorsFirst.addAll(connectionNames);
                        continue;
                    }
                    if (this.failoverConfig.getFailoverStrategy() == null || this.failoverConfig.getFailoverStrategy() == FailoverConfig.FailoverStrategy.activeActive) {
                        HashSet<String> bestTierConnectionNames = new HashSet<String>();
                        if (GrouperClientUtils.length(this.failoverConfig.getConnectionNamesSecondTier()) == 0) {
                            bestTierConnectionNames.addAll(this.failoverConfig.getConnectionNames());
                        } else if (GrouperClientUtils.length(this.failoverConfig.getConnectionNames()) == 0) {
                            bestTierConnectionNames.addAll(this.failoverConfig.getConnectionNamesSecondTier());
                        } else {
                            for (String firstTierName : GrouperClientUtils.nonNull(this.failoverConfig.getConnectionNames())) {
                                if (!connectionNames.contains(firstTierName)) continue;
                                bestTierConnectionNames.add(firstTierName);
                            }
                            if (bestTierConnectionNames.size() == 0) {
                                bestTierConnectionNames.addAll(connectionNames);
                            }
                        }
                        int index = random.nextInt(bestTierConnectionNames.size());
                        String bestConnection = (String)GrouperClientUtils.get(bestTierConnectionNames, index);
                        availableConnectionsFewestErrorsFirst.add(bestConnection);
                        connectionNames.remove(bestConnection);
                        this.connectionAffinityCache.put(Boolean.TRUE, bestConnection);
                        if (debugMap != null) {
                            debugMap.put("Setting affinity", bestConnection);
                        }
                    } else {
                        for (String connectionName : connectionNamesInPool) {
                            if (!connectionNames.contains(connectionName)) continue;
                            if (availableConnectionsFewestErrorsFirst.size() == 0) {
                                if (debugMap != null) {
                                    debugMap.put("Setting affinity", connectionName);
                                }
                                this.connectionAffinityCache.put(Boolean.TRUE, connectionName);
                            }
                            availableConnectionsFewestErrorsFirst.add(connectionName);
                            connectionNames.remove(connectionName);
                        }
                    }
                }
                for (String connectionName : connectionNames) {
                    if (availableConnectionsFewestErrorsFirst.contains(connectionName)) continue;
                    availableConnectionsFewestErrorsFirst.add(connectionName);
                }
            }
            for (String connectionName : connectionNamesInPool) {
                if (availableConnectionsFewestErrorsFirst.contains(connectionName)) continue;
                availableConnectionsFewestErrorsFirst.add(connectionName);
            }
            if (debugMap != null) {
                debugMap.put("affinityConnectionPost", this.connectionAffinityCache.get(Boolean.TRUE));
            }
            object = new ArrayList(availableConnectionsFewestErrorsFirst);
            return object;
        }
        finally {
            if (debugMap != null) {
                LOG.debug(GrouperClientUtils.mapToString(debugMap));
            }
        }
    }

    public static <T> T failoverLogic(String connectionType, FailoverLogic<T> failoverLogic) {
        return FailoverClient.failoverLogic(connectionType, true, failoverLogic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T failoverLogic(String connectionType, boolean useThreads, FailoverLogic<T> failoverLogic) {
        LinkedHashMap<String, Object> debugMap;
        LinkedHashMap<String, Object> linkedHashMap = debugMap = LOG.isDebugEnabled() ? new LinkedHashMap<String, Object>() : null;
        if (debugMap != null) {
            debugMap.put("method", "FailoverClient.failoverLogic");
        }
        try {
            T t;
            FailoverClient failoverClient = FailoverClient.failoverClient(connectionType);
            try {
                t = failoverClient.internal_failoverLogic(useThreads, failoverLogic);
            }
            catch (Throwable throwable) {
                int saveStateEverySeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.saveFailoverStateEverySeconds", -1);
                if (debugMap != null) {
                    debugMap.put("saveStateEverySeconds", saveStateEverySeconds);
                }
                File saveStateFile = FailoverClient.fileSaveFailoverClientState();
                if (saveStateEverySeconds > -1) {
                    boolean saveStateNow;
                    boolean bl = saveStateNow = saveStateEverySeconds == 0 || saveStateFile.lastModified() < System.currentTimeMillis() - (long)(saveStateEverySeconds * 1000);
                    if (saveStateNow) {
                        if (debugMap != null) {
                            debugMap.put("savingStateToFile", saveStateFile.getAbsolutePath());
                        }
                        try {
                            GrouperClientUtils.serializeObjectToFile(instanceMapFromType, saveStateFile);
                        }
                        catch (Throwable t2) {
                            LOG.warn("Problem saving grouperClientFailoverState.bin: " + t2.getMessage());
                        }
                    }
                }
                throw throwable;
            }
            int saveStateEverySeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.saveFailoverStateEverySeconds", -1);
            if (debugMap != null) {
                debugMap.put("saveStateEverySeconds", saveStateEverySeconds);
            }
            File saveStateFile = FailoverClient.fileSaveFailoverClientState();
            if (saveStateEverySeconds > -1) {
                boolean saveStateNow;
                boolean bl = saveStateNow = saveStateEverySeconds == 0 || saveStateFile.lastModified() < System.currentTimeMillis() - (long)(saveStateEverySeconds * 1000);
                if (saveStateNow) {
                    if (debugMap != null) {
                        debugMap.put("savingStateToFile", saveStateFile.getAbsolutePath());
                    }
                    try {
                        GrouperClientUtils.serializeObjectToFile(instanceMapFromType, saveStateFile);
                    }
                    catch (Throwable t3) {
                        LOG.warn("Problem saving grouperClientFailoverState.bin: " + t3.getMessage());
                    }
                }
            }
            return t;
        }
        finally {
            if (debugMap != null) {
                LOG.debug(GrouperClientUtils.mapToString(debugMap));
            }
        }
    }

    private <T> T internal_failoverLogic(boolean useThreads, final FailoverLogic<T> failoverLogic) {
        Map<String, Object> debugMap;
        Map<String, Object> map = debugMap = LOG.isDebugEnabled() ? Collections.synchronizedMap(new LinkedHashMap()) : null;
        if (debugMap != null) {
            debugMap.put("method", "FailoverClient.internal_failoverLogic");
        }
        try {
            long secondsSinceStartup;
            final List<String> orderedConnections = this.orderedListOfConnectionNames();
            int timeoutSeconds = this.failoverConfig.getTimeoutSeconds();
            if (startupMillis == null) {
                startupMillis = System.currentTimeMillis();
            }
            if (this.failoverConfig.getSecondsForClassesToLoad() > 0 && (secondsSinceStartup = (System.currentTimeMillis() - startupMillis) / 1000L) < (long)this.failoverConfig.getSecondsForClassesToLoad()) {
                timeoutSeconds = (int)((long)timeoutSeconds + ((long)this.failoverConfig.getSecondsForClassesToLoad() - secondsSinceStartup));
            }
            if (debugMap != null) {
                debugMap.put("type", this.failoverConfig.getConnectionType());
                debugMap.put("connections", GrouperClientUtils.length(orderedConnections));
            }
            if (GrouperClientUtils.length(orderedConnections) == 0) {
                throw new RuntimeException("Why are there no connections for type: " + this.failoverConfig.getConnectionType());
            }
            if (GrouperClientUtils.length(orderedConnections) == 1) {
                String theFailoverConnectionName = orderedConnections.get(0);
                if (debugMap != null) {
                    debugMap.put("Not load balancing", "connection type: " + this.failoverConfig.getConnectionType() + ", name: " + theFailoverConnectionName);
                }
                T t = failoverLogic.logic(new FailoverLogicBean(false, theFailoverConnectionName, true));
                return t;
            }
            final Object[] results = new Object[orderedConnections.size()];
            final Boolean[] successes = new Boolean[orderedConnections.size()];
            if (!GrouperClientConfig.retrieveConfig().propertyValueBoolean("grouperClient.failoverClientUseThreads", true)) {
                useThreads = false;
            }
            for (int i = 0; i < orderedConnections.size(); ++i) {
                int index;
                int waitMore;
                String id;
                final int I = i;
                final String connectionName = orderedConnections.get(i);
                String string = id = LOG.isDebugEnabled() ? GrouperClientUtils.uniqueId() : null;
                if (!useThreads) {
                    try {
                        long startNanos = -1L;
                        if (debugMap != null) {
                            debugMap.put("Try " + I + " conn", connectionName);
                            startNanos = System.nanoTime();
                        }
                        results[I] = failoverLogic.logic(new FailoverLogicBean(false, connectionName, i == orderedConnections.size() - 1));
                        if (debugMap != null) {
                            debugMap.put("Finish " + I + " conn in " + (System.nanoTime() - startNanos) / 1000000L + "ms", connectionName);
                        }
                        successes[I] = true;
                    }
                    catch (Throwable e) {
                        if (debugMap != null) {
                            debugMap.put("Error " + I + " conn", e.getMessage());
                        }
                        results[I] = e;
                        successes[I] = false;
                    }
                } else {
                    final GrouperClientState GROUPER_CLIENT_STATE = GrouperClientState.retrieveGrouperClientState(false);
                    Callable callable = new Callable<T>(){

                        @Override
                        public T call() throws Exception {
                            GrouperClientState.assignGrouperClientState(GROUPER_CLIENT_STATE);
                            try {
                                long startNanos = -1L;
                                if (debugMap != null) {
                                    debugMap.put("Try " + I + " thread conn", connectionName + ", id: " + id);
                                    startNanos = System.nanoTime();
                                }
                                results[I] = failoverLogic.logic(new FailoverLogicBean(true, connectionName, I == orderedConnections.size() - 1));
                                if (debugMap != null) {
                                    debugMap.put("Finish " + I + " thread conn in " + (System.nanoTime() - startNanos) / 1000000L + "ms", connectionName + ", id: " + id);
                                }
                                successes[I] = true;
                            }
                            catch (Throwable e) {
                                if (debugMap != null) {
                                    debugMap.put("Error " + I + " thread conn", connectionName + ", id: " + id + ", " + e.getMessage());
                                }
                                results[I] = e;
                                successes[I] = false;
                            }
                            finally {
                                GrouperClientState.removeGrouperClientState();
                            }
                            return null;
                        }
                    };
                    Future future = GrouperClientCommonUtils.retrieveExecutorService().submit(callable);
                    try {
                        if (debugMap != null) {
                            debugMap.put("Wait for " + timeoutSeconds + " secs: " + I, connectionName + ", id: " + id);
                        }
                        future.get(timeoutSeconds, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        LOG.debug("error:", e);
                    }
                }
                if (successes[i] != null && successes[i].booleanValue()) {
                    if (debugMap != null) {
                        debugMap.put("Success: " + I, connectionName + ", id: " + id + ", add to affinity cache");
                    }
                    this.connectionAffinityCache.put(Boolean.TRUE, connectionName);
                    Object GROUPER_CLIENT_STATE = results[i];
                    return (T)GROUPER_CLIENT_STATE;
                }
                this.incrementErrorForConnection(connectionName);
                boolean isFatal = i == orderedConnections.size() - 1;
                boolean isException = results[i] instanceof Throwable;
                String typeString = isException ? "error" : "timeout";
                RuntimeException re = null;
                if (isException) {
                    ++errorCountForTesting;
                } else {
                    ++timeoutCountForTesting;
                }
                if (isException) {
                    re = results[i] instanceof RuntimeException ? (RuntimeException)results[i] : new RuntimeException((Throwable)results[i]);
                }
                if (isFatal && (waitMore = this.failoverConfig.getExtraTimeoutSeconds()) >= 0) {
                    block11: for (int seconds = 0; seconds < waitMore; ++seconds) {
                        boolean hasTimeouts = false;
                        for (index = 0; index <= i; ++index) {
                            if (successes[index] != null && successes[index].booleanValue()) {
                                isFatal = false;
                                break block11;
                            }
                            if (successes[index] != null) continue;
                            hasTimeouts = true;
                        }
                        if (!hasTimeouts) break;
                        GrouperClientCommonUtils.sleep(1000L);
                    }
                }
                String severityString = isFatal ? "FATAL" : "NON-FATAL";
                RuntimeException thisStack = new RuntimeException("this stack");
                String objectToLog = severityString + " " + typeString + " in failover connection: " + connectionName + "," + (isFatal ? "" : " will try others in pool") + " (" + errorCountForTesting + " total errors, " + timeoutCountForTesting + " total timeouts, " + fatalProblemCountForTesting + " total fatal errors): [THIS STACK]: " + GrouperClientUtils.getFullStackTrace(thisStack);
                if (isException) {
                    if (isFatal) {
                        LOG.error(objectToLog, re);
                    } else {
                        LOG.warn(objectToLog, re);
                    }
                } else if (isFatal) {
                    LOG.error(objectToLog);
                } else {
                    LOG.warn(objectToLog);
                }
                if (isFatal) {
                    ++fatalProblemCountForTesting;
                    if (isException) {
                        GrouperClientUtils.injectInException(re, objectToLog);
                        throw re;
                    }
                    throw new RuntimeException(objectToLog);
                }
                for (index = 0; index < successes.length; ++index) {
                    if (successes[index] == null || !successes[index].booleanValue()) continue;
                    if (debugMap != null) {
                        debugMap.put("Final success for " + index, "add to affinity cache: " + orderedConnections.get(index));
                    }
                    this.connectionAffinityCache.put(Boolean.TRUE, orderedConnections.get(index));
                    Object object = results[index];
                    return (T)object;
                }
            }
            throw new RuntimeException("Shouldnt get here");
        }
        finally {
            if (debugMap != null) {
                LOG.debug(GrouperClientUtils.mapToString(debugMap));
            }
        }
    }
}

