/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.failover;

import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.util.ArrayList;
import java.util.List;

public class FailoverConfig {
    private int secondsForClassesToLoad = -1;
    private String connectionType;
    private List<String> connectionNames;
    private List<String> connectionNamesSecondTier;
    private int minutesToKeepErrors = -1;
    private int affinitySeconds = 28800;
    private int timeoutSeconds = 30;
    private int extraTimeoutSeconds = 15;
    private FailoverStrategy failoverStrategy;

    public void copyFromArgument(FailoverConfig failoverConfig) {
        this.affinitySeconds = failoverConfig.affinitySeconds;
        this.connectionNames = failoverConfig.connectionNames == null ? null : new ArrayList<String>(failoverConfig.connectionNames);
        this.connectionNamesSecondTier = failoverConfig.connectionNamesSecondTier == null ? null : new ArrayList<String>(failoverConfig.connectionNamesSecondTier);
        this.connectionType = failoverConfig.connectionType;
        this.extraTimeoutSeconds = failoverConfig.extraTimeoutSeconds;
        this.failoverStrategy = failoverConfig.failoverStrategy;
        this.minutesToKeepErrors = failoverConfig.minutesToKeepErrors;
        this.secondsForClassesToLoad = failoverConfig.secondsForClassesToLoad;
        this.timeoutSeconds = failoverConfig.timeoutSeconds;
    }

    public FailoverConfig() {
        int minutesToKeepErrors = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.minutesToKeepErrors", 5);
        this.setMinutesToKeepErrors(minutesToKeepErrors);
        int secondsForClassesToLoad = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.secondsForClassesToLoad", 20);
        this.setSecondsForClassesToLoad(secondsForClassesToLoad);
    }

    public int getSecondsForClassesToLoad() {
        return this.secondsForClassesToLoad;
    }

    public void setSecondsForClassesToLoad(int secondsForClassesToLoad1) {
        this.secondsForClassesToLoad = secondsForClassesToLoad1;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType1) {
        this.connectionType = connectionType1;
    }

    public List<String> getConnectionNamesSecondTier() {
        return this.connectionNamesSecondTier;
    }

    public void setConnectionNamesSecondTier(List<String> connectionNamesSecondTier1) {
        this.connectionNamesSecondTier = connectionNamesSecondTier1;
    }

    public List<String> getConnectionNames() {
        return this.connectionNames;
    }

    public void setConnectionNames(List<String> connectionNames1) {
        this.connectionNames = connectionNames1;
    }

    public int getMinutesToKeepErrors() {
        return this.minutesToKeepErrors;
    }

    public void setMinutesToKeepErrors(int minutesToKeepErrors1) {
        this.minutesToKeepErrors = minutesToKeepErrors1;
    }

    public FailoverStrategy getFailoverStrategy() {
        return this.failoverStrategy;
    }

    public void setFailoverStrategy(FailoverStrategy failoverStrategy1) {
        this.failoverStrategy = failoverStrategy1;
    }

    public int getAffinitySeconds() {
        return this.affinitySeconds;
    }

    public void setAffinitySeconds(int affinitySeconds1) {
        this.affinitySeconds = affinitySeconds1;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(int timeoutSeconds1) {
        this.timeoutSeconds = timeoutSeconds1;
    }

    public int getExtraTimeoutSeconds() {
        return this.extraTimeoutSeconds;
    }

    public void setExtraTimeoutSeconds(int extraTimeoutSeconds1) {
        this.extraTimeoutSeconds = extraTimeoutSeconds1;
    }

    public static enum FailoverStrategy {
        activeActive,
        activeStandby;


        public static FailoverStrategy valueOfIgnoreCase(String string, boolean exceptionOnNull) {
            if (GrouperClientUtils.equalsIgnoreCase("active/active", string)) {
                return activeActive;
            }
            if (GrouperClientUtils.equalsIgnoreCase("active/standby", string)) {
                return activeStandby;
            }
            return GrouperClientUtils.enumValueOfIgnoreCase(FailoverStrategy.class, string, exceptionOnNull);
        }
    }
}

