/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.jdbc.GcDbQueryCache;
import java.util.HashMap;
import java.util.Iterator;

public class GcDbQueryCacheMap
extends HashMap<MultiKey, GcDbQueryCache> {
    private static final long serialVersionUID = 8631754376159267786L;
    private Long lastEvictMillis = System.currentTimeMillis();
    private Long evictMillis = 30000L;

    public GcDbQueryCacheMap() {
        Thread janitor = new Thread(new Janitor(this));
        janitor.setDaemon(true);
        janitor.start();
    }

    @Override
    public synchronized GcDbQueryCache get(Object key) {
        this.checkEvict();
        GcDbQueryCache dbQueryCache = (GcDbQueryCache)super.get(key);
        if (dbQueryCache == null) {
            return null;
        }
        if (dbQueryCache.expired()) {
            this.remove(dbQueryCache);
            return null;
        }
        return dbQueryCache;
    }

    private synchronized void checkEvict() {
        if (System.currentTimeMillis() > this.lastEvictMillis + this.evictMillis) {
            Iterator values = this.values().iterator();
            while (values.hasNext()) {
                GcDbQueryCache dbQueryCache = (GcDbQueryCache)values.next();
                if (!dbQueryCache.expired()) continue;
                values.remove();
            }
            this.lastEvictMillis = System.currentTimeMillis();
        }
    }

    public class Janitor
    implements Runnable {
        private GcDbQueryCacheMap dbQueryCacheMap;

        public Janitor(GcDbQueryCacheMap _dbQueryCacheMap) {
            this.dbQueryCacheMap = _dbQueryCacheMap;
        }

        @Override
        public void run() {
            while (true) {
                this.dbQueryCacheMap.get(new MultiKey(null, null));
                try {
                    Thread.sleep(30000L);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

