/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc;

import edu.internet2.middleware.grouperClient.jdbc.GcPersistableHelper;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMembership;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.text.WordUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;

public class GcDbVersionableGenerate {
    public static void main(String[] args) {
        GcDbVersionableGenerate.generateFor(GcGrouperSyncMembership.class);
    }

    public static void generateFor(Class<?> theClass) {
        Field[] fields = theClass.getDeclaredFields();
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        System.out.println("    //########## START GENERATED BY GcDbVersionableGenerate.java ###########");
        System.out.println("    /** save the state when retrieving from DB */");
        System.out.println("    @GcPersistableField(persist = GcPersist.dontPersist)");
        System.out.println("    private " + theClass.getSimpleName() + " dbVersion = null;");
        System.out.println("");
        System.out.println("    /**");
        System.out.println("     * take a snapshot of the data since this is what is in the db");
        System.out.println("     */");
        System.out.println("    @Override");
        System.out.println("    public void dbVersionReset() {");
        System.out.println("      //lets get the state from the db so we know what has changed");
        System.out.println("      this.dbVersion = this.clone();");
        System.out.println("    }");
        System.out.println("");
        System.out.println("    /**");
        System.out.println("     * if we need to update this object");
        System.out.println("     * @return if needs to update this object");
        System.out.println("     */");
        System.out.println("    @Override");
        System.out.println("    public boolean dbVersionDifferent() {");
        System.out.println("      return !this.equalsDeep(this.dbVersion);");
        System.out.println("    }");
        System.out.println("");
        System.out.println("    /**");
        System.out.println("     * db version");
        System.out.println("     */");
        System.out.println("    @Override");
        System.out.println("    public void dbVersionDelete() {");
        System.out.println("      this.dbVersion = null;");
        System.out.println("    }");
        System.out.println("");
        System.out.println("    /**");
        System.out.println("     * deep clone the fields in this object");
        System.out.println("     */");
        System.out.println("    @Override");
        System.out.println("    public " + theClass.getSimpleName() + " clone() {");
        System.out.println("");
        System.out.println("      " + theClass.getSimpleName() + " " + WordUtils.uncapitalize(theClass.getSimpleName()) + " = new " + theClass.getSimpleName() + "();");
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (GcPersistableHelper.isPersist(field, theClass) && !"lastUpdated".equals(field.getName())) {
                System.out.println("    " + WordUtils.uncapitalize(theClass.getSimpleName()) + "." + field.getName() + " = this." + field.getName() + ";");
                continue;
            }
            System.out.println("    //" + field.getName() + "  DONT CLONE\n");
        }
        System.out.println("");
        System.out.println("      return " + WordUtils.uncapitalize(theClass.getSimpleName()) + ";");
        System.out.println("    }");
        System.out.println("");
        System.out.println("    /**");
        System.out.println("     *");
        System.out.println("     */");
        System.out.println("    public boolean equalsDeep(Object obj) {");
        System.out.println("      if (this==obj) {");
        System.out.println("        return true;");
        System.out.println("      }");
        System.out.println("      if (obj == null) {");
        System.out.println("        return false;");
        System.out.println("      }");
        System.out.println("      if (!(obj instanceof " + theClass.getSimpleName() + ")) {");
        System.out.println("        return false;");
        System.out.println("      }");
        System.out.println("      " + theClass.getSimpleName() + " other = (" + theClass.getSimpleName() + ") obj;");
        System.out.println("");
        System.out.println("      return new EqualsBuilder()");
        System.out.println("");
        System.out.println("");
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (GcPersistableHelper.isPersist(field, theClass) && !"lastUpdated".equals(field.getName())) {
                System.out.println("        .append(this." + field.getName() + ", other." + field.getName() + ")");
                continue;
            }
            System.out.println("        //" + field.getName() + "  DONT EQUALS\n");
        }
        System.out.println("          .isEquals();");
        System.out.println("");
        System.out.println("    }");
        System.out.println("    //########## END GENERATED BY GcDbVersionableGenerate.java ###########");
    }
}

