/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.GcPersist;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableField;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncGroup;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLog;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMember;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMembership;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GcGrouperSyncMembershipDao {
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<MultiKey, GcGrouperSyncMembership> internalCacheSyncMemberships = new HashMap<MultiKey, GcGrouperSyncMembership>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncMembership> internalCacheSyncMembershipsById = new HashMap<String, GcGrouperSyncMembership>();
    private GcGrouperSync gcGrouperSync;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private boolean membershipRetrievedAllObjectsFromDb = false;

    public GcGrouperSyncMembership membershipCreateByGroupAndMember(GcGrouperSyncGroup gcGrouperSyncGroup, GcGrouperSyncMember gcGrouperSyncMember) {
        GcGrouperSyncMembership gcGrouperSyncMembership = this.membershipCreateBySyncGroupIdAndSyncMemberId(gcGrouperSyncGroup.getId(), gcGrouperSyncMember.getId());
        gcGrouperSyncMembership.setGrouperSyncGroup(gcGrouperSyncGroup);
        gcGrouperSyncMembership.setGrouperSyncMember(gcGrouperSyncMember);
        return gcGrouperSyncMembership;
    }

    public GcGrouperSyncMembership internal_membershipCreateBySyncGroupIdAndSyncMemberIdHelper(String syncGroupId, String syncMemberId) {
        GcGrouperSyncMembership gcGrouperSyncMembership = new GcGrouperSyncMembership();
        gcGrouperSyncMembership.setGrouperSync(this.getGcGrouperSync());
        gcGrouperSyncMembership.setGrouperSyncGroupId(syncGroupId);
        gcGrouperSyncMembership.setGrouperSyncMemberId(syncMemberId);
        return gcGrouperSyncMembership;
    }

    public GcGrouperSyncMembership membershipCreateBySyncGroupIdAndSyncMemberId(String syncGroupId, String syncMemberId) {
        GcGrouperSyncMembership gcGrouperSyncMembership = this.internal_membershipCreateBySyncGroupIdAndSyncMemberIdHelper(syncGroupId, syncMemberId);
        this.internal_membershipStore(gcGrouperSyncMembership);
        this.gcGrouperSync.addObjectCreatedCount(1);
        this.internal_membershipCacheAdd(gcGrouperSyncMembership);
        return gcGrouperSyncMembership;
    }

    public int membershipDelete(Collection<GcGrouperSyncMembership> gcGrouperSyncMemberships, boolean deleteLogs) {
        int[] rowDeleteCounts;
        int count = 0;
        if (GrouperClientUtils.length(gcGrouperSyncMemberships) == 0) {
            return 0;
        }
        ArrayList<List<Object>> batchBindVars = new ArrayList<List<Object>>();
        HashSet<String> logMembershipSyncIds = new HashSet<String>();
        for (GcGrouperSyncMembership gcGrouperSyncMembership : gcGrouperSyncMemberships) {
            ArrayList<String> currentBindVarRow = new ArrayList<String>();
            currentBindVarRow.add(gcGrouperSyncMembership.getId());
            batchBindVars.add(currentBindVarRow);
            logMembershipSyncIds.add(gcGrouperSyncMembership.getId());
            this.internal_membershipCacheDelete(gcGrouperSyncMembership);
        }
        String connectionName = gcGrouperSyncMemberships.iterator().next().getConnectionName();
        if (deleteLogs) {
            count += this.getGcGrouperSync().getGcGrouperSyncLogDao().internal_logDeleteBatchByOwnerIds(logMembershipSyncIds);
        }
        for (int rowDeleteCount : rowDeleteCounts = new GcDbAccess().connectionName(connectionName).sql("delete from grouper_sync_membership where id = ?").batchBindVars(batchBindVars).batchSize(this.getGcGrouperSync().batchSize()).executeBatchSql()) {
            count += rowDeleteCount;
        }
        return count;
    }

    public int membershipDelete(GcGrouperSyncMembership gcGrouperSyncMembership, boolean deleteLogs) {
        if (gcGrouperSyncMembership == null) {
            return 0;
        }
        this.internal_membershipCacheDelete(gcGrouperSyncMembership);
        int count = 0;
        if (deleteLogs) {
            count += this.getGcGrouperSync().getGcGrouperSyncLogDao().logDeleteByOwnerId(gcGrouperSyncMembership.getId());
        }
        int rowDeleteCount = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_membership where id = ?").bindVars(gcGrouperSyncMembership.getId()).executeSql();
        return count += rowDeleteCount;
    }

    public int membershipDeleteAll(boolean deleteMemberships, boolean deleteLogs) {
        this.internalCacheSyncMemberships.clear();
        this.internalCacheSyncMembershipsById.clear();
        int rowDeleteCount = 0;
        if (deleteLogs) {
            rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where grouper_sync_owner_id in ( select id from grouper_sync_membership gsg where gsg.grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
        }
        if (deleteMemberships) {
            if (deleteLogs) {
                rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where grouper_sync_owner_id in ( select id from grouper_sync_membership gsm where gsm.grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
            }
            rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_membership where grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
        }
        return rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_membership where grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
    }

    public List<GcGrouperSyncMembership> membershipRetrieveAll() {
        if (!this.membershipRetrievedAllObjectsFromDb) {
            for (GcGrouperSyncMembership gcGrouperSyncMembership : this.internal_membershipRetrieveFromDbAll()) {
                this.internal_membershipCacheAdd(gcGrouperSyncMembership);
            }
            this.membershipRetrievedAllObjectsFromDb = true;
        }
        return new ArrayList<GcGrouperSyncMembership>(this.internalCacheSyncMemberships.values());
    }

    public GcGrouperSyncMembership membershipRetrieveBySyncGroupIdAndSyncMemberId(String syncGroupId, String syncMemberId) {
        GcGrouperSyncMembership gcGrouperSyncMembership = this.internalCacheSyncMemberships.get(new MultiKey(syncGroupId, syncMemberId));
        if (gcGrouperSyncMembership == null) {
            gcGrouperSyncMembership = this.internal_membershipRetrieveFromDbBySyncGroupIdAndSyncMemberId(syncGroupId, syncMemberId);
        }
        return gcGrouperSyncMembership;
    }

    public GcGrouperSyncMembership membershipRetrieveByGroupIdAndMemberId(String groupId, String memberId) {
        GcGrouperSyncGroup gcGrouperSyncGroup = this.gcGrouperSync.getGcGrouperSyncGroupDao().groupRetrieveByGroupId(groupId);
        GcGrouperSyncMember gcGrouperSyncMember = this.gcGrouperSync.getGcGrouperSyncMemberDao().memberRetrieveByMemberId(memberId);
        if (gcGrouperSyncGroup == null || gcGrouperSyncMember == null || gcGrouperSyncGroup.getId() == null || gcGrouperSyncMember.getId() == null) {
            return null;
        }
        GcGrouperSyncMembership gcGrouperSyncMembership = this.membershipRetrieveBySyncGroupIdAndSyncMemberId(gcGrouperSyncGroup.getId(), gcGrouperSyncMember.getId());
        return gcGrouperSyncMembership;
    }

    public Map<MultiKey, GcGrouperSyncMembership> membershipRetrieveOrCreateByGroupIdsAndMemberIds(Collection<MultiKey> groupIdsAndMemberIds) {
        Map<MultiKey, GcGrouperSyncMembership> result = this.membershipRetrieveByGroupIdsAndMemberIds(groupIdsAndMemberIds);
        if (GrouperClientUtils.length(groupIdsAndMemberIds) == 0 || groupIdsAndMemberIds.size() == result.size()) {
            return result;
        }
        HashSet<MultiKey> groupIdsAndMemberIdsToCreate = new HashSet<MultiKey>(groupIdsAndMemberIds);
        groupIdsAndMemberIdsToCreate.removeAll(result.keySet());
        HashSet<String> groupIds = new HashSet<String>();
        HashSet<String> memberIds = new HashSet<String>();
        for (MultiKey groupIdAndMemberId : groupIdsAndMemberIds) {
            groupIds.add((String)groupIdAndMemberId.getKey(0));
            memberIds.add((String)groupIdAndMemberId.getKey(1));
        }
        Map<String, GcGrouperSyncGroup> groupIdToSyncGroup = this.gcGrouperSync.getGcGrouperSyncGroupDao().groupRetrieveByGroupIds(groupIds);
        Map<String, GcGrouperSyncMember> memberIdToSyncMember = this.gcGrouperSync.getGcGrouperSyncMemberDao().memberRetrieveByMemberIds(memberIds);
        HashSet<GcGrouperSyncMembership> syncMembershipsToStore = new HashSet<GcGrouperSyncMembership>();
        for (MultiKey groupIdAndMemberId : groupIdsAndMemberIdsToCreate) {
            String groupId = (String)groupIdAndMemberId.getKey(0);
            String memberId = (String)groupIdAndMemberId.getKey(1);
            GcGrouperSyncGroup gcGrouperSyncGroup = groupIdToSyncGroup.get(groupId);
            GcGrouperSyncMember gcGrouperSyncMember = memberIdToSyncMember.get(memberId);
            if (gcGrouperSyncGroup == null || gcGrouperSyncGroup.getId() == null) {
                throw new RuntimeException("Cant find group! " + groupId);
            }
            if (gcGrouperSyncMember == null || gcGrouperSyncMember.getId() == null) {
                throw new RuntimeException("Cant find member! " + memberId);
            }
            GcGrouperSyncMembership gcGrouperSyncMembership = this.internal_membershipCreateBySyncGroupIdAndSyncMemberIdHelper(gcGrouperSyncGroup.getId(), gcGrouperSyncMember.getId());
            result.put(groupIdAndMemberId, gcGrouperSyncMembership);
            syncMembershipsToStore.add(gcGrouperSyncMembership);
        }
        int changes = this.internal_membershipStore(syncMembershipsToStore);
        this.gcGrouperSync.addObjectCreatedCount(changes);
        for (GcGrouperSyncMembership gcGrouperSyncMembership : syncMembershipsToStore) {
            this.internal_membershipCacheAdd(gcGrouperSyncMembership);
        }
        return result;
    }

    public GcGrouperSyncMembership membershipRetrieveOrCreateByGroupIdAndMemberId(String groupId, String memberId) {
        GcGrouperSyncGroup gcGrouperSyncGroup = this.gcGrouperSync.getGcGrouperSyncGroupDao().groupRetrieveByGroupId(groupId);
        GcGrouperSyncMember gcGrouperSyncMember = this.gcGrouperSync.getGcGrouperSyncMemberDao().memberRetrieveByMemberId(memberId);
        if (gcGrouperSyncGroup == null) {
            throw new RuntimeException("Cant find group by groupId! " + groupId);
        }
        if (gcGrouperSyncMember == null) {
            throw new RuntimeException("Cant find member by memberId! " + groupId);
        }
        GcGrouperSyncMembership gcGrouperSyncMembership = this.membershipRetrieveOrCreateBySyncGroupIdAndSyncMemberId(gcGrouperSyncGroup.getId(), gcGrouperSyncMember.getId());
        return gcGrouperSyncMembership;
    }

    public Map<MultiKey, GcGrouperSyncMembership> membershipRetrieveBySyncGroupIdsAndSyncMemberIds(Collection<MultiKey> syncGroupIdsAndSyncMemberIds) {
        HashMap<MultiKey, GcGrouperSyncMembership> result = new HashMap<MultiKey, GcGrouperSyncMembership>();
        HashSet<MultiKey> membershipIdsToGetFromDb = new HashSet<MultiKey>();
        for (MultiKey syncGroupIdAndSyncMemberId : GrouperClientUtils.nonNull(syncGroupIdsAndSyncMemberIds)) {
            GcGrouperSyncMembership gcGrouperSyncMembership = this.internalCacheSyncMemberships.get(syncGroupIdAndSyncMemberId);
            if (gcGrouperSyncMembership != null) {
                result.put(syncGroupIdAndSyncMemberId, gcGrouperSyncMembership);
                continue;
            }
            membershipIdsToGetFromDb.add(syncGroupIdAndSyncMemberId);
        }
        if (membershipIdsToGetFromDb.size() > 0) {
            Map<MultiKey, GcGrouperSyncMembership> fromDb = this.internal_membershipRetrieveFromDbBySyncGroupIdsAndSyncMemberIds(membershipIdsToGetFromDb);
            result.putAll(fromDb);
        }
        return result;
    }

    public GcGrouperSyncMembership internal_membershipRetrieveFromCacheById(String gcGrouperSyncMembershipId) {
        GcGrouperSyncMembership gcGrouperSyncMembership = this.internalCacheSyncMembershipsById.get(gcGrouperSyncMembershipId);
        return gcGrouperSyncMembership;
    }

    public GcGrouperSyncMembership membershipRetrieveById(String gcGrouperSyncMembershipId) {
        GcGrouperSyncMembership gcGrouperSyncMembership = this.internalCacheSyncMembershipsById.get(gcGrouperSyncMembershipId);
        if (gcGrouperSyncMembership == null) {
            gcGrouperSyncMembership = this.internal_membershipRetrieveFromDbById(gcGrouperSyncMembershipId);
        }
        return gcGrouperSyncMembership;
    }

    public void internal_membershipCacheDeleteBySyncGroupId(String syncGroupId) {
        for (GcGrouperSyncMembership gcGrouperSyncMembership : new HashSet<GcGrouperSyncMembership>(this.internalCacheSyncMemberships.values())) {
            if (!GrouperClientUtils.equals(syncGroupId, gcGrouperSyncMembership.getGrouperSyncGroupId())) continue;
            this.internal_membershipCacheDelete(gcGrouperSyncMembership);
        }
    }

    public void internal_membershipCacheDeleteBySyncMemberId(String syncMemberId) {
        for (GcGrouperSyncMembership gcGrouperSyncMembership : new HashSet<GcGrouperSyncMembership>(this.internalCacheSyncMemberships.values())) {
            if (!GrouperClientUtils.equals(syncMemberId, gcGrouperSyncMembership.getGrouperSyncMemberId())) continue;
            this.internal_membershipCacheDelete(gcGrouperSyncMembership);
        }
    }

    public int membershipDeleteBySyncGroupIds(Collection<String> syncGroupIds, boolean deleteLogs) {
        int count = 0;
        if (GrouperClientUtils.length(syncGroupIds) > 0) {
            int[] rowDeleteCounts;
            ArrayList<List<Object>> batchBindVars = new ArrayList<List<Object>>();
            for (String syncGroupId : syncGroupIds) {
                this.internal_membershipCacheDeleteBySyncGroupId(syncGroupId);
                ArrayList<String> currentBindVarRow = new ArrayList<String>();
                currentBindVarRow.add(syncGroupId);
                batchBindVars.add(currentBindVarRow);
            }
            for (int rowDeleteCount : rowDeleteCounts = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_membership where grouper_sync_group_id = ?").batchBindVars(batchBindVars).batchSize(this.getGcGrouperSync().batchSize()).executeBatchSql()) {
                count += rowDeleteCount;
            }
        }
        return count;
    }

    public int membershipDeleteBySyncMemberIds(Collection<String> syncMemberIds, boolean deleteLogs) {
        int count = 0;
        if (GrouperClientUtils.length(syncMemberIds) > 0) {
            int[] rowDeleteCounts;
            ArrayList<List<Object>> batchBindVars = new ArrayList<List<Object>>();
            for (String syncMemberId : syncMemberIds) {
                this.internal_membershipCacheDeleteBySyncMemberId(syncMemberId);
                ArrayList<String> currentBindVarRow = new ArrayList<String>();
                currentBindVarRow.add(syncMemberId);
                batchBindVars.add(currentBindVarRow);
            }
            for (int rowDeleteCount : rowDeleteCounts = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_membership where grouper_sync_member_id = ?").batchBindVars(batchBindVars).batchSize(this.getGcGrouperSync().batchSize()).executeBatchSql()) {
                count += rowDeleteCount;
            }
        }
        return count;
    }

    public int membershipDeleteBySyncGroupId(String syncGroupId, boolean deleteLogs) {
        this.internal_membershipCacheDeleteBySyncGroupId(syncGroupId);
        return new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_membership where grouper_sync_group_id = ?").bindVars(syncGroupId).executeSql();
    }

    public int membershipDeleteBySyncMemberId(String syncMemberId, boolean deleteLogs) {
        this.internal_membershipCacheDeleteBySyncMemberId(syncMemberId);
        return new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_membership where grouper_sync_member_id = ?").bindVars(syncMemberId).executeSql();
    }

    public Map<MultiKey, GcGrouperSyncMembership> membershipRetrieveOrCreateBySyncGroupIdsAndSyncMemberIds(Collection<MultiKey> syncGroupIdsAndSyncMemberIdsCollection) {
        Map<MultiKey, GcGrouperSyncMembership> result = this.membershipRetrieveBySyncGroupIdsAndSyncMemberIds(syncGroupIdsAndSyncMemberIdsCollection);
        if (GrouperClientUtils.length(syncGroupIdsAndSyncMemberIdsCollection) == 0 || syncGroupIdsAndSyncMemberIdsCollection.size() == result.size()) {
            return result;
        }
        HashSet<MultiKey> membershipMultiKeysToCreate = new HashSet<MultiKey>(syncGroupIdsAndSyncMemberIdsCollection);
        membershipMultiKeysToCreate.removeAll(result.keySet());
        HashSet<GcGrouperSyncMembership> syncMembershipsToStore = new HashSet<GcGrouperSyncMembership>();
        for (MultiKey membershipIdToCreate : membershipMultiKeysToCreate) {
            GcGrouperSyncMembership gcGrouperSyncMembership = this.internal_membershipCreateBySyncGroupIdAndSyncMemberIdHelper((String)membershipIdToCreate.getKey(0), (String)membershipIdToCreate.getKey(1));
            result.put(membershipIdToCreate, gcGrouperSyncMembership);
            syncMembershipsToStore.add(gcGrouperSyncMembership);
        }
        int changes = this.internal_membershipStore(syncMembershipsToStore);
        this.gcGrouperSync.addObjectCreatedCount(changes);
        for (GcGrouperSyncMembership gcGrouperSyncMembership : syncMembershipsToStore) {
            this.internal_membershipCacheAdd(gcGrouperSyncMembership);
        }
        return result;
    }

    public GcGrouperSyncLog membershipCreateLog(GcGrouperSyncMembership gcGrouperSyncMembership) {
        return this.gcGrouperSync.getGcGrouperSyncLogDao().logCreateByOwnerId(gcGrouperSyncMembership.getId());
    }

    private void internal_membershipCacheAdd(GcGrouperSyncMembership gcGrouperSyncMembership) {
        if (gcGrouperSyncMembership.getGrouperSyncGroupId() != null && gcGrouperSyncMembership.getGrouperSyncMemberId() != null) {
            this.internalCacheSyncMemberships.put(new MultiKey(gcGrouperSyncMembership.getGrouperSyncGroupId(), gcGrouperSyncMembership.getGrouperSyncMemberId()), gcGrouperSyncMembership);
        }
        if (gcGrouperSyncMembership.getId() != null) {
            this.internalCacheSyncMembershipsById.put(gcGrouperSyncMembership.getId(), gcGrouperSyncMembership);
        }
    }

    public void internal_membershipCacheDelete(GcGrouperSyncMembership gcGrouperSyncMembership) {
        if (gcGrouperSyncMembership.getMembershipId() != null) {
            this.internalCacheSyncMemberships.remove(new MultiKey(gcGrouperSyncMembership.getGrouperSyncGroupId(), gcGrouperSyncMembership.getGrouperSyncMemberId()));
        }
        if (gcGrouperSyncMembership.getId() != null) {
            this.internalCacheSyncMembershipsById.remove(gcGrouperSyncMembership.getId());
        }
    }

    public List<GcGrouperSyncMembership> internal_membershipRetrieveFromDbAll() {
        this.internalCacheSyncMemberships.clear();
        this.internalCacheSyncMembershipsById.clear();
        List<GcGrouperSyncMembership> gcGrouperSyncMembershipList = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_membership where grouper_sync_id = ?").addBindVar(this.getGcGrouperSync().getId()).selectList(GcGrouperSyncMembership.class);
        for (GcGrouperSyncMembership gcGrouperSyncMembership : gcGrouperSyncMembershipList) {
            gcGrouperSyncMembership.setGrouperSync(this.getGcGrouperSync());
            this.internal_membershipCacheAdd(gcGrouperSyncMembership);
        }
        return gcGrouperSyncMembershipList;
    }

    public GcGrouperSyncMembership internal_membershipRetrieveFromDbBySyncGroupIdAndSyncMemberId(String syncGroupId, String syncMemberId) {
        GcGrouperSyncMembership gcGrouperSyncMembership = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_membership where grouper_sync_group_id = ? and grouper_sync_member_id = ?").addBindVar(syncGroupId).addBindVar(syncMemberId).select(GcGrouperSyncMembership.class);
        if (gcGrouperSyncMembership != null) {
            gcGrouperSyncMembership.setGrouperSync(this.getGcGrouperSync());
            this.internal_membershipCacheAdd(gcGrouperSyncMembership);
        }
        return gcGrouperSyncMembership;
    }

    public Map<MultiKey, GcGrouperSyncMembership> internal_membershipRetrieveFromDbBySyncGroupIdsAndSyncMemberIds(Collection<MultiKey> syncGroupIdsAndSyncMemberIds) {
        HashMap<MultiKey, GcGrouperSyncMembership> result = new HashMap<MultiKey, GcGrouperSyncMembership>();
        if (GrouperClientUtils.length(syncGroupIdsAndSyncMemberIds) == 0) {
            return result;
        }
        ArrayList<MultiKey> syncGroupIdsAndSyncMemberIdsList = new ArrayList<MultiKey>(syncGroupIdsAndSyncMemberIds);
        int batchSize = this.getGcGrouperSync().maxBindVarsInSelect() / 2;
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(syncGroupIdsAndSyncMemberIdsList, batchSize);
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<MultiKey> batchOfMembershipIds = GrouperClientUtils.batchList(syncGroupIdsAndSyncMemberIdsList, batchSize, batchIndex);
            StringBuilder sql = new StringBuilder("select * from grouper_sync_membership where ");
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName());
            for (int i = 0; i < batchOfMembershipIds.size(); ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" ( grouper_sync_group_id = ? and grouper_sync_member_id = ? ) ");
                MultiKey syncGroupIdAndSyncMemberId = batchOfMembershipIds.get(i);
                gcDbAccess.addBindVar(syncGroupIdAndSyncMemberId.getKey(0));
                gcDbAccess.addBindVar(syncGroupIdAndSyncMemberId.getKey(1));
            }
            List<GcGrouperSyncMembership> gcGrouperSyncMemberships = gcDbAccess.sql(sql.toString()).selectList(GcGrouperSyncMembership.class);
            for (GcGrouperSyncMembership gcGrouperSyncMembership : GrouperClientUtils.nonNull(gcGrouperSyncMemberships)) {
                result.put(new MultiKey(gcGrouperSyncMembership.getGrouperSyncGroupId(), gcGrouperSyncMembership.getGrouperSyncMemberId()), gcGrouperSyncMembership);
                gcGrouperSyncMembership.setGrouperSync(this.getGcGrouperSync());
                this.internal_membershipCacheAdd(gcGrouperSyncMembership);
            }
        }
        return result;
    }

    public List<GcGrouperSyncMembership> internal_membershipRetrieveFromDbBySyncGroupIds(Collection<String> syncGroupIds) {
        ArrayList<GcGrouperSyncMembership> result = new ArrayList<GcGrouperSyncMembership>();
        if (GrouperClientUtils.length(syncGroupIds) == 0) {
            return result;
        }
        ArrayList<String> syncGroupIdsList = new ArrayList<String>(syncGroupIds);
        int batchSize = this.getGcGrouperSync().maxBindVarsInSelect();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(syncGroupIdsList, batchSize);
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<String> batchOfGroupIds = GrouperClientUtils.batchList(syncGroupIdsList, batchSize, batchIndex);
            String sql = "select * from grouper_sync_membership where grouper_sync_group_id in ( " + GrouperClientUtils.appendQuestions(batchOfGroupIds.size()) + ")";
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName());
            for (String syncGroupId : batchOfGroupIds) {
                gcDbAccess.addBindVar(syncGroupId);
            }
            List<GcGrouperSyncMembership> gcGrouperSyncMemberships = gcDbAccess.sql(sql).selectList(GcGrouperSyncMembership.class);
            for (GcGrouperSyncMembership gcGrouperSyncMembership : GrouperClientUtils.nonNull(gcGrouperSyncMemberships)) {
                result.add(gcGrouperSyncMembership);
                gcGrouperSyncMembership.setGrouperSync(this.getGcGrouperSync());
                this.internal_membershipCacheAdd(gcGrouperSyncMembership);
            }
        }
        return result;
    }

    public List<GcGrouperSyncMembership> internal_membershipRetrieveFromDbBySyncMemberIds(Collection<String> syncMemberIds) {
        ArrayList<GcGrouperSyncMembership> result = new ArrayList<GcGrouperSyncMembership>();
        if (GrouperClientUtils.length(syncMemberIds) == 0) {
            return result;
        }
        ArrayList<String> syncMemberIdsList = new ArrayList<String>(syncMemberIds);
        int batchSize = this.getGcGrouperSync().maxBindVarsInSelect();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(syncMemberIdsList, batchSize);
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<String> batchOfMemberIds = GrouperClientUtils.batchList(syncMemberIdsList, batchSize, batchIndex);
            String sql = "select * from grouper_sync_membership where grouper_sync_member_id in ( " + GrouperClientUtils.appendQuestions(batchOfMemberIds.size()) + ")";
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName());
            for (String syncMemberId : batchOfMemberIds) {
                gcDbAccess.addBindVar(syncMemberId);
            }
            List<GcGrouperSyncMembership> gcGrouperSyncMemberships = gcDbAccess.sql(sql).selectList(GcGrouperSyncMembership.class);
            for (GcGrouperSyncMembership gcGrouperSyncMembership : GrouperClientUtils.nonNull(gcGrouperSyncMemberships)) {
                result.add(gcGrouperSyncMembership);
                gcGrouperSyncMembership.setGrouperSync(this.getGcGrouperSync());
                this.internal_membershipCacheAdd(gcGrouperSyncMembership);
            }
        }
        return result;
    }

    public GcGrouperSyncMembership internal_membershipRetrieveFromDbById(String gcGrouperSyncMembershipId) {
        GcGrouperSyncMembership gcGrouperSyncMembership = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_membership where id = ?").addBindVar(gcGrouperSyncMembershipId).select(GcGrouperSyncMembership.class);
        if (gcGrouperSyncMembership != null) {
            gcGrouperSyncMembership.setGrouperSync(this.getGcGrouperSync());
            this.internal_membershipCacheAdd(gcGrouperSyncMembership);
        }
        return gcGrouperSyncMembership;
    }

    public Map<String, GcGrouperSyncMembership> internal_membershipRetrieveFromDbByIds(Collection<String> syncMembershipIdsCollection) {
        HashMap<String, GcGrouperSyncMembership> result = new HashMap<String, GcGrouperSyncMembership>();
        if (GrouperClientUtils.length(syncMembershipIdsCollection) == 0) {
            return result;
        }
        ArrayList<String> syncIdsList = new ArrayList<String>(syncMembershipIdsCollection);
        int batchSize = this.getGcGrouperSync().maxBindVarsInSelect();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(syncIdsList, batchSize);
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<String> batchOfSyncIds = GrouperClientUtils.batchList(syncIdsList, batchSize, batchIndex);
            String sql = "select * from grouper_sync_membership where grouper_sync_id = ? and id in ( " + GrouperClientUtils.appendQuestions(batchOfSyncIds.size()) + ")";
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql(sql).addBindVar(this.getGcGrouperSync().getId());
            for (String membershipId : batchOfSyncIds) {
                gcDbAccess.addBindVar(membershipId);
            }
            List<GcGrouperSyncMembership> gcGrouperSyncMemberships = gcDbAccess.selectList(GcGrouperSyncMembership.class);
            for (GcGrouperSyncMembership gcGrouperSyncMembership : GrouperClientUtils.nonNull(gcGrouperSyncMemberships)) {
                result.put(gcGrouperSyncMembership.getId(), gcGrouperSyncMembership);
                gcGrouperSyncMembership.setGrouperSync(this.getGcGrouperSync());
                this.internal_membershipCacheAdd(gcGrouperSyncMembership);
            }
        }
        return result;
    }

    public GcGrouperSync getGcGrouperSync() {
        return this.gcGrouperSync;
    }

    public void setGcGrouperSync(GcGrouperSync gcGrouperSync) {
        this.gcGrouperSync = gcGrouperSync;
    }

    public int internal_membershipStoreAll() {
        return this.internal_membershipStore(this.internalCacheSyncMemberships.values());
    }

    public int internal_membershipStore(Collection<GcGrouperSyncMembership> gcGrouperSyncMemberships) {
        if (GrouperClientUtils.length(gcGrouperSyncMemberships) == 0) {
            return 0;
        }
        int batchSize = this.getGcGrouperSync().batchSize();
        ArrayList<GcGrouperSyncMembership> gcGrouperSyncMembershipsList = new ArrayList<GcGrouperSyncMembership>(gcGrouperSyncMemberships);
        for (GcGrouperSyncMembership gcGrouperSyncMembership : GrouperClientUtils.nonNull(gcGrouperSyncMemberships)) {
            gcGrouperSyncMembership.storePrepare();
        }
        int changes = -1;
        changes = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).storeBatchToDatabase(gcGrouperSyncMembershipsList, batchSize);
        for (GcGrouperSyncMembership gcGrouperSyncMembership : GrouperClientUtils.nonNull(gcGrouperSyncMemberships)) {
            this.internal_membershipCacheAdd(gcGrouperSyncMembership);
        }
        return changes;
    }

    public void internal_membershipStore(GcGrouperSyncMembership gcGrouperSyncMembership) {
        gcGrouperSyncMembership.storePrepare();
        new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).storeToDatabase(gcGrouperSyncMembership);
    }

    public GcGrouperSyncMembership membershipRetrieveOrCreateBySyncGroupIdAndSyncMemberId(String syncGroupId, String syncMemberId) {
        GcGrouperSyncMembership gcGrouperSyncMembership = this.membershipRetrieveBySyncGroupIdAndSyncMemberId(syncGroupId, syncMemberId);
        if (gcGrouperSyncMembership == null) {
            gcGrouperSyncMembership = this.membershipCreateBySyncGroupIdAndSyncMemberId(syncGroupId, syncMemberId);
        }
        return gcGrouperSyncMembership;
    }

    public Map<MultiKey, GcGrouperSyncMembership> membershipRetrieveByGroupIdsAndMemberIds(Collection<MultiKey> groupIdsAndMemberIds) {
        MultiKey groupIdMemberId;
        HashSet<String> groupIds = new HashSet<String>();
        HashSet<String> memberIds = new HashSet<String>();
        if (GrouperClientUtils.length(groupIdsAndMemberIds) == 0) {
            return new HashMap<MultiKey, GcGrouperSyncMembership>();
        }
        for (MultiKey groupIdAndMemberId : groupIdsAndMemberIds) {
            groupIds.add((String)groupIdAndMemberId.getKey(0));
            memberIds.add((String)groupIdAndMemberId.getKey(1));
        }
        Map<String, GcGrouperSyncGroup> groupIdToSyncGroup = this.gcGrouperSync.getGcGrouperSyncGroupDao().groupRetrieveByGroupIds(groupIds);
        Map<String, GcGrouperSyncMember> memberIdToSyncMember = this.gcGrouperSync.getGcGrouperSyncMemberDao().memberRetrieveByMemberIds(memberIds);
        HashSet<MultiKey> syncGroupIdsSyncMemberIds = new HashSet<MultiKey>();
        HashMap<MultiKey, MultiKey> syncGroupSyncMemberToGroupMemberIds = new HashMap<MultiKey, MultiKey>();
        for (MultiKey groupIdAndMemberId : groupIdsAndMemberIds) {
            String groupId = (String)groupIdAndMemberId.getKey(0);
            String memberId = (String)groupIdAndMemberId.getKey(1);
            GcGrouperSyncGroup gcGrouperSyncGroup = groupIdToSyncGroup.get(groupId);
            GcGrouperSyncMember gcGrouperSyncMember = memberIdToSyncMember.get(memberId);
            if (gcGrouperSyncGroup == null || gcGrouperSyncMember == null || gcGrouperSyncGroup.getId() == null || gcGrouperSyncMember.getId() == null) continue;
            MultiKey groupSyncIdMemberSyncId = new MultiKey(gcGrouperSyncGroup.getId(), gcGrouperSyncMember.getId());
            syncGroupIdsSyncMemberIds.add(groupSyncIdMemberSyncId);
            syncGroupSyncMemberToGroupMemberIds.put(groupSyncIdMemberSyncId, groupIdAndMemberId);
        }
        HashMap<MultiKey, GcGrouperSyncMembership> results = new HashMap<MultiKey, GcGrouperSyncMembership>();
        HashSet<MultiKey> syncGroupIdsSyncMemberIdsToGetFromDb = new HashSet<MultiKey>();
        for (MultiKey syncGroupIdSyncMemberId : GrouperClientUtils.nonNull(syncGroupIdsSyncMemberIds)) {
            GcGrouperSyncMembership gcGrouperSyncMembership = this.internalCacheSyncMemberships.get(syncGroupIdSyncMemberId);
            if (gcGrouperSyncMembership != null) {
                groupIdMemberId = (MultiKey)syncGroupSyncMemberToGroupMemberIds.get(syncGroupIdSyncMemberId);
                results.put(groupIdMemberId, gcGrouperSyncMembership);
                continue;
            }
            syncGroupIdsSyncMemberIdsToGetFromDb.add(syncGroupIdSyncMemberId);
        }
        if (syncGroupIdsSyncMemberIdsToGetFromDb.size() > 0) {
            Map<MultiKey, GcGrouperSyncMembership> syncGroupIdSyncMemberIdToMembershipFromDb = this.internal_membershipRetrieveFromDbBySyncGroupIdsAndSyncMemberIds(syncGroupIdsSyncMemberIdsToGetFromDb);
            for (MultiKey syncGroupIdSyncMemberId : GrouperClientUtils.nonNull(syncGroupIdSyncMemberIdToMembershipFromDb).keySet()) {
                groupIdMemberId = (MultiKey)syncGroupSyncMemberToGroupMemberIds.get(syncGroupIdSyncMemberId);
                results.put(groupIdMemberId, syncGroupIdSyncMemberIdToMembershipFromDb.get(syncGroupIdSyncMemberId));
            }
        }
        return results;
    }

    public List<GcGrouperSyncMembership> membershipRetrieveByGroupIds(Set<String> groupIdsToRetrieveMemberships) {
        HashSet<String> groupIds = new HashSet<String>();
        ArrayList<GcGrouperSyncMembership> results = new ArrayList<GcGrouperSyncMembership>();
        if (GrouperClientUtils.length(groupIdsToRetrieveMemberships) == 0) {
            return results;
        }
        Map<String, GcGrouperSyncGroup> groupIdToSyncGroup = this.gcGrouperSync.getGcGrouperSyncGroupDao().groupRetrieveByGroupIds(groupIds);
        HashSet<String> groupSyncIds = new HashSet<String>();
        for (GcGrouperSyncGroup gcGrouperSyncGroup : GrouperClientUtils.nonNull(groupIdToSyncGroup).values()) {
            groupSyncIds.add(gcGrouperSyncGroup.getId());
        }
        return this.internal_membershipRetrieveFromDbBySyncGroupIds(groupSyncIds);
    }

    public List<GcGrouperSyncMembership> membershipRetrieveByMemberIds(Set<String> memberIdsToRetrieveMemberships) {
        HashSet<String> groupIds = new HashSet<String>();
        ArrayList<GcGrouperSyncMembership> results = new ArrayList<GcGrouperSyncMembership>();
        if (GrouperClientUtils.length(memberIdsToRetrieveMemberships) == 0) {
            return results;
        }
        Map<String, GcGrouperSyncMember> memberSyncIdToSyncMember = this.gcGrouperSync.getGcGrouperSyncMemberDao().memberRetrieveByMemberIds(groupIds);
        HashSet<String> memberSyncIds = new HashSet<String>();
        for (GcGrouperSyncMember gcGrouperSyncMember : GrouperClientUtils.nonNull(memberSyncIdToSyncMember).values()) {
            memberSyncIds.add(gcGrouperSyncMember.getId());
        }
        return this.internal_membershipRetrieveFromDbBySyncMemberIds(memberSyncIds);
    }

    public List<Object[]> retrieveGroupIdMemberIdsWithErrorsAfterMillis(Timestamp errorTimestampCheckFrom) {
        GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select gsg.group_id, gsm.member_id from grouper_sync_membership gsms, grouper_sync_group gsg, grouper_sync_member gsm where gsms.grouper_sync_id = ? and gsms.grouper_sync_group_id = gsg.id and gsms.grouper_sync_member_id = gsm.id" + (errorTimestampCheckFrom == null ? " and gsms.error_timestamp is not null" : " and gsms.error_timestamp >= ?")).addBindVar(this.getGcGrouperSync().getId());
        if (errorTimestampCheckFrom != null) {
            gcDbAccess.addBindVar(errorTimestampCheckFrom);
        }
        List<Object[]> groupIdMemberIds = gcDbAccess.selectList(Object[].class);
        return groupIdMemberIds;
    }
}

