/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncHeartbeat;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJob;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLog;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLogState;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncColumnMetadata;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncConfiguration;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncLog;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncOutput;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncSubtype;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcTableSyncTableBean;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.time.DurationFormatUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class GcTableSync {
    private Long latestIncrementalValueBeforeStarted;
    private long millisWhenSyncStarted = -1L;
    private GcTableSyncOutput gcTableSyncOutput;
    private long lastLog = System.currentTimeMillis();
    private GcTableSyncTableBean dataBeanFrom;
    private GcTableSyncTableBean dataBeanTo;
    private GcGrouperSyncLog gcGrouperSyncLog;
    private GcGrouperSync gcGrouperSync;
    private GcGrouperSyncJob gcGrouperSyncJob;
    private GcTableSyncTableBean dataBeanRealTime;
    private Map<String, Object> debugMap = new LinkedHashMap<String, Object>();
    private GcTableSyncConfiguration gcTableSyncConfiguration = null;
    private boolean done = false;
    private static Map<String, Integer> membershipsColumnToIndex = GrouperClientUtils.toMap("group_id", 0, "member_id", 1, "field_id", 2);
    private Set<MultiKey> primaryKeysToSync = null;
    private Set<MultiKey> primaryKeysToSyncFromMemberships = null;
    private Collection<Object> memberIdsToSync = null;
    private Collection<Object> groupIdsToSync = null;
    private GcGrouperSyncHeartbeat gcGrouperSyncHeartbeat = new GcGrouperSyncHeartbeat();
    private static final Log LOG = LogFactory.getLog(GcTableSync.class);

    public Long getLatestIncrementalValueBeforeStarted() {
        return this.latestIncrementalValueBeforeStarted;
    }

    public void setLatestIncrementalValueBeforeStarted(Long latestIncrementalValueBeforeStarted1) {
        this.latestIncrementalValueBeforeStarted = latestIncrementalValueBeforeStarted1;
    }

    public long getMillisWhenSyncStarted() {
        return this.millisWhenSyncStarted;
    }

    public void setMillisWhenSyncStarted(long millisWhenSyncStarted1) {
        this.millisWhenSyncStarted = millisWhenSyncStarted1;
    }

    public GcTableSyncOutput getGcTableSyncOutput() {
        return this.gcTableSyncOutput;
    }

    public void setGcTableSyncOutput(GcTableSyncOutput gcTableSyncOutput1) {
        this.gcTableSyncOutput = gcTableSyncOutput1;
    }

    public GcTableSyncTableBean getDataBeanFrom() {
        return this.dataBeanFrom;
    }

    public void setDataBeanFrom(GcTableSyncTableBean fromData1) {
        this.dataBeanFrom = fromData1;
    }

    public GcTableSyncTableBean getDataBeanTo() {
        return this.dataBeanTo;
    }

    public void setDataBeanTo(GcTableSyncTableBean toData1) {
        this.dataBeanTo = toData1;
    }

    public GcGrouperSyncLog getGcGrouperSyncLog() {
        return this.gcGrouperSyncLog;
    }

    public void setGcGrouperSyncLog(GcGrouperSyncLog gcGrouperSyncLog1) {
        this.gcGrouperSyncLog = gcGrouperSyncLog1;
    }

    public GcGrouperSync getGcGrouperSync() {
        return this.gcGrouperSync;
    }

    public void setGcGrouperSync(GcGrouperSync gcGrouperSync1) {
        this.gcGrouperSync = gcGrouperSync1;
    }

    public GcGrouperSyncJob getGcGrouperSyncJob() {
        return this.gcGrouperSyncJob;
    }

    public void setGcGrouperSyncJob(GcGrouperSyncJob gcGrouperSyncJob1) {
        this.gcGrouperSyncJob = gcGrouperSyncJob1;
    }

    public GcTableSyncTableBean getDataBeanRealTime() {
        return this.dataBeanRealTime;
    }

    public void setDataBeanRealTime(GcTableSyncTableBean dataBeanRealTime1) {
        this.dataBeanRealTime = dataBeanRealTime1;
    }

    public GcTableSyncConfiguration getGcTableSyncConfiguration() {
        return this.gcTableSyncConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public GcTableSyncOutput sync(String configKey, GcTableSyncSubtype gcTableSyncSubtype) {
        block78: {
            Long updatesMillis;
            Long insertsMillis;
            Long deletesMillis;
            long now;
            LinkedHashMap<String, Object> debugMap;
            block77: {
                if (this.done) {
                    throw new RuntimeException("Dont re-use instances of this class: " + GcTableSync.class.getName());
                }
                this.millisWhenSyncStarted = System.currentTimeMillis();
                this.gcTableSyncOutput = new GcTableSyncOutput();
                this.gcTableSyncConfiguration = new GcTableSyncConfiguration();
                this.gcTableSyncConfiguration.configureTableSync(this.debugMap, this, configKey, gcTableSyncSubtype);
                debugMap = new LinkedHashMap<String, Object>();
                now = System.nanoTime();
                GcDbAccess.threadLocalQueryCountReset();
                debugMap.put("finalLog", false);
                debugMap.put("state", "init");
                this.gcGrouperSyncHeartbeat.setGcGrouperSyncJob(this.gcGrouperSyncJob);
                this.gcGrouperSyncHeartbeat.setFullSync(gcTableSyncSubtype.isFullSync());
                this.gcGrouperSyncHeartbeat.addHeartbeatLogic(new Runnable(){

                    @Override
                    public void run() {
                        GcTableSync.this.logPeriodically(debugMap, GcTableSync.this.gcTableSyncOutput);
                    }
                });
                if (!this.gcGrouperSyncHeartbeat.isStarted()) {
                    this.gcGrouperSyncHeartbeat.runHeartbeatThread();
                }
                debugMap.put("sync", "sqlTableSync");
                debugMap.put("provisionerName", this.getGcTableSyncConfiguration().getConfigKey());
                debugMap.put("syncType", (Object)this.getGcTableSyncConfiguration().getGcTableSyncSubtype());
                this.dataBeanFrom = new GcTableSyncTableBean(this);
                this.dataBeanFrom.configureMetadata(this.gcTableSyncConfiguration.getDatabaseFrom(), this.gcTableSyncConfiguration.getTableFrom());
                this.dataBeanFrom.getTableMetadata().setConnectionNameOrReadonly(this.gcTableSyncConfiguration.getDatabaseFrom());
                this.dataBeanFrom.getTableMetadata().assignColumns(this.gcTableSyncConfiguration.getColumnsString());
                this.dataBeanFrom.getTableMetadata().assignPrimaryKeyColumns(this.gcTableSyncConfiguration.getPrimaryKeyColumnsString());
                if (!GrouperClientUtils.isBlank(this.gcTableSyncConfiguration.getChangeFlagColumnString())) {
                    this.dataBeanFrom.getTableMetadata().assignChangeFlagColumn(this.gcTableSyncConfiguration.getChangeFlagColumnString());
                }
                if (!GrouperClientUtils.isBlank(this.gcTableSyncConfiguration.getGroupColumnString())) {
                    this.dataBeanFrom.getTableMetadata().assignGroupColumn(this.gcTableSyncConfiguration.getGroupColumnString());
                }
                if (!GrouperClientUtils.isBlank(this.gcTableSyncConfiguration.getIncrementalAllColumnsColumnString())) {
                    this.dataBeanFrom.getTableMetadata().assignIncrementalAllCoumnsColumn(this.gcTableSyncConfiguration.getIncrementalAllColumnsColumnString());
                }
                debugMap.put("databaseFrom", this.getDataBeanFrom().getTableMetadata().getConnectionName());
                debugMap.put("tableFrom", this.getDataBeanFrom().getTableMetadata().getTableName());
                this.dataBeanTo = new GcTableSyncTableBean(this);
                this.dataBeanTo.configureMetadata(this.gcTableSyncConfiguration.getDatabaseTo(), this.gcTableSyncConfiguration.getTableTo());
                this.dataBeanTo.getTableMetadata().setConnectionNameOrReadonly(this.gcTableSyncConfiguration.getDatabaseToOrReadonly());
                this.dataBeanTo.getTableMetadata().assignColumns(this.gcTableSyncConfiguration.getColumnsString());
                this.dataBeanTo.getTableMetadata().assignPrimaryKeyColumns(this.gcTableSyncConfiguration.getPrimaryKeyColumnsString());
                if (!GrouperClientUtils.isBlank(this.gcTableSyncConfiguration.getChangeFlagColumnString())) {
                    this.dataBeanTo.getTableMetadata().assignChangeFlagColumn(this.gcTableSyncConfiguration.getChangeFlagColumnString());
                }
                if (!GrouperClientUtils.isBlank(this.gcTableSyncConfiguration.getGroupColumnString())) {
                    this.dataBeanTo.getTableMetadata().assignGroupColumn(this.gcTableSyncConfiguration.getGroupColumnString());
                }
                debugMap.put("databaseTo", this.getDataBeanTo().getTableMetadata().getConnectionName());
                debugMap.put("tableTo", this.getDataBeanTo().getTableMetadata().getTableName());
                if (!GrouperClientUtils.isBlank(this.gcTableSyncConfiguration.getIncrementalPrimaryKeyTable())) {
                    this.dataBeanRealTime = new GcTableSyncTableBean(this);
                    this.dataBeanRealTime.configureMetadata(this.gcTableSyncConfiguration.getDatabaseFrom(), this.gcTableSyncConfiguration.getIncrementalPrimaryKeyTable());
                    this.dataBeanRealTime.getTableMetadata().setConnectionNameOrReadonly(this.gcTableSyncConfiguration.getDatabaseFrom());
                    this.dataBeanRealTime.getTableMetadata().assignColumns(this.gcTableSyncConfiguration.getPrimaryKeyColumnsString() + ", " + this.gcTableSyncConfiguration.getIncrementalProgressColumnString());
                    this.dataBeanRealTime.getTableMetadata().assignPrimaryKeyColumns(this.gcTableSyncConfiguration.getPrimaryKeyColumnsString());
                    this.dataBeanRealTime.getTableMetadata().assignIncrementalProgressColumn(this.gcTableSyncConfiguration.getIncrementalProgressColumnString());
                    debugMap.put("tableIncremental", this.getDataBeanRealTime().getTableMetadata().getTableName());
                }
                if (GrouperClientUtils.length(this.groupIdsToSync) > 0) {
                    GcTableSyncSubtype.syncGroupings(debugMap, this, this.groupIdsToSync);
                }
                this.convertPrimaryKeysFromMembershipsToPrimaryKeys();
                if (GrouperClientUtils.length(this.primaryKeysToSync) > 0 && this.getGcTableSyncConfiguration().getGcTableSyncSubtype() != GcTableSyncSubtype.incrementalFromIdentifiedPrimaryKeys) {
                    throw new RuntimeException("If passing in primaryKeysToSync, then the sync subtype must be incrementalFromIdentifiedPrimaryKeys");
                }
                if (GrouperClientUtils.length(this.primaryKeysToSync) == 0 && this.getGcTableSyncConfiguration().getGcTableSyncSubtype() == GcTableSyncSubtype.incrementalFromIdentifiedPrimaryKeys) {
                    throw new RuntimeException("If incrementalFromIdentifiedPrimaryKeys, then you ust pass in primaryKeysToSync");
                }
                debugMap.put("state", "retrieveData");
                this.gcTableSyncConfiguration.getGcTableSyncSubtype().retrieveData(debugMap, this);
                this.gcGrouperSyncLog.setRecordsProcessed(Math.max(this.gcTableSyncOutput.getRowsSelectedFrom(), this.gcTableSyncOutput.getRowsSelectedTo()));
                if (!this.gcGrouperSyncHeartbeat.isInterrupted()) break block77;
                debugMap.put("interrupted", true);
                debugMap.put("state", "done");
                this.gcGrouperSyncLog.setStatus(GcGrouperSyncLogState.INTERRUPTED);
                GcTableSyncOutput gcTableSyncOutput = this.gcTableSyncOutput;
                this.done = true;
                GcGrouperSyncHeartbeat.endAndWaitForThread(this.gcGrouperSyncHeartbeat);
                debugMap.put("finalLog", true);
                GcTableSync gcTableSync = this;
                synchronized (gcTableSync) {
                    try {
                        if (this.gcGrouperSyncJob != null) {
                            this.gcGrouperSyncJob.assignHeartbeatAndEndJob();
                        }
                    }
                    catch (RuntimeException re2) {
                        if (this.gcGrouperSyncLog != null) {
                            this.gcGrouperSyncLog.setStatus(GcGrouperSyncLogState.ERROR);
                        }
                        debugMap.put("exception2", GrouperClientUtils.getFullStackTrace(re2));
                    }
                }
                this.gcTableSyncOutput.setQueryCount(GcDbAccess.threadLocalQueryCountRetrieve());
                debugMap.put("queryCount", this.gcTableSyncOutput.getQueryCount());
                int durationMillis = (int)((System.nanoTime() - now) / 1000000L);
                debugMap.put("tookMillis", durationMillis);
                debugMap.put("took", DurationFormatUtils.formatDurationHMS(durationMillis));
                String debugString = GrouperClientUtils.mapToString(debugMap);
                try {
                    if (this.gcGrouperSyncLog != null) {
                        this.gcGrouperSyncLog.setDescriptionToSave(debugString);
                        this.gcGrouperSyncLog.setJobTookMillis(durationMillis);
                        this.gcGrouperSync.getGcGrouperSyncLogDao().internal_logStore(this.gcGrouperSyncLog);
                    }
                }
                catch (RuntimeException re3) {
                    debugMap.put("exception3", GrouperClientUtils.getFullStackTrace(re3));
                    debugString = GrouperClientUtils.mapToString(debugMap);
                }
                GcTableSyncLog.debugLog(debugString);
                this.gcTableSyncOutput.setMessage(debugString);
                if (debugMap.containsKey("exception") || debugMap.containsKey("exception2") || debugMap.containsKey("exception3")) {
                    throw new RuntimeException(debugString);
                }
                return gcTableSyncOutput;
            }
            debugMap.put("state", "syncData");
            Integer recordsChanged = this.gcTableSyncConfiguration.getGcTableSyncSubtype().syncData(debugMap, this);
            if (recordsChanged != null) {
                this.gcGrouperSyncLog.setRecordsChanged(recordsChanged);
                this.gcGrouperSyncJob.setLastTimeWorkWasDone(new Timestamp(System.currentTimeMillis()));
            }
            debugMap.put("state", "done");
            for (String label : debugMap.keySet()) {
                Object value;
                if (!label.endsWith("Millis") || !((value = debugMap.get(label)) instanceof Number)) continue;
                long millis = ((Number)value).longValue() / 1000L;
                debugMap.put(label, millis);
            }
            long retrieveMillis = 0L;
            long syncMillis = 0L;
            Long retrieveDataFromMillis = (Long)debugMap.get("retrieveDataFromMillis");
            Long retrieveDataToMillis = (Long)debugMap.get("retrieveDataToMillis");
            if (retrieveDataFromMillis != null && retrieveDataToMillis != null) {
                retrieveMillis += Math.max(retrieveDataFromMillis, retrieveDataToMillis);
            } else if (retrieveDataFromMillis != null) {
                retrieveMillis += retrieveDataFromMillis.longValue();
            } else if (retrieveDataToMillis != null) {
                retrieveMillis += retrieveDataToMillis.longValue();
            }
            Long selectAllColumnsMillis = (Long)debugMap.get("selectAllColumnsMillis");
            if (selectAllColumnsMillis != null) {
                retrieveMillis += selectAllColumnsMillis.longValue();
            }
            Long retrieveChangeFlagFromMillis = (Long)debugMap.get("retrieveChangeFlagFromMillis");
            Long retrieveChangeFlagToMillis = (Long)debugMap.get("retrieveChangeFlagToMillis");
            if (retrieveChangeFlagToMillis != null && retrieveChangeFlagFromMillis != null) {
                retrieveMillis += Math.max(retrieveChangeFlagToMillis, retrieveChangeFlagFromMillis);
            } else if (retrieveChangeFlagToMillis != null) {
                retrieveMillis += retrieveChangeFlagToMillis.longValue();
            } else if (retrieveChangeFlagFromMillis != null) {
                retrieveMillis += retrieveChangeFlagFromMillis.longValue();
            }
            Long retrieveGroupsFromMillis = (Long)debugMap.get("retrieveGroupsFromMillis");
            Long retrieveGroupsToMillis = (Long)debugMap.get("retrieveGroupsToMillis");
            if (retrieveGroupsToMillis != null && retrieveGroupsFromMillis != null) {
                retrieveMillis += Math.max(retrieveGroupsToMillis, retrieveGroupsFromMillis);
            } else if (retrieveGroupsToMillis != null) {
                retrieveMillis += retrieveGroupsToMillis.longValue();
            } else if (retrieveGroupsFromMillis != null) {
                retrieveMillis += retrieveGroupsFromMillis.longValue();
            }
            Long incrementalChangesMillis = (Long)debugMap.get("incrementalChangesMillis");
            if (incrementalChangesMillis != null) {
                retrieveMillis += incrementalChangesMillis.longValue();
            }
            if ((deletesMillis = (Long)debugMap.get("deletesMillis")) != null) {
                syncMillis += deletesMillis.longValue();
            }
            if ((insertsMillis = (Long)debugMap.get("insertsMillis")) != null) {
                syncMillis += insertsMillis.longValue();
            }
            if ((updatesMillis = (Long)debugMap.get("updatesMillis")) != null) {
                syncMillis += updatesMillis.longValue();
            }
            this.gcTableSyncOutput.setMillisGetData(retrieveMillis);
            this.gcTableSyncOutput.setMillisLoadData(syncMillis);
            if (this.gcGrouperSync != null && this.gcGrouperSync.getRecordsCount() != null) {
                this.gcTableSyncOutput.setTotalCount(this.gcGrouperSync.getRecordsCount());
            }
            this.gcGrouperSyncLog.setRecordsProcessed(Math.max(this.gcTableSyncOutput.getRowsSelectedFrom(), this.gcTableSyncOutput.getRowsSelectedTo()));
            if (GrouperClientUtils.isBlank((Object)this.gcGrouperSyncLog.getStatus())) {
                this.gcGrouperSyncLog.setStatus(GcGrouperSyncLogState.SUCCESS);
            }
            if (System.currentTimeMillis() - this.millisWhenSyncStarted < 20L) {
                GrouperClientUtils.sleep(20L);
            }
            this.getGcGrouperSyncJob().setPercentComplete(100);
            Object milliswhenSyncStartedTimestamp = new Timestamp(this.millisWhenSyncStarted);
            this.getGcGrouperSyncJob().setLastSyncTimestamp((Timestamp)milliswhenSyncStartedTimestamp);
            if (gcTableSyncSubtype.isFullMetadataSync()) {
                this.getGcGrouperSync().setLastFullMetadataSyncRun((Timestamp)milliswhenSyncStartedTimestamp);
            }
            if (gcTableSyncSubtype.isFullSync()) {
                this.getGcGrouperSync().setLastFullSyncRun((Timestamp)milliswhenSyncStartedTimestamp);
            }
            if (gcTableSyncSubtype.isIncrementalSync()) {
                this.getGcGrouperSync().setLastIncrementalSyncRun((Timestamp)milliswhenSyncStartedTimestamp);
            }
            int gcSyncObjectChanges = this.getGcGrouperSync().getGcGrouperSyncDao().storeAllObjects();
            debugMap.put("gcSyncObjectChanges", gcSyncObjectChanges + this.gcGrouperSync.getInternalObjectsCreatedCount());
            this.done = true;
            GcGrouperSyncHeartbeat.endAndWaitForThread(this.gcGrouperSyncHeartbeat);
            debugMap.put("finalLog", true);
            milliswhenSyncStartedTimestamp = this;
            synchronized (milliswhenSyncStartedTimestamp) {
                try {
                    if (this.gcGrouperSyncJob != null) {
                        this.gcGrouperSyncJob.assignHeartbeatAndEndJob();
                    }
                }
                catch (RuntimeException re2) {
                    if (this.gcGrouperSyncLog != null) {
                        this.gcGrouperSyncLog.setStatus(GcGrouperSyncLogState.ERROR);
                    }
                    debugMap.put("exception2", GrouperClientUtils.getFullStackTrace(re2));
                }
            }
            this.gcTableSyncOutput.setQueryCount(GcDbAccess.threadLocalQueryCountRetrieve());
            debugMap.put("queryCount", this.gcTableSyncOutput.getQueryCount());
            int durationMillis = (int)((System.nanoTime() - now) / 1000000L);
            debugMap.put("tookMillis", durationMillis);
            debugMap.put("took", DurationFormatUtils.formatDurationHMS(durationMillis));
            String debugString = GrouperClientUtils.mapToString(debugMap);
            try {
                if (this.gcGrouperSyncLog != null) {
                    this.gcGrouperSyncLog.setDescriptionToSave(debugString);
                    this.gcGrouperSyncLog.setJobTookMillis(durationMillis);
                    this.gcGrouperSync.getGcGrouperSyncLogDao().internal_logStore(this.gcGrouperSyncLog);
                }
            }
            catch (RuntimeException re3) {
                debugMap.put("exception3", GrouperClientUtils.getFullStackTrace(re3));
                debugString = GrouperClientUtils.mapToString(debugMap);
            }
            GcTableSyncLog.debugLog(debugString);
            this.gcTableSyncOutput.setMessage(debugString);
            if (debugMap.containsKey("exception") || debugMap.containsKey("exception2") || debugMap.containsKey("exception3")) {
                throw new RuntimeException(debugString);
            }
            break block78;
            catch (RuntimeException re) {
                try {
                    this.gcGrouperSyncLog.setStatus(GcGrouperSyncLogState.ERROR);
                    debugMap.put("exception", GrouperClientUtils.getFullStackTrace(re));
                    throw re;
                }
                catch (Throwable throwable) {
                    this.done = true;
                    GcGrouperSyncHeartbeat.endAndWaitForThread(this.gcGrouperSyncHeartbeat);
                    debugMap.put("finalLog", true);
                    GcTableSync gcTableSync = this;
                    synchronized (gcTableSync) {
                        try {
                            if (this.gcGrouperSyncJob != null) {
                                this.gcGrouperSyncJob.assignHeartbeatAndEndJob();
                            }
                        }
                        catch (RuntimeException re2) {
                            if (this.gcGrouperSyncLog != null) {
                                this.gcGrouperSyncLog.setStatus(GcGrouperSyncLogState.ERROR);
                            }
                            debugMap.put("exception2", GrouperClientUtils.getFullStackTrace(re2));
                        }
                    }
                    this.gcTableSyncOutput.setQueryCount(GcDbAccess.threadLocalQueryCountRetrieve());
                    debugMap.put("queryCount", this.gcTableSyncOutput.getQueryCount());
                    int durationMillis2 = (int)((System.nanoTime() - now) / 1000000L);
                    debugMap.put("tookMillis", durationMillis2);
                    debugMap.put("took", DurationFormatUtils.formatDurationHMS(durationMillis2));
                    String debugString2 = GrouperClientUtils.mapToString(debugMap);
                    try {
                        if (this.gcGrouperSyncLog != null) {
                            this.gcGrouperSyncLog.setDescriptionToSave(debugString2);
                            this.gcGrouperSyncLog.setJobTookMillis(durationMillis2);
                            this.gcGrouperSync.getGcGrouperSyncLogDao().internal_logStore(this.gcGrouperSyncLog);
                        }
                    }
                    catch (RuntimeException re3) {
                        debugMap.put("exception3", GrouperClientUtils.getFullStackTrace(re3));
                        debugString2 = GrouperClientUtils.mapToString(debugMap);
                    }
                    GcTableSyncLog.debugLog(debugString2);
                    this.gcTableSyncOutput.setMessage(debugString2);
                    if (debugMap.containsKey("exception") || debugMap.containsKey("exception2") || debugMap.containsKey("exception3")) {
                        throw new RuntimeException(debugString2);
                    }
                    throw throwable;
                }
            }
        }
        return this.gcTableSyncOutput;
    }

    private void convertPrimaryKeysFromMembershipsToPrimaryKeys() {
        if (GrouperClientUtils.length(this.primaryKeysToSyncFromMemberships) > 0) {
            if (this.primaryKeysToSync == null) {
                this.primaryKeysToSync = new LinkedHashSet<MultiKey>();
            }
            int primaryKeySize = GrouperClientUtils.length(this.dataBeanFrom.getTableMetadata().getPrimaryKey());
            int[] primaryKeyIndexes = new int[primaryKeySize];
            int i = 0;
            boolean hasGroupId = false;
            boolean hasMemberId = false;
            boolean hasFieldId = false;
            for (GcTableSyncColumnMetadata gcTableSyncColumnMetadata : this.dataBeanFrom.getTableMetadata().getPrimaryKey()) {
                String columnName = gcTableSyncColumnMetadata.getColumnName().toLowerCase();
                Integer membershipIndex = membershipsColumnToIndex.get(columnName);
                if (membershipIndex == null) {
                    throw new RuntimeException("Cant find membership column in primary key, should be one of: " + GrouperClientUtils.toStringForLog(membershipsColumnToIndex.keySet() + " -- primary key -- " + columnName));
                }
                primaryKeyIndexes[i++] = membershipIndex;
                if ("group_id".equals(columnName)) {
                    hasGroupId = true;
                }
                if ("member_id".equals(columnName)) {
                    hasMemberId = true;
                }
                if (!"field_id".equals(columnName)) continue;
                hasFieldId = true;
            }
            boolean columnsOk = false;
            if (primaryKeySize == 2 && hasGroupId && hasMemberId) {
                columnsOk = true;
            }
            if (primaryKeySize == 3 && hasGroupId && hasMemberId && hasFieldId) {
                columnsOk = true;
            }
            if (!columnsOk) {
                throw new RuntimeException("Primary key of membership sync must have either group_id, member_id...  or group_id, member_id, field_id");
            }
            boolean standardConfiguration = primaryKeySize == 3 && primaryKeyIndexes[0] == 0 && primaryKeyIndexes[1] == 1 && primaryKeyIndexes[2] == 2;
            for (MultiKey membershipArray : this.primaryKeysToSyncFromMemberships) {
                if (standardConfiguration) {
                    this.primaryKeysToSync.add(membershipArray);
                    continue;
                }
                Object[] primaryKey = new Object[primaryKeySize];
                for (i = 0; i < primaryKeySize; ++i) {
                    int primaryKeyIndex = primaryKeyIndexes[i];
                    primaryKey[i] = membershipArray.getKey(primaryKeyIndex);
                    if (primaryKey[i] != null && (!(primaryKey[i] instanceof String) || !"".equals((String)primaryKey[i]))) continue;
                    throw new RuntimeException("Cant have a null column here: " + GrouperClientUtils.toStringForLog(membershipArray));
                }
                this.primaryKeysToSync.add(new MultiKey(primaryKey));
            }
        }
    }

    public void logPeriodically(Map<String, Object> debugMap, GcTableSyncOutput gcTableSyncOutput) {
        if (System.currentTimeMillis() - this.lastLog > 59990L) {
            String debugString = GrouperClientUtils.mapToString(debugMap);
            gcTableSyncOutput.setMessage(debugString);
            GcTableSyncLog.debugLog(debugString);
            this.lastLog = System.currentTimeMillis();
        }
    }

    public Set<MultiKey> getPrimaryKeysToSync() {
        return this.primaryKeysToSync;
    }

    public void setPrimaryKeysToSync(Set<MultiKey> primaryKeysToSync1) {
        this.primaryKeysToSync = primaryKeysToSync1;
    }

    public Set<MultiKey> getPrimaryKeysToSyncFromMemberships() {
        return this.primaryKeysToSyncFromMemberships;
    }

    public void setPrimaryKeysToSyncFromMemberships(Set<MultiKey> primaryKeysToSyncFromMemberships1) {
        this.primaryKeysToSyncFromMemberships = primaryKeysToSyncFromMemberships1;
    }

    public Collection<Object> getMemberIdsToSync() {
        return this.memberIdsToSync;
    }

    public void setMemberIdsToSync(Collection<Object> memberIdsToSync1) {
        this.memberIdsToSync = memberIdsToSync1;
    }

    public Collection<Object> getGroupIdsToSync() {
        return this.groupIdsToSync;
    }

    public void setGroupIdsToSync(Collection<Object> groupIdsToSync1) {
        this.groupIdsToSync = groupIdsToSync1;
    }

    public GcGrouperSyncHeartbeat getGcGrouperSyncHeartbeat() {
        return this.gcGrouperSyncHeartbeat;
    }

    public void setGcGrouperSyncHeartbeat(GcGrouperSyncHeartbeat gcGrouperSyncHeartbeat1) {
        this.gcGrouperSyncHeartbeat = gcGrouperSyncHeartbeat1;
    }

    public static void main(String[] args) {
        GcTableSyncOutput gcTableSyncOutput = new GcTableSync().sync(args[0], GcTableSyncSubtype.valueOfIgnoreCase(args[1], true));
        System.out.println(gcTableSyncOutput.toString());
    }
}

