/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class BlindSslSocketFactory
extends SocketFactory {
    private static SocketFactory blindFactory = null;

    public static SocketFactory getDefault() {
        return new BlindSslSocketFactory();
    }

    @Override
    public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
        return blindFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return blindFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
        return blindFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return blindFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    public static void main(String[] args) {
        boolean validateCert = false;
        System.out.println("Testing LDAPS connection with validateCert: " + validateCert);
        Hashtable<String, String> env = new Hashtable<String, String>();
        String url = "ldaps://<URL TO YOUR AD SERVER>:636";
        String domain = "<YOUR AD DOMAIN>";
        String login = "<LOGIN>";
        String password = "<PASSWORD>";
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", login + "@" + domain);
        env.put("java.naming.security.credentials", password);
        if (url.startsWith("ldaps") && !validateCert) {
            env.put("java.naming.ldap.factory.socket", BlindSslSocketFactory.class.getName());
        }
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            System.out.println("Successfull bind to " + url + "!");
        }
        catch (AuthenticationException e) {
            System.out.println("The credentials could not be validated!");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        System.out.println("Testing HTTPS connection with validateCert: " + validateCert);
        String host = "<SSL WEB HOST>";
        int port = 443;
        try {
            SocketFactory sslFactory = validateCert ? SSLSocketFactory.getDefault() : BlindSslSocketFactory.getDefault();
            SSLSocket s = (SSLSocket)sslFactory.createSocket(host, port);
            OutputStream out = s.getOutputStream();
            out.write("GET / HTTP/1.0\n\r\n\r".getBytes());
            out.flush();
            System.out.println("Successfull connection to " + host + ":" + port + "!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        TrustManager[] blindTrustMan = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] c, String a) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] c, String a) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, blindTrustMan, new SecureRandom());
            blindFactory = sc.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
    }
}

