/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.config.ConfigPropertiesCascadeBase;
import edu.internet2.middleware.grouperClient.messaging.GrouperMessagingConfig;
import edu.internet2.middleware.grouperClient.messaging.GrouperMessagingSystem;
import edu.internet2.middleware.grouperClient.util.GrouperClientCommonUtils;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.StringUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrouperClientConfig
extends ConfigPropertiesCascadeBase {
    private static Log log = LogFactory.getLog(GrouperClientConfig.class);
    private Map<String, GrouperMessagingConfig> grouperMessagingConfigs;
    private static Pattern grouperMessagingConfigPattern = Pattern.compile("^grouper.messaging.system.([^.]+).name$");

    private GrouperClientConfig() {
    }

    public static GrouperClientConfig retrieveConfig() {
        return GrouperClientConfig.retrieveConfig(GrouperClientConfig.class);
    }

    @Override
    public void clearCachedCalculatedValues() {
    }

    @Override
    protected String getHierarchyConfigKey() {
        return "grouperClient.config.hierarchy";
    }

    @Override
    protected String getMainConfigClasspath() {
        return "grouper.client.properties";
    }

    @Override
    protected String getMainExampleConfigClasspath() {
        return "grouper.client.base.properties";
    }

    @Override
    protected String getSecondsToCheckConfigKey() {
        return "grouperClient.config.secondsBetweenUpdateChecks";
    }

    @Override
    protected Class<?> getClassInSiblingJar() {
        return GrouperClientCommonUtils.class;
    }

    public GrouperMessagingConfig retrieveGrouperMessagingConfigNonNull(String systemName) {
        GrouperMessagingConfig grouperMessagingConfig = GrouperClientConfig.retrieveConfig().retrieveGrouperMessagingConfigs().get(systemName);
        if (grouperMessagingConfig == null) {
            throw new RuntimeException("Cant find messaging config for system name: " + systemName);
        }
        return grouperMessagingConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, GrouperMessagingConfig> retrieveGrouperMessagingConfigs() {
        if (this.grouperMessagingConfigs != null) return this.grouperMessagingConfigs;
        Class<GrouperClientConfig> clazz = GrouperClientConfig.class;
        synchronized (GrouperClientConfig.class) {
            if (this.grouperMessagingConfigs != null) return this.grouperMessagingConfigs;
            HashMap<String, GrouperMessagingConfig> theGrouperMessagingConfigs = new HashMap<String, GrouperMessagingConfig>();
            for (String configName : this.propertyNames()) {
                Matcher matcher = grouperMessagingConfigPattern.matcher(configName);
                if (!matcher.matches()) continue;
                String name = matcher.group(1);
                GrouperMessagingConfig grouperMessagingConfig = new GrouperMessagingConfig();
                grouperMessagingConfig.setName(name);
                String defaultMessagingSystemName = this.propertyValueString("grouper.messaging.system." + name + ".defaultSystemName");
                if (!StringUtils.isBlank(defaultMessagingSystemName)) {
                    grouperMessagingConfig.setDefaultSystemName(defaultMessagingSystemName);
                }
                String theClassName = grouperMessagingConfig.propertyValueString(this, "class");
                try {
                    Class grouperMessagingSystemClass = GrouperClientUtils.forName(theClassName);
                    if (!GrouperMessagingSystem.class.isAssignableFrom(grouperMessagingSystemClass)) {
                        throw new RuntimeException(theClassName + " class does not implement " + GrouperMessagingSystem.class.getName());
                    }
                    grouperMessagingConfig.setTheClass(grouperMessagingSystemClass);
                    theGrouperMessagingConfigs.put(name, grouperMessagingConfig);
                }
                catch (Exception e) {
                    log.error("Cant instantiate messaging system: " + name + ", " + theClassName, e);
                }
            }
            this.grouperMessagingConfigs = theGrouperMessagingConfigs;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.grouperMessagingConfigs;
        }
    }
}

