/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.discovery.DiscoveryClient;
import edu.internet2.middleware.grouperClient.failover.FailoverClient;
import edu.internet2.middleware.grouperClient.failover.FailoverConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientConfig;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.morphString.Crypto;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;

public class GrouperClientLdapUtils {
    private static Log LOG = GrouperClientUtils.retrieveLog(GrouperClientLdapUtils.class);
    private static Integer configureEverySeconds = null;
    private static Long lastFailoverConfigure = null;
    public static final String LDAP_FAILOVER_CONFIG_NAME = "grouperLdap";
    public static File lastDiscoveryConfigFile = null;

    public static DirContext retrieveContext(String ldapUrl) {
        LinkedHashMap<String, String> debugMap;
        LinkedHashMap<String, String> linkedHashMap = debugMap = LOG.isDebugEnabled() ? new LinkedHashMap<String, String>() : null;
        if (debugMap != null) {
            debugMap.put("method", "GrouperClientLdapUtils.retrieveContext");
        }
        String ldapUser = null;
        String ldapPass = null;
        try {
            InitialDirContext context;
            Hashtable<String, String> env = new Hashtable<String, String>();
            String ldapsSocketFactoryName = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.ldaps.customSocketFactory");
            if (!GrouperClientUtils.isBlank(ldapsSocketFactoryName) && ldapUrl.startsWith("ldaps")) {
                Class ldapsSocketFactoryClass = GrouperClientUtils.forName(ldapsSocketFactoryName);
                env.put("java.naming.ldap.factory.socket", ldapsSocketFactoryClass.getName());
            }
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", ldapUrl);
            if (debugMap != null) {
                debugMap.put("LDAP url", ldapUrl);
                debugMap.put("LDAP authentication type", "simple");
            }
            String userLabel = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.ldap.user.label");
            ldapUser = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.ldap." + userLabel);
            String ldapUserPrefix = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.ldap.user.prefix");
            String ldapUserSuffix = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.ldap.user.suffix");
            ldapUser = ldapUserPrefix + ldapUser + ldapUserSuffix;
            if (debugMap != null) {
                debugMap.put("LDAP user", ldapUser);
            }
            env.put("java.naming.security.principal", ldapUser);
            boolean disableExternalFileLookup = GrouperClientConfig.retrieveConfig().propertyValueBooleanRequired("encrypt.disableExternalFileLookup");
            ldapPass = GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.ldap.password");
            String ldapPassFromFile = GrouperClientUtils.readFromFileIfFile(ldapPass, disableExternalFileLookup);
            String passPrefix = null;
            if (!GrouperClientUtils.equals(ldapPass, ldapPassFromFile)) {
                passPrefix = "LDAP pass: reading encrypted value from file: " + ldapPass;
                String encryptKey = GrouperClientUtils.encryptKey();
                ldapPass = new Crypto(encryptKey).decrypt(ldapPassFromFile);
            } else {
                passPrefix = "LDAP pass: reading scalar value from grouper.client.properties";
            }
            if (GrouperClientConfig.retrieveConfig().propertyValueBoolean("grouperClient.logging.logMaskedPassword", false) && debugMap != null) {
                debugMap.put("Pass", passPrefix + ": " + GrouperClientUtils.repeat("*", ldapPass.length()));
            }
            env.put("java.naming.security.credentials", ldapPass);
            InitialDirContext initialDirContext = context = new InitialDirContext(env);
            return initialDirContext;
        }
        catch (NamingException ne) {
            throw new RuntimeException("Problem connecting to ldap: url: " + ldapUrl + ", user: " + ldapUser, ne);
        }
        finally {
            if (debugMap != null) {
                LOG.debug(GrouperClientUtils.mapToString(debugMap));
            }
        }
    }

    public static void printAttributes(Attributes attributes) throws NamingException {
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        GrouperClientLdapUtils.printNamingEnumeration(namingEnumeration);
    }

    public static void printNamingEnumeration(NamingEnumeration<?> namingEnumeration) throws NamingException {
        while (namingEnumeration.hasMore()) {
            Object nextElement = namingEnumeration.next();
            if (nextElement instanceof Attribute) {
                Attribute attribute = (Attribute)nextElement;
                GrouperClientLdapUtils.printAttribute(attribute);
                continue;
            }
            if (nextElement instanceof SearchResult) {
                SearchResult searchResult = (SearchResult)nextElement;
                System.out.println("Search result: " + searchResult.getNameInNamespace());
                Attributes attributes = searchResult.getAttributes();
                GrouperClientLdapUtils.printAttributes(attributes);
                continue;
            }
            if (nextElement instanceof NameClassPair) {
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                System.out.println("Name class pair: " + nameClassPair.getClassName() + ", " + nameClassPair.getNameInNamespace());
                continue;
            }
            throw new RuntimeException("Not expecting type: " + nextElement);
        }
    }

    public static String retrieveAttributeStringValue(Object object, String attributeName) throws NamingException {
        LinkedHashMap<String, String> debugLog;
        if (object == null) {
            return null;
        }
        LinkedHashMap<String, String> linkedHashMap = debugLog = LOG.isDebugEnabled() ? new LinkedHashMap<String, String>() : null;
        if (debugLog != null) {
            debugLog.put("method", "GrouperClientLdapUtils.retrieveAttributeStringValue");
        }
        try {
            if (object instanceof Attribute) {
                Attribute attribute = (Attribute)object;
                if (GrouperClientUtils.equals(attribute.getID(), attributeName)) {
                    String value = (String)attribute.get();
                    if (debugLog != null) {
                        debugLog.put("LDAP found attribute: '" + attributeName + "' with value", "'" + value + "'");
                    }
                    String string = value;
                    return string;
                }
                if (debugLog != null) {
                    debugLog.put("LDAP didnt find attribute: '" + attributeName + "'", "instead found attribute: '" + attribute.getID() + "'");
                }
                String value = null;
                return value;
            }
            if (object instanceof SearchResult) {
                if (debugLog != null) {
                    debugLog.put("LDAP found ", "SearchResult");
                }
                SearchResult searchResult = (SearchResult)object;
                Attributes attributes = searchResult.getAttributes();
                Attribute attribute = attributes.get(attributeName);
                if (debugLog != null) {
                    debugLog.put("LDAP SearchResult attributes has attribute", "'" + attributeName + "'? " + (attribute != null));
                }
                String string = GrouperClientLdapUtils.retrieveAttributeStringValue(attribute, attributeName);
                return string;
            }
            if (object instanceof NamingEnumeration) {
                NamingEnumeration namingEnumeration = (NamingEnumeration)object;
                if (!namingEnumeration.hasMore()) {
                    if (debugLog != null) {
                        debugLog.put("LDAP found empty", "NamingEnumeration");
                    }
                    String attributes = null;
                    return attributes;
                }
                Object next = namingEnumeration.next();
                if (namingEnumeration.hasMore()) {
                    if (debugLog != null) {
                        debugLog.put("LDAP found more than one element in", "NamingEnumeration");
                    }
                    throw new RuntimeException("Expecting one result");
                }
                if (debugLog != null) {
                    debugLog.put("LDAP processing NamingEnumeration of size", "one");
                }
                String string = GrouperClientLdapUtils.retrieveAttributeStringValue(next, attributeName);
                return string;
            }
            throw new RuntimeException("Not expecting type: " + object);
        }
        finally {
            if (debugLog != null) {
                LOG.debug(GrouperClientUtils.mapToString(debugLog));
            }
        }
    }

    public static List<String> retrieveAttributeStringListValue(Object object, String attributeName) throws NamingException {
        if (object == null) {
            LOG.debug("LDAP object is null looking for list of string attributes: '" + attributeName + "'");
            return null;
        }
        if (object instanceof Attribute) {
            LOG.debug("LDAP found attribute: '" + attributeName + "'");
            Attribute attribute = (Attribute)object;
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            return GrouperClientLdapUtils.retrieveAttributeStringListValue(namingEnumeration, attributeName);
        }
        if (object instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)object;
            Attributes attributes = searchResult.getAttributes();
            Attribute attribute = attributes.get(attributeName);
            LOG.debug("LDAP found SearchResult for attribute: '" + attributeName + "', found attribute? " + (attribute != null));
            return GrouperClientLdapUtils.retrieveAttributeStringListValue(attribute, attributeName);
        }
        if (object instanceof NamingEnumeration) {
            LOG.debug("LDAP found NamingEnumeration for attribute: '" + attributeName + "'");
            int size = 0;
            NamingEnumeration namingEnumeration = (NamingEnumeration)object;
            ArrayList<String> resultList = new ArrayList<String>();
            while (namingEnumeration.hasMore()) {
                Object next = namingEnumeration.next();
                if (next instanceof SearchResult) {
                    if (size == 0 && !namingEnumeration.hasMore()) {
                        LOG.debug("LDAP found SearchResult in NamingEnumeration for attribute: '" + attributeName + "'");
                        return GrouperClientLdapUtils.retrieveAttributeStringListValue(next, attributeName);
                    }
                    LOG.debug("LDAP found multiple SearchResults in NamingEnumeration for attribute: '" + attributeName + "'");
                    throw new RuntimeException("Error: multiple search results found!");
                }
                resultList.add((String)next);
                ++size;
            }
            if (size == 0) {
                LOG.debug("LDAP did not found SearchResult in NamingEnumeration for attribute: '" + attributeName + "'");
                return null;
            }
            return resultList;
        }
        throw new RuntimeException("Not expecting type: " + object.getClass() + ", " + object);
    }

    public static void printAttribute(Attribute attribute) throws NamingException {
        System.out.print("Attribute: " + attribute.getID() + ": ");
        NamingEnumeration<?> namingEnumeration3 = attribute.getAll();
        while (namingEnumeration3.hasMore()) {
            System.out.print((String)namingEnumeration3.next() + ", ");
        }
        System.out.println("");
    }

    private static boolean needsReconfigure() {
        boolean needsReconfigure;
        boolean bl = needsReconfigure = lastFailoverConfigure == null || (System.currentTimeMillis() - lastFailoverConfigure) / 1000L > (long)configureEverySeconds.intValue();
        if (!DiscoveryClient.hasDiscovery() && lastFailoverConfigure != null) {
            needsReconfigure = false;
        }
        return needsReconfigure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureFailoverClient() {
        int cacheForSeconds;
        LinkedHashMap<String, Object> debugLog;
        LinkedHashMap<String, Object> linkedHashMap = debugLog = LOG.isDebugEnabled() ? new LinkedHashMap<String, Object>() : null;
        if (debugLog != null) {
            debugLog.put("method", "GrouperClientLdapUtils.configureFailoverClient");
        }
        if (configureEverySeconds == null && (configureEverySeconds = Integer.valueOf((cacheForSeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.cacheDiscoveryPropertiesForSeconds", 120)) / 5)) < 20) {
            configureEverySeconds = 20;
        }
        boolean needsReconfigure = GrouperClientLdapUtils.needsReconfigure();
        if (debugLog != null) {
            debugLog.put("needsReconfigure", needsReconfigure);
        }
        if (needsReconfigure) {
            try {
                Class<GrouperClientWs> clazz = GrouperClientWs.class;
                synchronized (GrouperClientWs.class) {
                    if (GrouperClientLdapUtils.needsReconfigure()) {
                        File discoveryFile;
                        String fileName = "grouper.client.discovery.properties";
                        String directoryName = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.discoveryGrouperClientPropertiesDirectory");
                        if (!GrouperClientUtils.isBlank(directoryName)) {
                            directoryName = GrouperClientUtils.stripLastSlashIfExists(directoryName);
                            fileName = directoryName + "/" + fileName;
                        }
                        if ((discoveryFile = DiscoveryClient.retrieveFile(fileName, false)) == null) {
                            if (debugLog != null) {
                                if (DiscoveryClient.hasDiscovery()) {
                                    debugLog.put("discoveryFile", "not found");
                                } else {
                                    debugLog.put("discoveryFile", "not configured to use");
                                }
                            }
                            if (lastFailoverConfigure != null) {
                                needsReconfigure = false;
                            }
                            if (DiscoveryClient.hasDiscovery()) {
                                LOG.error("Cant find discovery file: '" + fileName + "'!!!!!!!");
                            }
                        } else {
                            if (debugLog != null) {
                                debugLog.put("discoveryFile", discoveryFile.getAbsolutePath());
                            }
                            if (lastDiscoveryConfigFile != null && lastDiscoveryConfigFile.equals(discoveryFile)) {
                                needsReconfigure = false;
                            }
                        }
                        if (debugLog != null) {
                            debugLog.put("needsReconfigureFile", needsReconfigure);
                        }
                        if (needsReconfigure) {
                            String ldapUrl;
                            FailoverConfig.FailoverStrategy failoverStrategy;
                            String ldapUrl2;
                            FailoverConfig failoverConfig = new FailoverConfig();
                            boolean foundOne = false;
                            ArrayList<String> ldapUrls = new ArrayList<String>();
                            for (int i = 0; i < 100 && !GrouperClientUtils.isBlank(ldapUrl2 = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.discoveryDefault.ldap." + i + ".url")); ++i) {
                                foundOne = true;
                                if (GrouperClientUtils.isBlank(ldapUrl2)) continue;
                                ldapUrls.add(ldapUrl2);
                            }
                            if (foundOne) {
                                failoverConfig.setConnectionNames(ldapUrls);
                            }
                            if ((failoverStrategy = FailoverConfig.FailoverStrategy.valueOfIgnoreCase(GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.discoveryDefault.ldap.loadBalancing"), false)) != null) {
                                failoverConfig.setFailoverStrategy(failoverStrategy);
                            }
                            int affinitySeconds = failoverConfig.getAffinitySeconds();
                            affinitySeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discoveryDefault.ldap.affinitySeconds", affinitySeconds);
                            failoverConfig.setAffinitySeconds(affinitySeconds);
                            int lowerConnectionPriorityOnErrorForMinutes = failoverConfig.getMinutesToKeepErrors();
                            lowerConnectionPriorityOnErrorForMinutes = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discoveryDefault.ldap.lowerConnectionPriorityOnErrorForMinutes", lowerConnectionPriorityOnErrorForMinutes);
                            failoverConfig.setMinutesToKeepErrors(lowerConnectionPriorityOnErrorForMinutes);
                            int timeoutSeconds = failoverConfig.getTimeoutSeconds();
                            timeoutSeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discoveryDefault.ldap.timeoutSeconds", timeoutSeconds);
                            failoverConfig.setTimeoutSeconds(timeoutSeconds);
                            int extraTimeoutSeconds = failoverConfig.getExtraTimeoutSeconds();
                            extraTimeoutSeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discoveryDefault.ldap.extraTimeoutSeconds", extraTimeoutSeconds);
                            failoverConfig.setExtraTimeoutSeconds(extraTimeoutSeconds);
                            if (discoveryFile != null) {
                                String ldapUrl3;
                                Properties properties = GrouperClientUtils.propertiesFromFile(discoveryFile);
                                boolean foundOne2 = false;
                                ArrayList<String> ldapUrls2 = new ArrayList<String>();
                                for (int i = 0; i < 100 && !GrouperClientUtils.isBlank(ldapUrl3 = GrouperClientUtils.propertiesValue(properties, "grouperClient.discovery.ldap." + i + ".url")); ++i) {
                                    foundOne2 = true;
                                    if (GrouperClientUtils.isBlank(ldapUrl3)) continue;
                                    ldapUrls2.add(ldapUrl3);
                                }
                                if (foundOne2) {
                                    failoverConfig.setConnectionNames(ldapUrls2);
                                }
                                if ((failoverStrategy = FailoverConfig.FailoverStrategy.valueOfIgnoreCase(GrouperClientUtils.propertiesValue(properties, "grouperClient.discovery.ldap.loadBalancing"), false)) != null) {
                                    failoverConfig.setFailoverStrategy(failoverStrategy);
                                }
                                affinitySeconds = GrouperClientUtils.propertiesValueInt(properties, null, "grouperClient.discovery.ldap.affinitySeconds", affinitySeconds);
                                failoverConfig.setAffinitySeconds(affinitySeconds);
                                lowerConnectionPriorityOnErrorForMinutes = GrouperClientUtils.propertiesValueInt(properties, null, "grouperClient.discovery.ldap.lowerConnectionPriorityOnErrorForMinutes", lowerConnectionPriorityOnErrorForMinutes);
                                failoverConfig.setMinutesToKeepErrors(lowerConnectionPriorityOnErrorForMinutes);
                                timeoutSeconds = GrouperClientUtils.propertiesValueInt(properties, null, "grouperClient.discovery.ldap.timeoutSeconds", timeoutSeconds);
                                failoverConfig.setTimeoutSeconds(timeoutSeconds);
                                extraTimeoutSeconds = GrouperClientUtils.propertiesValueInt(properties, null, "grouperClient.discovery.ldap.extraTimeoutSeconds", extraTimeoutSeconds);
                                failoverConfig.setExtraTimeoutSeconds(extraTimeoutSeconds);
                            }
                            boolean foundOne3 = false;
                            ArrayList<String> ldapUrls3 = new ArrayList<String>();
                            for (int i = 0; i < 100 && !GrouperClientUtils.isBlank(ldapUrl = GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.discoveryOverride.ldap." + i + ".url")); ++i) {
                                foundOne3 = true;
                                if (GrouperClientUtils.isBlank(ldapUrl)) continue;
                                ldapUrls3.add(ldapUrl);
                            }
                            if (foundOne3) {
                                failoverConfig.setConnectionNames(ldapUrls3);
                            }
                            if ((failoverStrategy = FailoverConfig.FailoverStrategy.valueOfIgnoreCase(GrouperClientConfig.retrieveConfig().propertyValueString("grouperClient.discoveryOverride.ldap.loadBalancing"), false)) != null) {
                                failoverConfig.setFailoverStrategy(failoverStrategy);
                            }
                            affinitySeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discoveryOverride.ldap.affinitySeconds", affinitySeconds);
                            failoverConfig.setAffinitySeconds(affinitySeconds);
                            lowerConnectionPriorityOnErrorForMinutes = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discoveryOverride.ldap.lowerConnectionPriorityOnErrorForMinutes", lowerConnectionPriorityOnErrorForMinutes);
                            failoverConfig.setMinutesToKeepErrors(lowerConnectionPriorityOnErrorForMinutes);
                            timeoutSeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discoveryOverride.ldap.timeoutSeconds", timeoutSeconds);
                            failoverConfig.setTimeoutSeconds(timeoutSeconds);
                            extraTimeoutSeconds = GrouperClientConfig.retrieveConfig().propertyValueInt("grouperClient.discoveryOverride.ldap.extraTimeoutSeconds", extraTimeoutSeconds);
                            failoverConfig.setExtraTimeoutSeconds(extraTimeoutSeconds);
                            if (debugLog != null) {
                                int i = 0;
                                for (String ldapUrl4 : GrouperClientUtils.nonNull(failoverConfig.getConnectionNames())) {
                                    debugLog.put("ldapUrl." + i, ldapUrl4);
                                    ++i;
                                }
                                debugLog.put("affinitySeconds", failoverConfig.getAffinitySeconds());
                                debugLog.put("extraTimeoutSeconds", failoverConfig.getExtraTimeoutSeconds());
                                debugLog.put("errorsForMinutes", failoverConfig.getMinutesToKeepErrors());
                                debugLog.put("failoverStrategy", (Object)failoverConfig.getFailoverStrategy());
                                debugLog.put("timeoutSeconds", failoverConfig.getTimeoutSeconds());
                            }
                            if (GrouperClientUtils.length(failoverConfig.getConnectionNames()) == 0) {
                                failoverConfig.setConnectionNames(GrouperClientUtils.toList(GrouperClientConfig.retrieveConfig().propertyValueStringRequired("grouperClient.ldap.url")));
                            }
                            failoverConfig.setConnectionType(LDAP_FAILOVER_CONFIG_NAME);
                            FailoverClient.initFailoverClient(failoverConfig);
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            finally {
                if (debugLog != null) {
                    LOG.debug(GrouperClientUtils.mapToString(debugLog));
                }
            }
        }
        {
            return;
        }
    }
}

