/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.basic;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.Converter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.MarshallingContext;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.SingleValueConverter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.UnmarshallingContext;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class CharConverter
implements Converter,
SingleValueConverter {
    @Override
    public boolean canConvert(Class type) {
        return type.equals(Character.TYPE) || type.equals(Character.class);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(this.toString(source));
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String nullAttribute = reader.getAttribute("null");
        if (nullAttribute != null && nullAttribute.equals("true")) {
            return new Character('\u0000');
        }
        return this.fromString(reader.getValue());
    }

    @Override
    public Object fromString(String str) {
        if (str.length() == 0) {
            return new Character('\u0000');
        }
        return new Character(str.charAt(0));
    }

    @Override
    public String toString(Object obj) {
        char ch = ((Character)obj).charValue();
        return ch == '\u0000' ? "" : obj.toString();
    }
}

