/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.converters.ErrorWriter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.StreamException;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.AbstractPullReader;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XppReader
extends AbstractPullReader {
    private final XmlPullParser parser;
    private final BufferedReader reader;

    public XppReader(Reader reader) {
        this(reader, new XmlFriendlyReplacer());
    }

    public XppReader(Reader reader, XmlFriendlyReplacer replacer) {
        super(replacer);
        try {
            this.parser = this.createParser();
            this.reader = new BufferedReader(reader);
            this.parser.setInput((Reader)this.reader);
            this.moveDown();
        }
        catch (XmlPullParserException e) {
            throw new StreamException(e);
        }
    }

    protected XmlPullParser createParser() {
        return new MXParser();
    }

    @Override
    protected int pullNextEvent() {
        try {
            switch (this.parser.next()) {
                case 0: 
                case 2: {
                    return 1;
                }
                case 1: 
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 9: {
                    return 4;
                }
            }
            return 0;
        }
        catch (XmlPullParserException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    @Override
    protected String pullElementName() {
        return this.parser.getName();
    }

    @Override
    protected String pullText() {
        return this.parser.getText();
    }

    @Override
    public String getAttribute(String name) {
        return this.parser.getAttributeValue(null, name);
    }

    @Override
    public String getAttribute(int index) {
        return this.parser.getAttributeValue(index);
    }

    @Override
    public int getAttributeCount() {
        return this.parser.getAttributeCount();
    }

    @Override
    public String getAttributeName(int index) {
        return this.unescapeXmlName(this.parser.getAttributeName(index));
    }

    @Override
    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("line number", String.valueOf(this.parser.getLineNumber()));
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }
}

