/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl2.internal.introspection;

import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl2.internal.introspection.ClassMap;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.jexl2.internal.introspection.MethodKey;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class IntrospectorBase {
    protected final Log rlog;
    private final Map<Class<?>, ClassMap> classMethodMaps = new HashMap();
    private ClassLoader loader;
    private final Map<MethodKey, Constructor<?>> constructorsMap = new HashMap();
    private final Map<String, Class<?>> constructibleClasses = new HashMap();
    private static final Constructor<?> CTOR_MISS = CacheMiss.class.getConstructors()[0];

    public IntrospectorBase(Log log) {
        this.rlog = log;
        this.loader = this.getClass().getClassLoader();
    }

    public Class<?> getClassByName(String className) {
        try {
            return Class.forName(className, false, this.loader);
        }
        catch (ClassNotFoundException xignore) {
            return null;
        }
    }

    public Method getMethod(Class<?> c, MethodKey key) {
        try {
            ClassMap classMap = this.getMap(c);
            return classMap.findMethod(key);
        }
        catch (MethodKey.AmbiguousException xambiguous) {
            if (this.rlog != null && this.rlog.isInfoEnabled()) {
                this.rlog.info("ambiguous method invocation: " + c.getName() + "." + key.debugString(), xambiguous);
            }
            return null;
        }
    }

    public Field getField(Class<?> c, String key) {
        ClassMap classMap = this.getMap(c);
        return classMap.findField(c, key);
    }

    public String[] getFieldNames(Class<?> c) {
        if (c == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c);
        return classMap.getFieldNames();
    }

    public String[] getMethodNames(Class<?> c) {
        if (c == null) {
            return new String[0];
        }
        ClassMap classMap = this.getMap(c);
        return classMap.getMethodNames();
    }

    public Method[] getMethods(Class<?> c, String methodName) {
        if (c == null) {
            return null;
        }
        ClassMap classMap = this.getMap(c);
        return classMap.get(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoader(ClassLoader cloader) {
        ClassLoader previous = this.loader;
        if (cloader == null) {
            cloader = this.getClass().getClassLoader();
        }
        if (!cloader.equals(this.loader)) {
            Class clazz;
            Map.Entry<Object, Object> entry;
            Iterator<Map.Entry<Object, Object>> entries;
            Map<Object, Object> map = this.constructorsMap;
            synchronized (map) {
                entries = this.constructorsMap.entrySet().iterator();
                while (entries.hasNext()) {
                    entry = entries.next();
                    clazz = entry.getValue().getDeclaringClass();
                    if (!IntrospectorBase.isLoadedBy(previous, clazz)) continue;
                    entries.remove();
                    this.constructibleClasses.remove(entry.getKey().getMethod());
                }
            }
            map = this.classMethodMaps;
            synchronized (map) {
                entries = this.classMethodMaps.entrySet().iterator();
                while (entries.hasNext()) {
                    entry = entries.next();
                    clazz = (Class)entry.getKey();
                    if (!IntrospectorBase.isLoadedBy(previous, clazz)) continue;
                    entries.remove();
                }
            }
            this.loader = cloader;
        }
    }

    private static boolean isLoadedBy(ClassLoader loader, Class<?> clazz) {
        if (loader != null) {
            for (ClassLoader cloader = clazz.getClassLoader(); cloader != null; cloader = cloader.getParent()) {
                if (!cloader.equals(loader)) continue;
                return true;
            }
        }
        return false;
    }

    public Constructor<?> getConstructor(MethodKey key) {
        return this.getConstructor(null, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constructor<?> getConstructor(Class<?> c, MethodKey key) {
        Constructor<?> ctor = null;
        Map<MethodKey, Constructor<?>> map = this.constructorsMap;
        synchronized (map) {
            ctor = this.constructorsMap.get(key);
            if (CTOR_MISS.equals(ctor)) {
                return null;
            }
            if (ctor == null) {
                String cname = key.getMethod();
                Class<?> clazz = this.constructibleClasses.get(cname);
                try {
                    if (clazz == null) {
                        clazz = c != null && c.getName().equals(key.getMethod()) ? c : this.loader.loadClass(cname);
                        this.constructibleClasses.put(cname, clazz);
                    }
                    LinkedList l = new LinkedList();
                    for (Constructor<?> ictor : clazz.getConstructors()) {
                        l.add(ictor);
                    }
                    ctor = key.getMostSpecificConstructor(l);
                    if (ctor != null) {
                        this.constructorsMap.put(key, ctor);
                    } else {
                        this.constructorsMap.put(key, CTOR_MISS);
                    }
                }
                catch (ClassNotFoundException xnotfound) {
                    if (this.rlog != null && this.rlog.isInfoEnabled()) {
                        this.rlog.info("unable to find class: " + cname + "." + key.debugString(), xnotfound);
                    }
                    ctor = null;
                }
                catch (MethodKey.AmbiguousException xambiguous) {
                    if (this.rlog != null && this.rlog.isInfoEnabled()) {
                        this.rlog.info("ambiguous constructor invocation: " + cname + "." + key.debugString(), xambiguous);
                    }
                    ctor = null;
                }
            }
            return ctor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassMap getMap(Class<?> c) {
        Map<Class<?>, ClassMap> map = this.classMethodMaps;
        synchronized (map) {
            ClassMap classMap = this.classMethodMaps.get(c);
            if (classMap == null) {
                classMap = new ClassMap(c, this.rlog);
                this.classMethodMaps.put(c, classMap);
            }
            return classMap;
        }
    }

    private static class CacheMiss {
    }
}

