/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct;

import edu.iu.uits.lms.canvas.config.EnableCanvasClient;
import edu.iu.uits.lms.common.batch.EnableBatch;
import edu.iu.uits.lms.common.samesite.EnableCookieFilter;
import edu.iu.uits.lms.common.server.GitRepositoryState;
import edu.iu.uits.lms.common.server.ServerInfo;
import edu.iu.uits.lms.common.server.ServerUtils;
import edu.iu.uits.lms.common.session.EnableCourseSessionService;
import edu.iu.uits.lms.email.config.EnableEmailClient;
import edu.iu.uits.lms.gct.config.ToolConfig;
import edu.iu.uits.lms.iuonly.config.EnableIuOnlyClient;
import edu.iu.uits.lms.lti.config.EnableGlobalErrorHandler;
import edu.iu.uits.lms.lti.config.EnableLtiClient;
import edu.iu.uits.lms.redis.config.EnableRedisConfiguration;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.metrics.ApplicationStartup;

@SpringBootApplication
@EnableGlobalErrorHandler
@EnableRedisConfiguration
@EnableCookieFilter(ignoredRequestPatterns={"/rest/**"})
@EnableLtiClient(toolKeys={"lms_lti_gct"})
@EnableCanvasClient
@EnableIuOnlyClient
@EnableEmailClient
@EnableConfigurationProperties(value={GitRepositoryState.class})
@EnableCourseSessionService(sessionKey="gct_course_session")
@EnableBatch
public class WebApplication {
    private static final Logger log = LoggerFactory.getLogger(WebApplication.class);
    @Autowired
    private ToolConfig toolConfig;
    private static final int STEP_CAPACITY = 2048;
    @Autowired
    private GitRepositoryState gitRepositoryState;

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{WebApplication.class});
        BufferingApplicationStartup startup = new BufferingApplicationStartup(2048);
        startup.addFilter(startupStep -> startupStep.getName().matches("spring.boot.application.ready"));
        app.setApplicationStartup((ApplicationStartup)startup);
        app.run(args);
    }

    @Bean(name={"serverInfo"})
    ServerInfo serverInfo() {
        return ServerInfo.builder().serverName(ServerUtils.getServerHostName()).environment(this.toolConfig.getEnv()).buildDate(new Date()).gitInfo(this.gitRepositoryState.getBranch() + "@" + this.gitRepositoryState.getCommitIdAbbrev()).artifactVersion(this.toolConfig.getVersion()).build();
    }
}

