/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.amqp;

import com.rabbitmq.client.Channel;
import edu.iu.uits.lms.gct.amqp.DropboxMessage;
import edu.iu.uits.lms.gct.services.GoogleCourseToolsService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

@RabbitListener(queues={"${gct.dropboxQueueName}"})
@Profile(value={"!batch"})
@Component
public class DropboxMessageListener {
    private static final Logger log = LoggerFactory.getLogger(DropboxMessageListener.class);
    @Autowired
    private GoogleCourseToolsService googleCourseToolsService;

    @RabbitHandler
    public void receive(DropboxMessage message, Channel channel, @Header(value="amqp_deliveryTag") long deliveryTag) {
        log.info("Received <{}>", (Object)message);
        try {
            channel.basicAck(deliveryTag, false);
            this.googleCourseToolsService.createStudentDropboxFolders(message.getCourseId(), message.getCourseTitle(), message.getDropboxFolderId(), message.getAllGroupEmail(), message.getTeacherGroupEmail());
        }
        catch (IOException e) {
            log.error("Error creating student dropboxes", (Throwable)e);
        }
    }
}

