/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.amqp;

import com.rabbitmq.client.Channel;
import edu.iu.uits.lms.gct.amqp.RosterSyncMessage;
import edu.iu.uits.lms.gct.services.GoogleCourseToolsService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.stereotype.Component;

@RabbitListener(queues={"${gct.rosterSyncQueueName}"})
@Component
@Profile(value={"!batch"})
public class RosterSyncMessageListener {
    private static final Logger log = LoggerFactory.getLogger(RosterSyncMessageListener.class);
    @Autowired
    private GoogleCourseToolsService googleCourseToolsService;

    @RabbitHandler
    public void receive(RosterSyncMessage message, Channel channel, @Header(value="amqp_deliveryTag") long deliveryTag) {
        log.info("Received <{}>", (Object)message);
        try {
            channel.basicAck(deliveryTag, false);
            this.googleCourseToolsService.rosterSync(message.getCourseData(), message.isSendNotificationForCourse());
        }
        catch (IOException e) {
            log.error("Error performing roster sync", (Throwable)e);
        }
    }
}

