/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.amqp;

import edu.iu.uits.lms.gct.amqp.RosterSyncMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RosterSyncMessageSender {
    private static final Logger log = LoggerFactory.getLogger(RosterSyncMessageSender.class);
    @Autowired
    private RabbitTemplate template;
    @Autowired
    @Qualifier(value="rosterSyncQueue")
    private Queue queue;

    public void send(RosterSyncMessage message) {
        log.info("Sending message to queue {}", (Object)this.queue.getName());
        this.template.convertAndSend(this.queue.getName(), (Object)message);
    }
}

