/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.config;

import edu.iu.uits.lms.gct.services.CacheListener;
import java.util.concurrent.TimeUnit;
import javax.cache.Caching;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;

@Profile(value={"ehcache"})
@Configuration
@EnableCaching
public class EhCacheConfig {
    private static final Logger log = LoggerFactory.getLogger(EhCacheConfig.class);

    @Bean(name={"GoogleCourseToolsCacheManager"})
    @Primary
    public CacheManager cacheManager() {
        log.debug("CacheManager");
        int ttl = 3600;
        MutableCacheEntryListenerConfiguration listenerConfiguration = new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf(CacheListener.class), null, false, false);
        MutableConfiguration mutableLongConfiguration = new MutableConfiguration().setTypes(Object.class, Object.class).setStoreByValue(false).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 3600L))).setManagementEnabled(true).setStatisticsEnabled(true).addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfiguration);
        CachingProvider provider = Caching.getCachingProvider((String)"org.ehcache.jsr107.EhcacheCachingProvider");
        javax.cache.CacheManager cacheManager = provider.getCacheManager();
        this.createCacheIfMissing(cacheManager, "driveServiceAsUser", mutableLongConfiguration);
        return new JCacheCacheManager(cacheManager);
    }

    private void createCacheIfMissing(javax.cache.CacheManager cacheManager, String cacheName, MutableConfiguration<Object, Object> cacheConfig) {
        if (cacheManager.getCache(cacheName, Object.class, Object.class) == null) {
            cacheManager.createCache(cacheName, cacheConfig);
        }
    }
}

