/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.config;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration(value="gctDbConfig")
@EnableJpaRepositories(entityManagerFactoryRef="gctEntityMgrFactory", transactionManagerRef="gctTransactionMgr", basePackages={"edu.iu.uits.lms.gct.repository"})
@EnableTransactionManagement
public class PostgresDBConfig {
    @Primary
    @Bean(name={"gctDataSource"})
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource dataSource(DataSourceProperties properties) {
        return properties.initializeDataSourceBuilder().build();
    }

    @Bean(name={"gctEntityMgrFactory"})
    @Primary
    public LocalContainerEntityManagerFactoryBean gctEntityMgrFactory(EntityManagerFactoryBuilder builder, @Qualifier(value="gctDataSource") DataSource dataSource) {
        HashMap properties = new HashMap();
        return builder.dataSource(dataSource).properties(properties).packages(new String[]{"edu.iu.uits.lms.gct.model"}).build();
    }

    @Bean(name={"gctTransactionMgr"})
    @Primary
    public PlatformTransactionManager gctTransactionMgr(@Qualifier(value="gctEntityMgrFactory") EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }
}

