/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.config;

import edu.iu.uits.lms.gct.config.ToolConfig;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

@Profile(value={"redis-cache"})
@Configuration
@EnableCaching
public class RedisCacheConfig {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheConfig.class);
    @Autowired
    private ToolConfig toolConfig;
    @Autowired
    private JedisConnectionFactory redisConnectionFactory;

    @Bean
    public RedisCacheConfiguration cacheConfiguration() {
        int ttl = 3600;
        return RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(3600L)).disableCachingNullValues().prefixCacheNameWith(this.toolConfig.getEnv() + "-gct");
    }

    @Bean(name={"GoogleCourseToolsCacheManager"})
    @Primary
    public CacheManager cacheManager() {
        log.debug("cacheManager()");
        log.debug("Redis hostname: {}", (Object)this.redisConnectionFactory.getHostName());
        return RedisCacheManager.builder((RedisConnectionFactory)this.redisConnectionFactory).build();
    }
}

