/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.controller;

import com.google.api.services.drive.model.File;
import edu.iu.uits.lms.common.session.CourseSessionService;
import edu.iu.uits.lms.gct.Constants;
import edu.iu.uits.lms.gct.amqp.DropboxMessage;
import edu.iu.uits.lms.gct.amqp.DropboxMessageSender;
import edu.iu.uits.lms.gct.amqp.RosterSyncMessage;
import edu.iu.uits.lms.gct.amqp.RosterSyncMessageSender;
import edu.iu.uits.lms.gct.config.ToolConfig;
import edu.iu.uits.lms.gct.controller.ToolController;
import edu.iu.uits.lms.gct.mailinglist.MxRecord;
import edu.iu.uits.lms.gct.mailinglist.MxRecordService;
import edu.iu.uits.lms.gct.model.CourseGroupWrapper;
import edu.iu.uits.lms.gct.model.CourseInfo;
import edu.iu.uits.lms.gct.model.CourseInit;
import edu.iu.uits.lms.gct.model.DropboxInit;
import edu.iu.uits.lms.gct.model.GroupsInit;
import edu.iu.uits.lms.gct.model.MainMenuPermissions;
import edu.iu.uits.lms.gct.model.MenuFolderLink;
import edu.iu.uits.lms.gct.model.NotificationData;
import edu.iu.uits.lms.gct.model.RosterSyncCourseData;
import edu.iu.uits.lms.gct.model.SerializableGroup;
import edu.iu.uits.lms.gct.model.SharedFilePermission;
import edu.iu.uits.lms.gct.model.SharedFilePermissionModel;
import edu.iu.uits.lms.gct.model.TokenInfo;
import edu.iu.uits.lms.gct.model.UserInit;
import edu.iu.uits.lms.gct.services.GoogleCourseToolsService;
import edu.iu.uits.lms.gct.services.MainMenuPermissionsUtil;
import edu.iu.uits.lms.lti.controller.OidcTokenAwareController;
import edu.iu.uits.lms.lti.service.OidcTokenUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import uk.ac.ox.ctl.lti13.security.oauth2.client.lti.authentication.OidcAuthenticationToken;

@Controller
@RequestMapping(value={"/app"})
public class ToolController
extends OidcTokenAwareController {
    private static final Logger log = LoggerFactory.getLogger(ToolController.class);
    @Autowired
    private ToolConfig toolConfig = null;
    @Autowired
    private GoogleCourseToolsService googleCourseToolsService;
    @Autowired
    private DropboxMessageSender dropboxMessageSender;
    @Autowired
    private RosterSyncMessageSender rosterSyncMessageSender;
    @Autowired
    private CourseSessionService courseSessionService;
    @Autowired
    private MxRecordService mxRecordService;
    private static final String INITIALIZED = "initialized";

    @RequestMapping(value={"/launch", "/loading"})
    public String loading(Model model, SecurityContextHolderAwareRequestWrapper request) {
        OidcAuthenticationToken token = this.getTokenWithoutContext();
        OidcTokenUtils oidcTokenUtils = new OidcTokenUtils(token);
        String userEmail = oidcTokenUtils.getPersonEmail();
        String userSisId = oidcTokenUtils.getSisUserId();
        String courseId = oidcTokenUtils.getCourseId();
        String courseSisId = oidcTokenUtils.getLisValue("course_offering_sourcedid");
        String courseCode = oidcTokenUtils.getContextValue("label");
        String courseTitle = oidcTokenUtils.getContextValue("title");
        HttpSession session = request.getSession();
        this.courseSessionService.addAttributeToSession(session, courseId, "course_title", (Object)courseTitle);
        this.courseSessionService.addAttributeToSession(session, courseId, "user_email", (Object)userEmail);
        this.courseSessionService.addAttributeToSession(session, courseId, "user_sis_id", (Object)userSisId);
        this.courseSessionService.addAttributeToSession(session, courseId, "course_sis_id", (Object)courseSisId);
        this.courseSessionService.addAttributeToSession(session, courseId, "course_code", (Object)courseCode);
        session.removeAttribute(INITIALIZED);
        model.addAttribute("courseId", (Object)courseId);
        model.addAttribute("hideFooter", (Object)true);
        return "loading";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/index/{courseId}"})
    @Secured(value={"ROLE_USER"})
    public ModelAndView index(@PathVariable(value="courseId") String courseId, Model model, HttpServletRequest request) {
        log.debug("in /index");
        OidcAuthenticationToken token = this.getValidatedToken(courseId);
        OidcTokenUtils oidcTokenUtils = new OidcTokenUtils(token);
        boolean isInstructor = request.isUserInRole("ROLE_LTI_INSTRUCTOR");
        boolean isTa = request.isUserInRole("ROLE_LTI_TA");
        boolean isDesigner = request.isUserInRole("ROLE_LTI_DESIGNER");
        boolean isStudent = request.isUserInRole("ROLE_LTI_STUDENT");
        boolean isObserver = request.isUserInRole("ROLE_LTI_OB");
        CourseInit courseInit = this.googleCourseToolsService.getCourseInit(courseId);
        String loginId = oidcTokenUtils.getUserLoginId();
        model.addAttribute("courseId", (Object)courseId);
        HttpSession session = request.getSession();
        String userEmail = (String)this.courseSessionService.getAttributeFromSession(session, courseId, "user_email", String.class);
        String userSisId = (String)this.courseSessionService.getAttributeFromSession(session, courseId, "user_sis_id", String.class);
        boolean displayUserIneligibleWarning = !this.googleCourseToolsService.verifyUserEligibility(userEmail, loginId, userSisId);
        MainMenuPermissions.MainMenuPermissionsBuilder mainMenuPermissionsBuilder = MainMenuPermissions.builder().displayUserIneligibleWarning(displayUserIneligibleWarning);
        String courseTitle = (String)this.courseSessionService.getAttributeFromSession(session, courseId, "course_title", String.class);
        if (isInstructor && courseInit == null && !displayUserIneligibleWarning) {
            if (!this.googleCourseToolsService.titleHasInvalidCharacters(courseTitle)) return this.setup(courseId, model);
            mainMenuPermissionsBuilder.displayBadCourseTitleWarning(true);
        } else if (!displayUserIneligibleWarning && courseInit != null) {
            DropboxInit dropboxInit = this.googleCourseToolsService.getDropboxInit(courseId, loginId);
            String allGroupEmail = null;
            try {
                UserInit ui;
                boolean hasBeenInitialized;
                CourseGroupWrapper groupsForCourse = this.getGroupsForCourse(courseId, request, false, courseTitle, courseInit);
                allGroupEmail = groupsForCourse.getAllGroup().getEmail();
                boolean bl = hasBeenInitialized = session.getAttribute(INITIALIZED) != null;
                if (hasBeenInitialized) {
                    ui = this.googleCourseToolsService.getUserInit(loginId);
                } else {
                    ui = this.googleCourseToolsService.userInitialization(courseId, loginId, courseInit, courseTitle, isInstructor, isTa, isDesigner);
                    session.setAttribute(INITIALIZED, (Object)true);
                }
                model.addAttribute("googleLoginId", (Object)ui.getGoogleLoginId());
                if (isStudent && courseInit.getDropboxFolderId() != null && dropboxInit == null) {
                    dropboxInit = this.googleCourseToolsService.createStudentDropboxFolder(courseId, courseTitle, courseInit.getDropboxFolderId(), loginId, groupsForCourse.getAllGroup().getEmail(), groupsForCourse.getTeacherGroup().getEmail(), dropboxInit);
                }
            }
            catch (IOException e) {
                log.error("Can't get course groups");
            }
            boolean displaySetup = MainMenuPermissionsUtil.displaySetup((boolean)isInstructor);
            boolean displaySyncCourseRoster = MainMenuPermissionsUtil.displaySyncCourseRoster((boolean)isInstructor);
            boolean displayDiscussInGoogleGroups = MainMenuPermissionsUtil.displayDiscussInGoogleGroups((String)courseInit.getMailingListAddress());
            boolean displayShareAndCollaborate = MainMenuPermissionsUtil.displayShareAndCollaborate((boolean)isInstructor, (boolean)isTa, (boolean)isDesigner, (boolean)isStudent, (CourseInit)courseInit, (DropboxInit)dropboxInit);
            boolean displayFolderWrapper = MainMenuPermissionsUtil.displayFolderWrapper((boolean)isInstructor, (boolean)isTa, (boolean)isDesigner, (boolean)isStudent, (boolean)isObserver, (CourseInit)courseInit, (DropboxInit)dropboxInit);
            boolean displayCourseFilesFolder = MainMenuPermissionsUtil.displayCourseFilesFolder((String)courseInit.getCoursefilesFolderId());
            boolean displayDropBoxFolder = MainMenuPermissionsUtil.displayDropBoxFolder((boolean)isInstructor, (boolean)isTa, (boolean)isDesigner, (CourseInit)courseInit);
            boolean displayMyDropBoxFolder = MainMenuPermissionsUtil.displayMyDropBoxFolder((boolean)isStudent, (DropboxInit)dropboxInit);
            boolean displayFileRepository = MainMenuPermissionsUtil.displayFileRepository((String)courseInit.getFileRepoId());
            boolean displayInstructorFilesFolder = MainMenuPermissionsUtil.displayInstructorFilesFolder((boolean)isInstructor, (boolean)isTa, (boolean)isDesigner, (CourseInit)courseInit);
            boolean displayGroupsFolder = MainMenuPermissionsUtil.displayGroupsFolder((String)courseInit.getGroupsFolderId());
            boolean displayCourseInformation = MainMenuPermissionsUtil.displayCourseInformation((CourseInit)courseInit);
            mainMenuPermissionsBuilder.displaySetup(displaySetup).displaySyncCourseRoster(displaySyncCourseRoster).displayDiscussInGoogleGroups(displayDiscussInGoogleGroups).displayShareAndCollaborate(displayShareAndCollaborate).displayFolderWrapper(displayFolderWrapper).displayCourseFilesFolder(displayCourseFilesFolder).displayDropBoxFolder(displayDropBoxFolder).displayMyDropBoxFolder(displayMyDropBoxFolder).displayFileRepository(displayFileRepository).displayInstructorFilesFolder(displayInstructorFilesFolder).displayGroupsFolder(displayGroupsFolder).displayCourseInformation(displayCourseInformation);
            ArrayList<MenuFolderLink> menuFolderLinks = new ArrayList<MenuFolderLink>();
            if (displayCourseFilesFolder) {
                menuFolderLinks.add(new MenuFolderLink(this.getFolderLink(courseInit.getCoursefilesFolderId()), Constants.FOLDER_TYPES.courseFiles.getText()));
            }
            if (displayDropBoxFolder) {
                menuFolderLinks.add(new MenuFolderLink(this.getFolderLink(courseInit.getDropboxFolderId()), Constants.FOLDER_TYPES.dropBoxes.getText()));
            }
            if (displayMyDropBoxFolder) {
                menuFolderLinks.add(new MenuFolderLink(this.getFolderLink(dropboxInit.getFolderId()), Constants.FOLDER_TYPES.mydropBox.getText()));
            }
            if (displayFileRepository) {
                menuFolderLinks.add(new MenuFolderLink(this.getFolderLink(courseInit.getFileRepoId()), Constants.FOLDER_TYPES.fileRepository.getText()));
            }
            if (displayInstructorFilesFolder) {
                menuFolderLinks.add(new MenuFolderLink(this.getFolderLink(courseInit.getInstructorFolderId()), Constants.FOLDER_TYPES.instructorFiles.getText()));
            }
            if (displayGroupsFolder) {
                menuFolderLinks.add(new MenuFolderLink(this.getFolderLink(courseInit.getGroupsFolderId()), Constants.FOLDER_TYPES.groupsFiles.getText()));
            }
            model.addAttribute("menuFolderLinks", menuFolderLinks);
            if (displayDiscussInGoogleGroups && allGroupEmail != null) {
                String allGroupUrl = this.googleCourseToolsService.buildGroupUrlFromEmail(allGroupEmail, false);
                String url = this.googleCourseToolsService.authWrapUrl(allGroupUrl);
                model.addAttribute("allGroupUrl", (Object)url);
            }
        }
        if (displayUserIneligibleWarning) {
            StringBuilder text = new StringBuilder("We're sorry. This tool cannot be used by IU guests. However, the instructor can add you to the Google groups for the course manually, which will allow you to access course resources directly in Google. To request to be added, please contact your instructor and include this link, which provides instructions, in your message: https://kb.iu.edu/d/bgjk#grant-remove.");
            if (courseInit != null && courseInit.getCourseFolderId() != null) {
                try {
                    File folder = this.googleCourseToolsService.getFolder(courseInit.getCourseFolderId());
                    String messagePattern = "<div class=\"rvt-m-top-xs\">Once you have been added, use the link below to navigate to the top-level folder for the course:</div><div class=\"rvt-m-top-xs\"><a href=\"{0}\" target=\"_blank\">{1}</a></div><div class=\"rvt-m-top-xs\">Additional information is available at <a href=\"https://kb.iu.edu/d/bgjk\" target=\"_blank\">https://kb.iu.edu/d/bgjk</a>.</div>";
                    String warningMessageExtras = MessageFormat.format(messagePattern, folder.getWebViewLink(), folder.getName());
                    text.append(warningMessageExtras);
                }
                catch (IOException e) {
                    log.warn("Unable to get folder", (Throwable)e);
                }
            }
            mainMenuPermissionsBuilder.userIneligibleWarningText(text.toString());
        }
        model.addAttribute("mainMenuPermissions", (Object)mainMenuPermissionsBuilder.build());
        return new ModelAndView("index");
    }

    private String getFolderLink(String folderId) {
        String link = null;
        try {
            File folder = this.googleCourseToolsService.getFolder(folderId);
            link = this.googleCourseToolsService.authWrapUrl(folder.getWebViewLink());
        }
        catch (IOException e) {
            log.error("Unable to get folder", (Throwable)e);
        }
        return link;
    }

    @RequestMapping(value={"/setup/{courseId}"})
    @Secured(value={"ROLE_LTI_INSTRUCTOR"})
    public ModelAndView setup(@PathVariable(value="courseId") String courseId, Model model) {
        model.addAttribute("courseId", (Object)courseId);
        CourseInit courseInit = this.googleCourseToolsService.getCourseInit(courseId);
        model.addAttribute("courseInit", (Object)courseInit);
        return new ModelAndView("setup");
    }

    @PostMapping(value={"/setupSubmit/{courseId}"})
    @Secured(value={"ROLE_LTI_INSTRUCTOR"})
    public ModelAndView setupSubmit(@PathVariable(value="courseId") String courseId, Model model, HttpServletRequest request, @RequestParam(value="createCourseFileFolder", required=false) boolean createCourseFileFolder, @RequestParam(value="createInstructorFileFolder", required=false) boolean createInstructorFileFolder, @RequestParam(value="createGroupsFolder", required=false) boolean createCanvasGroupsFolder, @RequestParam(value="createDropboxFolder", required=false) boolean createDropboxFolder, @RequestParam(value="createFileRepositoryFolder", required=false) boolean createFileRepositoryFolder, @RequestParam(value="createMailingList", required=false) boolean createMailingList, @RequestParam(value="taAccess", required=false) boolean taAccess, @RequestParam(value="designerAccess", required=false) boolean designerAccess) {
        OidcAuthenticationToken token = this.getValidatedToken(courseId);
        boolean updatedSomething = false;
        boolean sendNotification = false;
        CourseInit courseInit = this.googleCourseToolsService.getCourseInit(courseId);
        HttpSession session = request.getSession();
        String courseTitle = (String)this.courseSessionService.getAttributeFromSession(session, courseId, "course_title", String.class);
        String courseSisId = (String)this.courseSessionService.getAttributeFromSession(session, courseId, "course_sis_id", String.class);
        String courseCode = (String)this.courseSessionService.getAttributeFromSession(session, courseId, "course_code", String.class);
        ArrayList<String> errors = new ArrayList<String>();
        if (!(courseInit != null || createCourseFileFolder || createInstructorFileFolder || createCanvasGroupsFolder || createDropboxFolder || createFileRepositoryFolder || createMailingList)) {
            errors.add("You must enable at least one Google Course Tools feature before submitting.");
            model.addAttribute("setupErrors", errors);
            return this.setup(courseId, model);
        }
        if (courseInit == null) {
            try {
                courseInit = this.googleCourseToolsService.courseInitialization(courseId, courseTitle, courseSisId, courseCode, createMailingList);
                sendNotification = true;
            }
            catch (IOException e) {
                log.error("Error during course initialization", (Throwable)e);
                errors.add("Error during course initialization. Settings were not saved.  Please try again.");
                model.addAttribute("setupErrors", errors);
                return this.setup(courseId, model);
            }
        }
        NotificationData notificationData = new NotificationData();
        notificationData.setCourseTitle(courseTitle);
        String allGroupEmail = "";
        String allGroupName = "";
        String teacherGroupEmail = "";
        try {
            CourseGroupWrapper groups = this.getGroupsForCourse(courseId, request, false, courseTitle, courseInit);
            allGroupEmail = groups.getAllGroup().getEmail();
            allGroupName = groups.getAllGroup().getName();
            teacherGroupEmail = groups.getTeacherGroup().getEmail();
            notificationData.setAllGroup(groups.getAllGroup());
            notificationData.setTeacherGroup(groups.getTeacherGroup());
            File courseFolder = this.googleCourseToolsService.getFolder(courseInit.getCourseFolderId());
            notificationData.setRootCourseFolder(courseFolder.getName());
        }
        catch (IOException e) {
            errors.add("Error getting group info from Google. Bailing on setup changes.");
            model.addAttribute("setupErrors", errors);
            return this.index(courseId, model, request);
        }
        if (createCourseFileFolder) {
            try {
                File courseFilesFolder = this.googleCourseToolsService.createCourseFileFolder(courseId, courseTitle, teacherGroupEmail);
                courseInit.setCoursefilesFolderId(courseFilesFolder.getId());
                notificationData.setCourseFilesFolder(courseFilesFolder.getName());
            }
            catch (IOException e) {
                String courseFilesFolderError = "Issue with creating the course file folder";
                errors.add(courseFilesFolderError);
                log.error(courseFilesFolderError, (Throwable)e);
            }
            updatedSomething = true;
        }
        if (createInstructorFileFolder) {
            try {
                File instructorFilesFolder = this.googleCourseToolsService.createInstructorFileFolder(courseId, courseTitle, allGroupEmail, teacherGroupEmail);
                courseInit.setInstructorFolderId(instructorFilesFolder.getId());
                notificationData.setInstructorFilesFolder(instructorFilesFolder.getName());
            }
            catch (IOException e) {
                String instructorFolderError = "Issue with creating the instructor file folder";
                errors.add(instructorFolderError);
                log.error(instructorFolderError, (Throwable)e);
            }
            updatedSomething = true;
        }
        if (createCanvasGroupsFolder) {
            try {
                File groupsFolder = this.googleCourseToolsService.createCanvasGroupsFolder(courseId, courseTitle, allGroupEmail, teacherGroupEmail);
                courseInit.setGroupsFolderId(groupsFolder.getId());
                notificationData.setGroupsFolder(groupsFolder.getName());
            }
            catch (IOException e) {
                String groupsFolderError = "Issue with creating the groups file folder";
                errors.add(groupsFolderError);
                log.error(groupsFolderError, (Throwable)e);
            }
            updatedSomething = true;
        }
        if (createDropboxFolder) {
            try {
                File dropboxFolder = this.googleCourseToolsService.createDropboxFolder(courseId, courseTitle);
                String dropboxFolderId = dropboxFolder.getId();
                courseInit.setDropboxFolderId(dropboxFolderId);
                notificationData.setDropboxFilesFolder(dropboxFolder.getName());
                DropboxMessage dm = DropboxMessage.builder().courseId(courseId).courseTitle(courseTitle).dropboxFolderId(dropboxFolderId).allGroupEmail(allGroupEmail).teacherGroupEmail(teacherGroupEmail).build();
                this.dropboxMessageSender.send(dm);
            }
            catch (IOException e) {
                String dropboxFolderError = "Issue with creating the dropbox file folder";
                errors.add(dropboxFolderError);
                log.error(dropboxFolderError, (Throwable)e);
            }
            updatedSomething = true;
        }
        if (createFileRepositoryFolder) {
            try {
                File fileRepositoryFolder = this.googleCourseToolsService.createFileRepositoryFolder(courseId, courseTitle, allGroupEmail);
                courseInit.setFileRepoId(fileRepositoryFolder.getId());
                notificationData.setFileRepositoryFolder(fileRepositoryFolder.getName());
            }
            catch (IOException e) {
                String fileRepoError = "Issue with creating the file repository folder";
                errors.add(fileRepoError);
                log.error(fileRepoError, (Throwable)e);
            }
            updatedSomething = true;
        }
        if (createMailingList) {
            boolean success = false;
            String groupForMxRecord = this.googleCourseToolsService.stripEmailDomain(allGroupEmail);
            MxRecord newMxRecord = this.mxRecordService.createMxRecord(groupForMxRecord);
            if (newMxRecord != null && "success".equals(newMxRecord.getResult())) {
                try {
                    this.googleCourseToolsService.updateGroupMailingListSettings(allGroupEmail);
                    courseInit.setMailingListAddress(allGroupEmail);
                    notificationData.setMailingListAddress(allGroupEmail);
                    notificationData.setMailingListName(allGroupName);
                    updatedSomething = true;
                    success = true;
                }
                catch (IOException e) {
                    log.error("Unable to update the group's (" + allGroupEmail + ") mailing list settings", (Throwable)e);
                }
            }
            if (!success) {
                String mailingListError = "Issue with enabling the course mailing list";
                errors.add(mailingListError);
            }
        }
        if (courseInit.isTaTeacher() != taAccess || courseInit.isDeTeacher() != designerAccess) {
            courseInit.setTaTeacher(taAccess);
            courseInit.setDeTeacher(designerAccess);
            updatedSomething = true;
        }
        if (updatedSomething) {
            try {
                this.googleCourseToolsService.saveCourseInit(courseInit);
            }
            catch (Exception e) {
                String saveCourseInitError = "There was an error saving the data";
                errors.add(saveCourseInitError);
                log.error(saveCourseInitError, (Throwable)e);
            }
            if (sendNotification) {
                this.googleCourseToolsService.sendCourseSetupNotification(courseInit, notificationData);
            }
        }
        if (errors.isEmpty()) {
            if (updatedSomething) {
                model.addAttribute("setupSuccess", (Object)"The changes submitted in the setup page were successful!");
            }
        } else {
            model.addAttribute("setupErrors", errors);
        }
        return this.index(courseId, model, request);
    }

    @RequestMapping(value={"/setupSubmit/{courseId}", "/share/perms/{courseId}", "/share/perms/{courseId}/submit"}, params={"action=setupCancel"})
    @Secured(value={"ROLE_USER"})
    public ModelAndView setupCancel(@PathVariable(value="courseId") String courseId, Model model, HttpServletRequest request) {
        log.debug("in /setupCancel");
        return this.index(courseId, model, request);
    }

    @RequestMapping(value={"/info/{courseId}"})
    @Secured(value={"ROLE_USER"})
    public ModelAndView info(@PathVariable(value="courseId") String courseId, Model model, HttpServletRequest request) {
        boolean isInstructor = request.isUserInRole("ROLE_LTI_INSTRUCTOR");
        model.addAttribute("courseId", (Object)courseId);
        CourseInit courseInit = this.googleCourseToolsService.getCourseInit(courseId);
        String courseTitle = (String)this.courseSessionService.getAttributeFromSession(request.getSession(), courseId, "course_title", String.class);
        CourseInfo courseInfo = new CourseInfo();
        ArrayList<String> optionalCourseFolders = new ArrayList<String>();
        try {
            File folder;
            CourseGroupWrapper groupsForCourse = this.getGroupsForCourse(courseId, request, true, courseTitle, courseInit);
            SerializableGroup allGroup = groupsForCourse.getAllGroup();
            String allGroupUrl = this.googleCourseToolsService.buildGroupUrlFromEmail(allGroup.getEmail(), true);
            courseInfo.setAllGroupDetails(new CourseInfo.GroupDetails(allGroup, this.googleCourseToolsService.authWrapUrl(allGroupUrl)));
            SerializableGroup teacherGroup = groupsForCourse.getTeacherGroup();
            String teacherGroupUrl = this.googleCourseToolsService.buildGroupUrlFromEmail(teacherGroup.getEmail(), true);
            courseInfo.setTeacherGroupDetails(new CourseInfo.GroupDetails(teacherGroup, this.googleCourseToolsService.authWrapUrl(teacherGroupUrl)));
            List canvasCourseGroups = this.googleCourseToolsService.getCanvasGroupsForCourse(courseId);
            List canvasGroupEmails = canvasCourseGroups.stream().map(arg_0 -> ((GoogleCourseToolsService)this.googleCourseToolsService).getEmailForCourseGroup(arg_0)).map(String::toLowerCase).collect(Collectors.toList());
            for (SerializableGroup group : groupsForCourse.getCanvasGroups()) {
                String groupUrl = this.googleCourseToolsService.buildGroupUrlFromEmail(group.getEmail(), true);
                boolean existsInCanvas = canvasGroupEmails.contains(group.getEmail().toLowerCase());
                if (!existsInCanvas) continue;
                courseInfo.addCanvasCourseGroup((CourseInfo.GroupDetails)new CourseInfo.CanvasGroupDetails(group, this.googleCourseToolsService.authWrapUrl(groupUrl), existsInCanvas));
            }
            courseInfo.getCanvasCourseGroups().sort(Comparator.comparing(CourseInfo.GroupDetails::getName));
            File courseFolder = this.googleCourseToolsService.getFolder(courseInit.getCourseFolderId());
            courseInfo.setRootCourseFolder(courseFolder.getName());
            if (courseInit.getCoursefilesFolderId() != null) {
                folder = this.googleCourseToolsService.getFolder(courseInit.getCoursefilesFolderId());
                optionalCourseFolders.add(folder.getName());
            }
            if (courseInit.getInstructorFolderId() != null) {
                folder = this.googleCourseToolsService.getFolder(courseInit.getInstructorFolderId());
                optionalCourseFolders.add(folder.getName());
            }
            if (courseInit.getGroupsFolderId() != null) {
                folder = this.googleCourseToolsService.getFolder(courseInit.getGroupsFolderId());
                optionalCourseFolders.add(folder.getName());
            }
            if (courseInit.getDropboxFolderId() != null) {
                folder = this.googleCourseToolsService.getFolder(courseInit.getDropboxFolderId());
                optionalCourseFolders.add(folder.getName());
            }
            if (courseInit.getFileRepoId() != null) {
                folder = this.googleCourseToolsService.getFolder(courseInit.getFileRepoId());
                optionalCourseFolders.add(folder.getName());
            }
        }
        catch (IOException e) {
            log.error("Unable to get information for course");
        }
        ArrayList<String> teacherRoles = new ArrayList<String>();
        teacherRoles.add("Teachers");
        if (courseInit.isTaTeacher()) {
            teacherRoles.add("TAs");
        }
        if (courseInit.isDeTeacher()) {
            teacherRoles.add("Designers");
        }
        courseInfo.setTeacherRoles(teacherRoles);
        courseInfo.setInstructor(isInstructor);
        courseInfo.setMailingListEnabled(courseInit.getMailingListAddress() != null);
        courseInfo.setOptionalCourseFolders(optionalCourseFolders);
        model.addAttribute("courseInfo", (Object)courseInfo);
        return new ModelAndView("info");
    }

    @RequestMapping(value={"/share/{courseId}"})
    @Secured(value={"ROLE_USER"})
    public ModelAndView share(@PathVariable(value="courseId") String courseId, Model model, HttpServletRequest request) {
        boolean isDeTeacher;
        log.debug("in /share");
        OidcAuthenticationToken token = this.getValidatedToken(courseId);
        OidcTokenUtils oidcTokenUtils = new OidcTokenUtils(token);
        TokenInfo pickerTokenInfo = this.googleCourseToolsService.getPickerTokenInfo();
        model.addAttribute("pickerTokenInfo", (Object)pickerTokenInfo);
        boolean isInstructor = request.isUserInRole("ROLE_LTI_INSTRUCTOR");
        boolean isTa = request.isUserInRole("ROLE_LTI_TA");
        boolean isDesigner = request.isUserInRole("ROLE_LTI_DESIGNER");
        boolean isStudent = request.isUserInRole("ROLE_LTI_STUDENT");
        model.addAttribute("courseId", (Object)courseId);
        CourseInit courseInit = this.googleCourseToolsService.getCourseInit(courseId);
        ArrayList<Constants.FOLDER_TYPES> availableFolders = new ArrayList<Constants.FOLDER_TYPES>();
        boolean isTaTeacher = isTa && courseInit.isTaTeacher();
        boolean bl = isDeTeacher = isDesigner && courseInit.isDeTeacher();
        if (courseInit.getCoursefilesFolderId() != null && (isInstructor || isTaTeacher || isDeTeacher)) {
            availableFolders.add(Constants.FOLDER_TYPES.courseFiles);
        }
        if (courseInit.getInstructorFolderId() != null && (isInstructor || isTaTeacher || isDeTeacher)) {
            availableFolders.add(Constants.FOLDER_TYPES.instructorFiles);
        }
        if (courseInit.getDropboxFolderId() != null && isStudent) {
            availableFolders.add(Constants.FOLDER_TYPES.mydropBox);
        }
        if (courseInit.getFileRepoId() != null) {
            availableFolders.add(Constants.FOLDER_TYPES.fileRepository);
        }
        model.addAttribute("availableFolders", availableFolders);
        ArrayList<File> availableGroupFolders = new ArrayList<File>();
        if (courseInit.getGroupsFolderId() != null && isStudent) {
            String loginId = oidcTokenUtils.getUserLoginId();
            try {
                String courseTitle = (String)this.courseSessionService.getAttributeFromSession(request.getSession(), courseId, "course_title", String.class);
                CourseGroupWrapper groupsForCourse = this.getGroupsForCourse(courseId, request, true, courseTitle, courseInit);
                Map allCourseGroups = this.googleCourseToolsService.getFolderIdByCourseGroup(courseId);
                log.debug("GroupInits: {}", (Object)allCourseGroups);
                List canvasGroups = groupsForCourse.getCanvasGroups();
                for (SerializableGroup group : canvasGroups) {
                    if (!this.googleCourseToolsService.isUserInGroup(group.getEmail(), loginId)) continue;
                    log.debug("Checking for group {}", (Object)group.getEmail());
                    String folderId = (String)allCourseGroups.get(group.getEmail());
                    if (folderId == null) continue;
                    availableGroupFolders.add(this.googleCourseToolsService.getFolder(folderId));
                }
                model.addAttribute("availableGroupFolders", availableGroupFolders);
            }
            catch (IOException e) {
                log.warn("Unable to get course groups", (Throwable)e);
            }
        }
        return new ModelAndView("share");
    }

    @RequestMapping(value={"/share/perms/{courseId}"})
    @Secured(value={"ROLE_USER"})
    public ModelAndView perms(@PathVariable(value="courseId") String courseId, @RequestParam(value="fileIds[]") String[] fileIds, @RequestParam(value="destFolder") String destFolder, Model model, HttpServletRequest request) {
        log.debug("in /share/perms");
        OidcAuthenticationToken token = this.getValidatedToken(courseId);
        OidcTokenUtils oidcTokenUtils = new OidcTokenUtils(token);
        boolean showAll = false;
        boolean isCourseGroupFolder = Stream.of(Constants.FOLDER_TYPES.values()).noneMatch(t -> t.name().equals(destFolder));
        String emailForCourseGroup = "GARBAGE_PLACEHOLDER";
        try {
            Constants.FOLDER_TYPES destFolderType;
            String defaultPerm;
            String loginId = oidcTokenUtils.getUserLoginId();
            List allFiles = this.googleCourseToolsService.getFiles(fileIds, loginId);
            String courseTitle = (String)this.courseSessionService.getAttributeFromSession(request.getSession(), courseId, "course_title", String.class);
            CourseInit courseInit = this.googleCourseToolsService.getCourseInit(courseId);
            CourseGroupWrapper groupsForCourse = this.getGroupsForCourse(courseId, request, false, courseTitle, courseInit);
            String string = defaultPerm = Constants.FOLDER_TYPES.mydropBox.name().equals(destFolder) || isCourseGroupFolder ? Constants.PERMISSION_ROLES.commenter.name() : Constants.PERMISSION_ROLES.reader.name();
            if (!isCourseGroupFolder) {
                destFolderType = Constants.FOLDER_TYPES.valueOf((String)destFolder);
            } else {
                destFolderType = Constants.FOLDER_TYPES.canvasCourseGroup;
                destFolderType.setFolderId(destFolder);
                destFolderType.setText(this.googleCourseToolsService.getFolder(destFolder).getName());
                GroupsInit groupsInit = this.googleCourseToolsService.getGroupsInit(courseId, destFolder);
                emailForCourseGroup = this.googleCourseToolsService.getEmailForCourseGroup(groupsInit.getCanvasCourseId(), groupsInit.getCanvasGroupId());
            }
            String finalEmailForCourseGroup = emailForCourseGroup;
            List sharedFilePermissions = allFiles.stream().map(file -> new SharedFilePermission(file, GoogleCourseToolsService.getExistingRoleForGroupPerm((List)file.getPermissions(), (String)groupsForCourse.getAllGroup().getEmail(), (String)defaultPerm), GoogleCourseToolsService.getExistingRoleForGroupPerm((List)file.getPermissions(), (String)groupsForCourse.getTeacherGroup().getEmail(), (String)defaultPerm), GoogleCourseToolsService.getExistingRoleForGroupPerm((List)file.getPermissions(), (String)finalEmailForCourseGroup, (String)defaultPerm))).sorted(Comparator.comparing(SharedFilePermission::isFolder).reversed().thenComparing(sharedFilePermission -> sharedFilePermission.getFile().getName())).collect(Collectors.toList());
            model.addAttribute("sharedFilePermissionModel", (Object)new SharedFilePermissionModel(sharedFilePermissions, destFolderType));
        }
        catch (IOException e) {
            log.error("unable to parse json into object", (Throwable)e);
        }
        if (Constants.FOLDER_TYPES.courseFiles.name().equals(destFolder) || Constants.FOLDER_TYPES.fileRepository.name().equals(destFolder)) {
            showAll = true;
        }
        model.addAttribute("showAll", (Object)showAll);
        model.addAttribute("showCourseGroups", (Object)isCourseGroupFolder);
        return new ModelAndView("share_perms");
    }

    @PostMapping(value={"/share/perms/{courseId}/submit"})
    @Secured(value={"ROLE_USER"})
    public ModelAndView permsSubmit(@PathVariable(value="courseId") String courseId, Model model, HttpServletRequest request, @ModelAttribute SharedFilePermissionModel sharedFilePermissionModel) {
        OidcAuthenticationToken token = this.getValidatedToken(courseId);
        OidcTokenUtils oidcTokenUtils = new OidcTokenUtils(token);
        String loginId = oidcTokenUtils.getUserLoginId();
        log.debug("{}", (Object)sharedFilePermissionModel);
        ArrayList<Object> errors = new ArrayList<Object>();
        CourseInit courseInit = this.googleCourseToolsService.getCourseInit(courseId);
        DropboxInit dropboxInit = this.googleCourseToolsService.getDropboxInit(courseId, loginId);
        String destFolderId = this.getSelectedFolderId(sharedFilePermissionModel.getDestFolderType(), courseInit, dropboxInit);
        boolean isCourseGroupFolder = Constants.FOLDER_TYPES.canvasCourseGroup.name().equals(sharedFilePermissionModel.getDestFolderType().name());
        String emailForCourseGroup = null;
        log.debug("FolderId: {}; isCourseGroupFolder: {}", (Object)destFolderId, (Object)isCourseGroupFolder);
        if (isCourseGroupFolder) {
            GroupsInit groupsInit = this.googleCourseToolsService.getGroupsInit(courseId, destFolderId);
            log.debug("{}", (Object)groupsInit);
            emailForCourseGroup = this.googleCourseToolsService.getEmailForCourseGroup(groupsInit.getCanvasCourseId(), groupsInit.getCanvasGroupId());
        }
        log.debug("CourseGroup email: {}", emailForCourseGroup);
        try {
            String courseTitle = (String)this.courseSessionService.getAttributeFromSession(request.getSession(), courseId, "course_title", String.class);
            CourseGroupWrapper groupsForCourse = this.getGroupsForCourse(courseId, request, false, courseTitle, courseInit);
            for (SharedFilePermission sharedFilePermission : sharedFilePermissionModel.getSharedFilePermissions()) {
                try {
                    this.googleCourseToolsService.shareAndAddShortcut(sharedFilePermission.getFile().getId(), destFolderId, groupsForCourse, sharedFilePermission.getAllPerm(), sharedFilePermission.getTeacherPerm(), sharedFilePermission.getCourseGroupPerm(), loginId, emailForCourseGroup);
                }
                catch (IOException e) {
                    log.error("error with setting permissions", (Throwable)e);
                    errors.add("There were problems when sharing " + sharedFilePermission.getFile().getName());
                }
            }
        }
        catch (IOException e) {
            log.error("error getting course groups", (Throwable)e);
            errors.add("Error getting group info from Google. Bailing on permissions changes.");
        }
        if (errors.isEmpty()) {
            model.addAttribute("setupSuccess", (Object)"The changes submitted in the permissions page were successful!");
        } else {
            model.addAttribute("setupErrors", errors);
        }
        return this.index(courseId, model, request);
    }

    @RequestMapping(value={"/sync/{courseId}"})
    @Secured(value={"ROLE_LTI_INSTRUCTOR"})
    public ModelAndView rosterSync(@PathVariable(value="courseId") String courseId, Model model, HttpServletRequest request) {
        try {
            String courseTitle = (String)this.courseSessionService.getAttributeFromSession(request.getSession(), courseId, "course_title", String.class);
            CourseInit courseInit = this.googleCourseToolsService.getCourseInit(courseId);
            CourseGroupWrapper groups = this.getGroupsForCourse(courseId, request, false, courseTitle, courseInit);
            String allGroupEmail = groups.getAllGroup().getEmail();
            String teacherGroupEmail = groups.getTeacherGroup().getEmail();
            RosterSyncMessage rsm = RosterSyncMessage.builder().courseData(new RosterSyncCourseData(courseId, courseTitle, allGroupEmail, teacherGroupEmail)).sendNotificationForCourse(true).build();
            this.rosterSyncMessageSender.send(rsm);
            model.addAttribute("setupSuccess", (Object)"The roster syncing process may take a few minutes.  You will receive a Canvas notification when it is complete.");
        }
        catch (IOException e) {
            log.error("unable to get course groups", (Throwable)e);
            List<String> errors = Collections.singletonList("Unable to get course groups - roster sync has failed");
            model.addAttribute("setupErrors", errors);
        }
        return this.index(courseId, model, request);
    }

    private CourseGroupWrapper getGroupsForCourse(String courseId, HttpServletRequest request, boolean forceRefresh, String courseTitle, CourseInit courseInit) throws IOException {
        HttpSession session = request.getSession();
        CourseGroupWrapper courseGroups = (CourseGroupWrapper)this.courseSessionService.getAttributeFromSession(session, courseId, "course_groups_key", CourseGroupWrapper.class);
        if ((courseGroups == null || forceRefresh || !courseGroups.hasRequiredGroups()) && (courseGroups = this.googleCourseToolsService.getOrCreateGroupsForCourse(courseId, courseTitle, courseInit)) != null && courseGroups.hasRequiredGroups()) {
            this.courseSessionService.addAttributeToSession(session, courseId, "course_groups_key", (Object)courseGroups);
        }
        return courseGroups;
    }

    private String getSelectedFolderId(Constants.FOLDER_TYPES folderType, CourseInit courseInit, DropboxInit dropboxInit) {
        String folderId = folderType.getFolderId();
        switch (1.$SwitchMap$edu$iu$uits$lms$gct$Constants$FOLDER_TYPES[folderType.ordinal()]) {
            case 1: {
                folderId = courseInit.getCoursefilesFolderId();
                break;
            }
            case 2: {
                folderId = courseInit.getInstructorFolderId();
                break;
            }
            case 3: {
                folderId = courseInit.getDropboxFolderId();
                break;
            }
            case 4: {
                folderId = courseInit.getFileRepoId();
                break;
            }
            case 5: {
                folderId = dropboxInit.getFolderId();
            }
        }
        return folderId;
    }
}

