/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.controller.rest;

import edu.iu.uits.lms.gct.controller.rest.RestCourseInit;
import edu.iu.uits.lms.gct.model.CourseInit;
import edu.iu.uits.lms.gct.repository.CourseInitRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/courseinit"})
@Tag(name="CourseInitRestController", description="Interact with the CourseInit repository with CRUD operations")
public class CourseInitRestController {
    private static final Logger log = LoggerFactory.getLogger(CourseInitRestController.class);
    @Autowired
    private CourseInitRepository courseInitRepository = null;

    @GetMapping(value={"/{id}"})
    @Operation(summary="Get a CourseInit by id")
    public CourseInit get(@PathVariable Long id) {
        return this.courseInitRepository.findById((Object)id).orElse(null);
    }

    @GetMapping(value={"/course/{env}/{courseId}"})
    @Operation(summary="Get a CourseInit by env and courseId")
    public CourseInit getByCourseId(@PathVariable String env, @PathVariable String courseId) {
        return this.courseInitRepository.findByCourseIdAndEnv(courseId, env);
    }

    @GetMapping(value={"/siscourse/{env}/{sisCourseId}"})
    @Operation(summary="Get a CourseInit by env and sisCourseId")
    public CourseInit getBySisCourseId(@PathVariable String env, @PathVariable String sisCourseId) {
        return this.courseInitRepository.findBySisCourseIdAndEnv(sisCourseId, env);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Update a CourseInit by id")
    public CourseInit update(@PathVariable Long id, @RequestBody RestCourseInit courseInit) {
        CourseInit updatedCourseInit = this.courseInitRepository.findById((Object)id).orElse(null);
        if (updatedCourseInit != null) {
            if (courseInit.getCourseId() != null) {
                updatedCourseInit.setCourseId(courseInit.getCourseId());
            }
            if (courseInit.getCoursefilesFolderId() != null) {
                updatedCourseInit.setCoursefilesFolderId(courseInit.getCoursefilesFolderId());
            }
            if (courseInit.getCourseFolderId() != null) {
                updatedCourseInit.setCourseFolderId(courseInit.getCourseFolderId());
            }
            if (courseInit.getDeTeacher() != null) {
                updatedCourseInit.setDeTeacher(courseInit.getDeTeacher().booleanValue());
            }
            if (courseInit.getDropboxFolderId() != null) {
                updatedCourseInit.setDropboxFolderId(courseInit.getDropboxFolderId());
            }
            if (courseInit.getFileRepoId() != null) {
                updatedCourseInit.setFileRepoId(courseInit.getFileRepoId());
            }
            if (courseInit.getInstructorFolderId() != null) {
                updatedCourseInit.setInstructorFolderId(courseInit.getInstructorFolderId());
            }
            if (courseInit.getGroupsFolderId() != null) {
                updatedCourseInit.setGroupsFolderId(courseInit.getGroupsFolderId());
            }
            if (courseInit.getMailingListAddress() != null) {
                updatedCourseInit.setMailingListAddress(courseInit.getMailingListAddress());
            }
            if (courseInit.getSisCourseId() != null) {
                updatedCourseInit.setSisCourseId(courseInit.getSisCourseId());
            }
            if (courseInit.getCourseCode() != null) {
                updatedCourseInit.setCourseCode(courseInit.getCourseCode());
            }
            if (courseInit.getTaTeacher() != null) {
                updatedCourseInit.setTaTeacher(courseInit.getTaTeacher().booleanValue());
            }
            if (courseInit.getEnv() != null) {
                updatedCourseInit.setEnv(courseInit.getEnv());
            }
            return (CourseInit)this.courseInitRepository.save((Object)updatedCourseInit);
        }
        return null;
    }

    @PostMapping(value={"/"})
    @Operation(summary="Create a new CourseInit")
    public CourseInit create(@RequestBody CourseInit courseInit) {
        CourseInit newCourseInit = CourseInit.builder().courseId(courseInit.getCourseId()).coursefilesFolderId(courseInit.getCoursefilesFolderId()).courseFolderId(courseInit.getCourseFolderId()).deTeacher(courseInit.isDeTeacher()).dropboxFolderId(courseInit.getDropboxFolderId()).fileRepoId(courseInit.getFileRepoId()).instructorFolderId(courseInit.getInstructorFolderId()).groupsFolderId(courseInit.getGroupsFolderId()).mailingListAddress(courseInit.getMailingListAddress()).sisCourseId(courseInit.getSisCourseId()).courseCode(courseInit.getCourseCode()).taTeacher(courseInit.isTaTeacher()).env(courseInit.getEnv()).build();
        return (CourseInit)this.courseInitRepository.save((Object)newCourseInit);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete a CourseInit by id")
    public String delete(@PathVariable Long id) {
        this.courseInitRepository.deleteById((Object)id);
        return "Delete success.";
    }
}

