/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.controller.rest;

import edu.iu.uits.lms.gct.model.DropboxInit;
import edu.iu.uits.lms.gct.repository.DropboxInitRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/dropboxinit"})
@Tag(name="DropboxInitRestController", description="Interact with the DropboxInit repository with CRUD operations")
public class DropboxInitRestController {
    private static final Logger log = LoggerFactory.getLogger(DropboxInitRestController.class);
    @Autowired
    private DropboxInitRepository dropboxInitRepository = null;

    @GetMapping(value={"/{id}"})
    @Operation(summary="Get a DropboxInit by id")
    public DropboxInit get(@PathVariable Long id) {
        return this.dropboxInitRepository.findById((Object)id).orElse(null);
    }

    @GetMapping(value={"/course/{env}/{courseId}"})
    @Operation(summary="Get a List of DropboxInits by env and courseId")
    public List<DropboxInit> getByCourseId(@PathVariable String env, @PathVariable String courseId) {
        return this.dropboxInitRepository.findByCourseIdAndEnv(courseId, env);
    }

    @GetMapping(value={"/login/{env}/{loginId}"})
    @Operation(summary="Get a List of DropboxInits by env and loginId")
    public List<DropboxInit> getByLoginId(@PathVariable String env, @PathVariable String loginId) {
        return this.dropboxInitRepository.findByLoginIdAndEnv(loginId, env);
    }

    @GetMapping(value={"/{courseId}/{env}/{loginId}"})
    @Operation(summary="Get a DropboxInit by env, courseId and loginId")
    public DropboxInit getByCourseAndLogin(@PathVariable String env, @PathVariable String courseId, @PathVariable String loginId) {
        return this.dropboxInitRepository.findByCourseIdAndLoginIdAndEnv(courseId, loginId, env);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Update a DropboxInit by id")
    public DropboxInit update(@PathVariable Long id, @RequestBody DropboxInit dropboxInit) {
        DropboxInit updatedDropboxInit = this.dropboxInitRepository.findById((Object)id).orElse(null);
        if (updatedDropboxInit != null) {
            if (dropboxInit.getCourseId() != null) {
                updatedDropboxInit.setCourseId(dropboxInit.getCourseId());
            }
            if (dropboxInit.getFolderId() != null) {
                updatedDropboxInit.setFolderId(dropboxInit.getFolderId());
            }
            if (dropboxInit.getGoogleLoginId() != null) {
                updatedDropboxInit.setGoogleLoginId(dropboxInit.getGoogleLoginId());
            }
            if (dropboxInit.getLoginId() != null) {
                updatedDropboxInit.setLoginId(dropboxInit.getLoginId());
            }
            if (dropboxInit.getEnv() != null) {
                updatedDropboxInit.setEnv(dropboxInit.getEnv());
            }
            return (DropboxInit)this.dropboxInitRepository.save((Object)updatedDropboxInit);
        }
        return null;
    }

    @PostMapping(value={"/"})
    @Operation(summary="Create a new DropboxInit")
    public DropboxInit create(@RequestBody DropboxInit dropboxInit) {
        DropboxInit newDropboxInit = DropboxInit.builder().courseId(dropboxInit.getCourseId()).folderId(dropboxInit.getFolderId()).googleLoginId(dropboxInit.getGoogleLoginId()).loginId(dropboxInit.getLoginId()).env(dropboxInit.getEnv()).build();
        return (DropboxInit)this.dropboxInitRepository.save((Object)newDropboxInit);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete a DropboxInit by id")
    public String delete(@PathVariable Long id) {
        this.dropboxInitRepository.deleteById((Object)id);
        return "Delete success.";
    }
}

