/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.controller.rest;

import edu.iu.uits.lms.gct.model.GroupsInit;
import edu.iu.uits.lms.gct.repository.GroupsInitRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/groupsinit"})
@Tag(name="GroupsInitRestController", description="Interact with the GroupsInit repository with CRUD operations")
public class GroupsInitRestController {
    private static final Logger log = LoggerFactory.getLogger(GroupsInitRestController.class);
    @Autowired
    private GroupsInitRepository groupsInitRepository = null;

    @GetMapping(value={"/{id}"})
    @Operation(summary="Get a GroupsInit by id")
    public GroupsInit get(@PathVariable Long id) {
        return this.groupsInitRepository.findById((Object)id).orElse(null);
    }

    @GetMapping(value={"/course/{env}/{courseId}/{groupId}"})
    @Operation(summary="Get a GroupsInit by env, courseId, and groupId")
    public GroupsInit getByCourseIdGroupId(@PathVariable String env, @PathVariable String courseId, @PathVariable String groupId) {
        return this.groupsInitRepository.findByCanvasCourseIdAndCanvasGroupIdAndEnv(courseId, groupId, env);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Update a GroupsInit by id")
    public GroupsInit update(@PathVariable Long id, @RequestBody GroupsInit groupsInit) {
        GroupsInit updatedGroupsInit = this.groupsInitRepository.findById((Object)id).orElse(null);
        if (updatedGroupsInit != null) {
            if (groupsInit.getCanvasCourseId() != null) {
                updatedGroupsInit.setCanvasCourseId(groupsInit.getCanvasCourseId());
            }
            if (groupsInit.getCanvasGroupId() != null) {
                updatedGroupsInit.setCanvasGroupId(groupsInit.getCanvasGroupId());
            }
            if (groupsInit.getFolderId() != null) {
                updatedGroupsInit.setFolderId(groupsInit.getFolderId());
            }
            if (groupsInit.getEnv() != null) {
                updatedGroupsInit.setEnv(groupsInit.getEnv());
            }
            return (GroupsInit)this.groupsInitRepository.save((Object)updatedGroupsInit);
        }
        return null;
    }

    @PostMapping(value={"/"})
    @Operation(summary="Create a new GroupsInit")
    public GroupsInit create(@RequestBody GroupsInit groupsInit) {
        GroupsInit newGroupsInit = GroupsInit.builder().canvasCourseId(groupsInit.getCanvasCourseId()).canvasGroupId(groupsInit.getCanvasGroupId()).folderId(groupsInit.getFolderId()).env(groupsInit.getEnv()).build();
        return (GroupsInit)this.groupsInitRepository.save((Object)newGroupsInit);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete a GroupsInit by id")
    public String delete(@PathVariable Long id) {
        this.groupsInitRepository.deleteById((Object)id);
        return "Delete success.";
    }
}

