/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.controller.rest;

import edu.iu.uits.lms.gct.amqp.DropboxMessage;
import edu.iu.uits.lms.gct.amqp.DropboxMessageSender;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/queue"})
@Tag(name="MessageQueue", description="Send a message into the queue")
public class MessageQueue {
    private static final Logger log = LoggerFactory.getLogger(MessageQueue.class);
    @Autowired
    private DropboxMessageSender dropboxMessageSender;

    @PostMapping(value={"/dropbox"})
    @Operation(summary="Send a DropboxMessage into the queue")
    public ResponseEntity<String> sendMessage(@RequestBody DropboxMessage dropboxMessage) {
        this.dropboxMessageSender.send(dropboxMessage);
        return ResponseEntity.ok((Object)"Message sent to queue");
    }
}

