/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.controller.rest;

import edu.iu.uits.lms.gct.model.GctProperty;
import edu.iu.uits.lms.gct.repository.GctPropertyRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/properties"})
@Tag(name="PropertiesRestController", description="Interact with the GctProperty repository with CRUD operations")
public class PropertiesRestController {
    private static final Logger log = LoggerFactory.getLogger(PropertiesRestController.class);
    @Autowired
    private GctPropertyRepository gctPropertyRepository = null;

    @GetMapping(value={"/all"})
    @Operation(summary="Get all GctProperty objects")
    public Iterable<GctProperty> getAll() {
        return this.gctPropertyRepository.findAll();
    }

    @GetMapping(value={"/{env}/{key}"})
    @Operation(summary="Get a GctProperty by env and key")
    public GctProperty getProperty(@PathVariable String env, @PathVariable String key) {
        return this.gctPropertyRepository.findByKeyAndEnv(key, env);
    }

    @PutMapping(value={"/{env}/{key}"})
    @Operation(summary="Update a GctProperty by env and key")
    public GctProperty updateProperty(@PathVariable String env, @PathVariable String key, @RequestBody GctProperty gctProperty) {
        GctProperty prop = this.gctPropertyRepository.findByKeyAndEnv(key, env);
        if (gctProperty.getValue() != null) {
            prop.setValue(gctProperty.getValue());
        }
        if (gctProperty.getEnv() != null) {
            prop.setEnv(gctProperty.getEnv());
        }
        return (GctProperty)this.gctPropertyRepository.save((Object)prop);
    }

    @PostMapping(value={"/"})
    @Operation(summary="Create a new GctProperty")
    public GctProperty createProperty(@RequestBody GctProperty gctProperty) {
        GctProperty newProp = new GctProperty(gctProperty.getKey(), gctProperty.getValue(), gctProperty.getEnv());
        return (GctProperty)this.gctPropertyRepository.save((Object)newProp);
    }

    @DeleteMapping(value={"/{env}/{key}"})
    @Operation(summary="Delete a GctProperty by env and key")
    public String deleteProperty(@PathVariable String env, @PathVariable String key) {
        GctProperty prop = this.gctPropertyRepository.findByKeyAndEnv(key, env);
        this.gctPropertyRepository.delete((Object)prop);
        return "Delete success.";
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete a GctProperty by id")
    public String deletePropertyById(@PathVariable Long id) {
        this.gctPropertyRepository.deleteById((Object)id);
        return "Delete success.";
    }
}

