/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.controller.rest;

import edu.iu.uits.lms.gct.model.UserInit;
import edu.iu.uits.lms.gct.repository.UserInitRepository;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/userinit"})
@Tag(name="UserInitRestController", description="Interact with the UserInit repository with CRUD operations")
public class UserInitRestController {
    private static final Logger log = LoggerFactory.getLogger(UserInitRestController.class);
    @Autowired
    private UserInitRepository userInitRepository = null;

    @GetMapping(value={"/{id}"})
    @Operation(summary="Get a UserInit by id")
    public UserInit get(@PathVariable Long id) {
        return this.userInitRepository.findById((Object)id).orElse(null);
    }

    @GetMapping(value={"/login/{env}/{loginId}"})
    @Operation(summary="Get a UserInit by env and loginId")
    public UserInit getByLoginId(@PathVariable String env, @PathVariable String loginId) {
        return this.userInitRepository.findByLoginIdAndEnv(loginId, env);
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Update a UserInit by id")
    public UserInit update(@PathVariable Long id, @RequestBody UserInit userInit) {
        UserInit updatedUserInit = this.userInitRepository.findById((Object)id).orElse(null);
        if (updatedUserInit != null) {
            if (userInit.getFolderId() != null) {
                updatedUserInit.setFolderId(userInit.getFolderId());
            }
            if (userInit.getGoogleLoginId() != null) {
                updatedUserInit.setGoogleLoginId(userInit.getGoogleLoginId());
            }
            if (userInit.getLoginId() != null) {
                updatedUserInit.setLoginId(userInit.getLoginId());
            }
            if (userInit.getEnv() != null) {
                updatedUserInit.setEnv(userInit.getEnv());
            }
            return (UserInit)this.userInitRepository.save((Object)updatedUserInit);
        }
        return null;
    }

    @PostMapping(value={"/"})
    @Operation(summary="Create a new UserInit")
    public UserInit create(@RequestBody UserInit userInit) {
        UserInit newUserInit = UserInit.builder().folderId(userInit.getFolderId()).googleLoginId(userInit.getGoogleLoginId()).loginId(userInit.getLoginId()).env(userInit.getEnv()).build();
        return (UserInit)this.userInitRepository.save((Object)newUserInit);
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete a UserInit by id")
    public String delete(@PathVariable Long id) {
        this.userInitRepository.deleteById((Object)id);
        return "Delete success.";
    }
}

