/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.job;

import edu.iu.uits.lms.common.batch.BatchJob;
import edu.iu.uits.lms.gct.services.GoogleCourseToolsService;
import edu.iu.uits.lms.iuonly.model.errorcontact.ErrorContactPostForm;
import edu.iu.uits.lms.iuonly.services.ErrorContactServiceImpl;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"rostersync"})
public class RosterSyncJob
implements BatchJob {
    private static final Logger log = LoggerFactory.getLogger(RosterSyncJob.class);
    private GoogleCourseToolsService googleCourseToolsService;
    private ConfigurableApplicationContext ctx;
    @Autowired
    private ErrorContactServiceImpl errorContactService;

    public RosterSyncJob(GoogleCourseToolsService googleCourseToolsService, ConfigurableApplicationContext ctx) {
        this.googleCourseToolsService = googleCourseToolsService;
        this.ctx = ctx;
    }

    private void rosterSync() throws IOException {
        log.info("RosterSync job running!");
        this.googleCourseToolsService.rosterSyncBatch();
    }

    public void run() {
        try {
            this.rosterSync();
        }
        catch (Exception e) {
            log.error("Caught exception performing roster sync", (Throwable)e);
            ErrorContactPostForm errorContactPostForm = new ErrorContactPostForm();
            errorContactPostForm.setJobCode(this.getJobCode());
            errorContactPostForm.setMessage("The Roster Synchronization job has unexpectedly failed");
            this.errorContactService.postEvent(errorContactPostForm);
        }
        this.ctx.close();
    }

    public String getJobCode() {
        return "RosterSyncJob";
    }
}

