/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.mailinglist;

import edu.iu.uits.lms.gct.mailinglist.MxRecord;
import edu.iu.uits.lms.gct.mailinglist.MxServicesConfig;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class MxRecordService {
    private static final Logger log = LoggerFactory.getLogger(MxRecordService.class);
    @Autowired
    @Qualifier(value="mxRestTemplate")
    private RestTemplate mxRestTemplate;
    @Autowired
    private MxServicesConfig config;

    public MxRecord getMxRecord(String username) {
        MxRecord result = null;
        UriTemplate template = new UriTemplate("{url}/GetIuGroupInfo");
        URI baseUri = template.expand(new Object[]{this.config.getBaseUrl()});
        URI uri = UriComponentsBuilder.fromUri((URI)baseUri).queryParam("groupUsername", new Object[]{username}).build().toUri();
        log.debug("{}", (Object)uri);
        try {
            ResponseEntity responseEntity = this.mxRestTemplate.getForEntity(uri, MxRecord.class);
            log.debug("{}", (Object)responseEntity);
            result = (MxRecord)responseEntity.getBody();
        }
        catch (RestClientException e) {
            log.warn("Unable to lookup mx record for " + username, (Throwable)e);
        }
        return result;
    }

    public MxRecord createMxRecord(String username) {
        MxRecord result = null;
        UriTemplate template = new UriTemplate("{url}/CreateIuGroupEmail");
        URI baseUri = template.expand(new Object[]{this.config.getBaseUrl()});
        URI uri = UriComponentsBuilder.fromUri((URI)baseUri).queryParam("groupUsername", new Object[]{username}).build().toUri();
        log.debug("{}", (Object)uri);
        try {
            ResponseEntity responseEntity = this.mxRestTemplate.postForEntity(uri, null, MxRecord.class);
            log.debug("{}", (Object)responseEntity);
            result = (MxRecord)responseEntity.getBody();
        }
        catch (Exception e) {
            log.warn("Unable to create mx record for " + username, (Throwable)e);
        }
        return result;
    }
}

