/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import edu.iu.uits.lms.gct.model.CourseInit;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="GCT_COURSE_INIT", uniqueConstraints={@UniqueConstraint(name="UK_GCT_COURSE_INIT", columnNames={"course_id", "env"})})
@SequenceGenerator(name="GCT_COURSE_INIT_ID_SEQ", sequenceName="GCT_COURSE_INIT_ID_SEQ", allocationSize=1)
public class CourseInit {
    @Id
    @GeneratedValue(generator="GCT_COURSE_INIT_ID_SEQ")
    private Long id;
    @Column(name="COURSE_ID")
    private String courseId;
    @Column(name="SIS_COURSE_ID")
    private String sisCourseId;
    @Column(name="COURSE_CODE")
    private String courseCode;
    @Column(name="TA_TEACHER")
    private boolean taTeacher;
    @Column(name="DE_TEACHER")
    private boolean deTeacher;
    @Column(name="COURSE_FOLDER_ID")
    private String courseFolderId;
    @Column(name="COURSEFILES_FOLDER_ID")
    private String coursefilesFolderId;
    @Column(name="INSTRUCTOR_FOLDER_ID")
    private String instructorFolderId;
    @Column(name="DROPBOX_FOLDER_ID")
    private String dropboxFolderId;
    @Column(name="FILE_REPO_ID")
    private String fileRepoId;
    @Column(name="GROUPS_FOLDER_ID")
    private String groupsFolderId;
    @Column(name="MAILING_LIST_ADDRESS")
    private String mailingListAddress;
    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    @Column(name="CREATED")
    private Date createdOn;
    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    @Column(name="MODIFIED")
    private Date modifiedOn;
    @Column(name="ENV", length=5)
    private String env;
    @Enumerated(value=EnumType.STRING)
    @Column(name="SYNC_STATUS")
    private SYNC_STATUS syncStatus = SYNC_STATUS.ACTIVE;

    @PreUpdate
    @PrePersist
    public void updateTimeStamps() {
        this.modifiedOn = new Date();
        if (this.createdOn == null) {
            this.createdOn = new Date();
        }
    }

    public static CourseInitBuilder builder() {
        return new CourseInitBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getCourseId() {
        return this.courseId;
    }

    public String getSisCourseId() {
        return this.sisCourseId;
    }

    public String getCourseCode() {
        return this.courseCode;
    }

    public boolean isTaTeacher() {
        return this.taTeacher;
    }

    public boolean isDeTeacher() {
        return this.deTeacher;
    }

    public String getCourseFolderId() {
        return this.courseFolderId;
    }

    public String getCoursefilesFolderId() {
        return this.coursefilesFolderId;
    }

    public String getInstructorFolderId() {
        return this.instructorFolderId;
    }

    public String getDropboxFolderId() {
        return this.dropboxFolderId;
    }

    public String getFileRepoId() {
        return this.fileRepoId;
    }

    public String getGroupsFolderId() {
        return this.groupsFolderId;
    }

    public String getMailingListAddress() {
        return this.mailingListAddress;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public String getEnv() {
        return this.env;
    }

    public SYNC_STATUS getSyncStatus() {
        return this.syncStatus;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCourseId(String courseId) {
        this.courseId = courseId;
    }

    public void setSisCourseId(String sisCourseId) {
        this.sisCourseId = sisCourseId;
    }

    public void setCourseCode(String courseCode) {
        this.courseCode = courseCode;
    }

    public void setTaTeacher(boolean taTeacher) {
        this.taTeacher = taTeacher;
    }

    public void setDeTeacher(boolean deTeacher) {
        this.deTeacher = deTeacher;
    }

    public void setCourseFolderId(String courseFolderId) {
        this.courseFolderId = courseFolderId;
    }

    public void setCoursefilesFolderId(String coursefilesFolderId) {
        this.coursefilesFolderId = coursefilesFolderId;
    }

    public void setInstructorFolderId(String instructorFolderId) {
        this.instructorFolderId = instructorFolderId;
    }

    public void setDropboxFolderId(String dropboxFolderId) {
        this.dropboxFolderId = dropboxFolderId;
    }

    public void setFileRepoId(String fileRepoId) {
        this.fileRepoId = fileRepoId;
    }

    public void setGroupsFolderId(String groupsFolderId) {
        this.groupsFolderId = groupsFolderId;
    }

    public void setMailingListAddress(String mailingListAddress) {
        this.mailingListAddress = mailingListAddress;
    }

    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setSyncStatus(SYNC_STATUS syncStatus) {
        this.syncStatus = syncStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CourseInit)) {
            return false;
        }
        CourseInit other = (CourseInit)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isTaTeacher() != other.isTaTeacher()) {
            return false;
        }
        if (this.isDeTeacher() != other.isDeTeacher()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$courseId = this.getCourseId();
        String other$courseId = other.getCourseId();
        if (this$courseId == null ? other$courseId != null : !this$courseId.equals(other$courseId)) {
            return false;
        }
        String this$sisCourseId = this.getSisCourseId();
        String other$sisCourseId = other.getSisCourseId();
        if (this$sisCourseId == null ? other$sisCourseId != null : !this$sisCourseId.equals(other$sisCourseId)) {
            return false;
        }
        String this$courseCode = this.getCourseCode();
        String other$courseCode = other.getCourseCode();
        if (this$courseCode == null ? other$courseCode != null : !this$courseCode.equals(other$courseCode)) {
            return false;
        }
        String this$courseFolderId = this.getCourseFolderId();
        String other$courseFolderId = other.getCourseFolderId();
        if (this$courseFolderId == null ? other$courseFolderId != null : !this$courseFolderId.equals(other$courseFolderId)) {
            return false;
        }
        String this$coursefilesFolderId = this.getCoursefilesFolderId();
        String other$coursefilesFolderId = other.getCoursefilesFolderId();
        if (this$coursefilesFolderId == null ? other$coursefilesFolderId != null : !this$coursefilesFolderId.equals(other$coursefilesFolderId)) {
            return false;
        }
        String this$instructorFolderId = this.getInstructorFolderId();
        String other$instructorFolderId = other.getInstructorFolderId();
        if (this$instructorFolderId == null ? other$instructorFolderId != null : !this$instructorFolderId.equals(other$instructorFolderId)) {
            return false;
        }
        String this$dropboxFolderId = this.getDropboxFolderId();
        String other$dropboxFolderId = other.getDropboxFolderId();
        if (this$dropboxFolderId == null ? other$dropboxFolderId != null : !this$dropboxFolderId.equals(other$dropboxFolderId)) {
            return false;
        }
        String this$fileRepoId = this.getFileRepoId();
        String other$fileRepoId = other.getFileRepoId();
        if (this$fileRepoId == null ? other$fileRepoId != null : !this$fileRepoId.equals(other$fileRepoId)) {
            return false;
        }
        String this$groupsFolderId = this.getGroupsFolderId();
        String other$groupsFolderId = other.getGroupsFolderId();
        if (this$groupsFolderId == null ? other$groupsFolderId != null : !this$groupsFolderId.equals(other$groupsFolderId)) {
            return false;
        }
        String this$mailingListAddress = this.getMailingListAddress();
        String other$mailingListAddress = other.getMailingListAddress();
        if (this$mailingListAddress == null ? other$mailingListAddress != null : !this$mailingListAddress.equals(other$mailingListAddress)) {
            return false;
        }
        Date this$createdOn = this.getCreatedOn();
        Date other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        Date this$modifiedOn = this.getModifiedOn();
        Date other$modifiedOn = other.getModifiedOn();
        if (this$modifiedOn == null ? other$modifiedOn != null : !((Object)this$modifiedOn).equals(other$modifiedOn)) {
            return false;
        }
        String this$env = this.getEnv();
        String other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        SYNC_STATUS this$syncStatus = this.getSyncStatus();
        SYNC_STATUS other$syncStatus = other.getSyncStatus();
        return !(this$syncStatus == null ? other$syncStatus != null : !this$syncStatus.equals(other$syncStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CourseInit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTaTeacher() ? 79 : 97);
        result = result * 59 + (this.isDeTeacher() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $courseId = this.getCourseId();
        result = result * 59 + ($courseId == null ? 43 : $courseId.hashCode());
        String $sisCourseId = this.getSisCourseId();
        result = result * 59 + ($sisCourseId == null ? 43 : $sisCourseId.hashCode());
        String $courseCode = this.getCourseCode();
        result = result * 59 + ($courseCode == null ? 43 : $courseCode.hashCode());
        String $courseFolderId = this.getCourseFolderId();
        result = result * 59 + ($courseFolderId == null ? 43 : $courseFolderId.hashCode());
        String $coursefilesFolderId = this.getCoursefilesFolderId();
        result = result * 59 + ($coursefilesFolderId == null ? 43 : $coursefilesFolderId.hashCode());
        String $instructorFolderId = this.getInstructorFolderId();
        result = result * 59 + ($instructorFolderId == null ? 43 : $instructorFolderId.hashCode());
        String $dropboxFolderId = this.getDropboxFolderId();
        result = result * 59 + ($dropboxFolderId == null ? 43 : $dropboxFolderId.hashCode());
        String $fileRepoId = this.getFileRepoId();
        result = result * 59 + ($fileRepoId == null ? 43 : $fileRepoId.hashCode());
        String $groupsFolderId = this.getGroupsFolderId();
        result = result * 59 + ($groupsFolderId == null ? 43 : $groupsFolderId.hashCode());
        String $mailingListAddress = this.getMailingListAddress();
        result = result * 59 + ($mailingListAddress == null ? 43 : $mailingListAddress.hashCode());
        Date $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
        Date $modifiedOn = this.getModifiedOn();
        result = result * 59 + ($modifiedOn == null ? 43 : ((Object)$modifiedOn).hashCode());
        String $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        SYNC_STATUS $syncStatus = this.getSyncStatus();
        result = result * 59 + ($syncStatus == null ? 43 : $syncStatus.hashCode());
        return result;
    }

    public String toString() {
        return "CourseInit(id=" + this.getId() + ", courseId=" + this.getCourseId() + ", sisCourseId=" + this.getSisCourseId() + ", courseCode=" + this.getCourseCode() + ", taTeacher=" + this.isTaTeacher() + ", deTeacher=" + this.isDeTeacher() + ", courseFolderId=" + this.getCourseFolderId() + ", coursefilesFolderId=" + this.getCoursefilesFolderId() + ", instructorFolderId=" + this.getInstructorFolderId() + ", dropboxFolderId=" + this.getDropboxFolderId() + ", fileRepoId=" + this.getFileRepoId() + ", groupsFolderId=" + this.getGroupsFolderId() + ", mailingListAddress=" + this.getMailingListAddress() + ", createdOn=" + this.getCreatedOn() + ", modifiedOn=" + this.getModifiedOn() + ", env=" + this.getEnv() + ", syncStatus=" + this.getSyncStatus() + ")";
    }

    public CourseInit(Long id, String courseId, String sisCourseId, String courseCode, boolean taTeacher, boolean deTeacher, String courseFolderId, String coursefilesFolderId, String instructorFolderId, String dropboxFolderId, String fileRepoId, String groupsFolderId, String mailingListAddress, Date createdOn, Date modifiedOn, String env, SYNC_STATUS syncStatus) {
        this.id = id;
        this.courseId = courseId;
        this.sisCourseId = sisCourseId;
        this.courseCode = courseCode;
        this.taTeacher = taTeacher;
        this.deTeacher = deTeacher;
        this.courseFolderId = courseFolderId;
        this.coursefilesFolderId = coursefilesFolderId;
        this.instructorFolderId = instructorFolderId;
        this.dropboxFolderId = dropboxFolderId;
        this.fileRepoId = fileRepoId;
        this.groupsFolderId = groupsFolderId;
        this.mailingListAddress = mailingListAddress;
        this.createdOn = createdOn;
        this.modifiedOn = modifiedOn;
        this.env = env;
        this.syncStatus = syncStatus;
    }

    public CourseInit() {
    }
}

