/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.model;

import edu.iu.uits.lms.canvas.model.User;
import edu.iu.uits.lms.gct.model.DecoratedCanvasUser;
import java.util.List;
import java.util.stream.Collectors;

public class DecoratedCanvasUser {
    private String email;
    private String loginId;
    private List<DecoratedEnrollment> enrollments;

    public DecoratedCanvasUser(User user) {
        this.email = user.getEmail();
        this.loginId = user.getLoginId();
        this.enrollments = user.getEnrollments().stream().map(DecoratedEnrollment::new).collect(Collectors.toList());
    }

    public boolean isTeacher() {
        return this.hasEnrollment("TeacherEnrollment");
    }

    public boolean isStudent() {
        return this.hasEnrollment("StudentEnrollment");
    }

    public boolean isDesigner() {
        return this.hasEnrollment("DesignerEnrollment");
    }

    public boolean isTa() {
        return this.hasEnrollment("TaEnrollment");
    }

    public boolean isObserver() {
        return this.hasEnrollment("ObserverEnrollment");
    }

    private boolean hasEnrollment(String role) {
        return this.enrollments.stream().anyMatch(e -> role.equals(e.getType()));
    }

    public String getEmail() {
        return this.email;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public List<DecoratedEnrollment> getEnrollments() {
        return this.enrollments;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public void setEnrollments(List<DecoratedEnrollment> enrollments) {
        this.enrollments = enrollments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecoratedCanvasUser)) {
            return false;
        }
        DecoratedCanvasUser other = (DecoratedCanvasUser)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$loginId = this.getLoginId();
        String other$loginId = other.getLoginId();
        if (this$loginId == null ? other$loginId != null : !this$loginId.equals(other$loginId)) {
            return false;
        }
        List this$enrollments = this.getEnrollments();
        List other$enrollments = other.getEnrollments();
        return !(this$enrollments == null ? other$enrollments != null : !((Object)this$enrollments).equals(other$enrollments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DecoratedCanvasUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $loginId = this.getLoginId();
        result = result * 59 + ($loginId == null ? 43 : $loginId.hashCode());
        List $enrollments = this.getEnrollments();
        result = result * 59 + ($enrollments == null ? 43 : ((Object)$enrollments).hashCode());
        return result;
    }

    public String toString() {
        return "DecoratedCanvasUser(email=" + this.getEmail() + ", loginId=" + this.getLoginId() + ", enrollments=" + this.getEnrollments() + ")";
    }

    public DecoratedCanvasUser(String email, String loginId, List<DecoratedEnrollment> enrollments) {
        this.email = email;
        this.loginId = loginId;
        this.enrollments = enrollments;
    }
}

