/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import edu.iu.uits.lms.gct.model.GroupsInit;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="GCT_GROUPS_INIT", uniqueConstraints={@UniqueConstraint(name="UK_GCT_GROUPS_INIT", columnNames={"canvas_course_id", "canvas_group_id", "env"})})
@SequenceGenerator(name="GCT_GROUPS_INIT_ID_SEQ", sequenceName="GCT_GROUPS_INIT_ID_SEQ", allocationSize=1)
public class GroupsInit {
    @Id
    @GeneratedValue(generator="GCT_GROUPS_INIT_ID_SEQ")
    private Long id;
    @Column(name="CANVAS_COURSE_ID")
    private String canvasCourseId;
    @Column(name="CANVAS_GROUP_ID")
    private String canvasGroupId;
    @Column(name="FOLDER_ID")
    private String folderId;
    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    @Column(name="CREATED")
    private Date createdOn;
    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    @Column(name="MODIFIED")
    private Date modifiedOn;
    @Column(name="ENV", length=5)
    private String env;

    @PreUpdate
    @PrePersist
    public void updateTimeStamps() {
        this.modifiedOn = new Date();
        if (this.createdOn == null) {
            this.createdOn = new Date();
        }
    }

    public static GroupsInitBuilder builder() {
        return new GroupsInitBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getCanvasCourseId() {
        return this.canvasCourseId;
    }

    public String getCanvasGroupId() {
        return this.canvasGroupId;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public String getEnv() {
        return this.env;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCanvasCourseId(String canvasCourseId) {
        this.canvasCourseId = canvasCourseId;
    }

    public void setCanvasGroupId(String canvasGroupId) {
        this.canvasGroupId = canvasGroupId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupsInit)) {
            return false;
        }
        GroupsInit other = (GroupsInit)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$canvasCourseId = this.getCanvasCourseId();
        String other$canvasCourseId = other.getCanvasCourseId();
        if (this$canvasCourseId == null ? other$canvasCourseId != null : !this$canvasCourseId.equals(other$canvasCourseId)) {
            return false;
        }
        String this$canvasGroupId = this.getCanvasGroupId();
        String other$canvasGroupId = other.getCanvasGroupId();
        if (this$canvasGroupId == null ? other$canvasGroupId != null : !this$canvasGroupId.equals(other$canvasGroupId)) {
            return false;
        }
        String this$folderId = this.getFolderId();
        String other$folderId = other.getFolderId();
        if (this$folderId == null ? other$folderId != null : !this$folderId.equals(other$folderId)) {
            return false;
        }
        Date this$createdOn = this.getCreatedOn();
        Date other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        Date this$modifiedOn = this.getModifiedOn();
        Date other$modifiedOn = other.getModifiedOn();
        if (this$modifiedOn == null ? other$modifiedOn != null : !((Object)this$modifiedOn).equals(other$modifiedOn)) {
            return false;
        }
        String this$env = this.getEnv();
        String other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupsInit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $canvasCourseId = this.getCanvasCourseId();
        result = result * 59 + ($canvasCourseId == null ? 43 : $canvasCourseId.hashCode());
        String $canvasGroupId = this.getCanvasGroupId();
        result = result * 59 + ($canvasGroupId == null ? 43 : $canvasGroupId.hashCode());
        String $folderId = this.getFolderId();
        result = result * 59 + ($folderId == null ? 43 : $folderId.hashCode());
        Date $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
        Date $modifiedOn = this.getModifiedOn();
        result = result * 59 + ($modifiedOn == null ? 43 : ((Object)$modifiedOn).hashCode());
        String $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "GroupsInit(id=" + this.getId() + ", canvasCourseId=" + this.getCanvasCourseId() + ", canvasGroupId=" + this.getCanvasGroupId() + ", folderId=" + this.getFolderId() + ", createdOn=" + this.getCreatedOn() + ", modifiedOn=" + this.getModifiedOn() + ", env=" + this.getEnv() + ")";
    }

    public GroupsInit(Long id, String canvasCourseId, String canvasGroupId, String folderId, Date createdOn, Date modifiedOn, String env) {
        this.id = id;
        this.canvasCourseId = canvasCourseId;
        this.canvasGroupId = canvasGroupId;
        this.folderId = folderId;
        this.createdOn = createdOn;
        this.modifiedOn = modifiedOn;
        this.env = env;
    }

    public GroupsInit() {
    }
}

