/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.model;

import com.google.api.services.drive.model.File;
import lombok.NonNull;

public class SharedFilePermission {
    @NonNull
    private File file;
    private String allPerm;
    private String teacherPerm;
    private String courseGroupPerm;

    public boolean isFolder() {
        return "application/vnd.google-apps.folder".equals(this.file.getMimeType());
    }

    public String getIconUrl32() {
        return this.file.getIconLink().replace("/16/", "/32/");
    }

    @NonNull
    public File getFile() {
        return this.file;
    }

    public String getAllPerm() {
        return this.allPerm;
    }

    public String getTeacherPerm() {
        return this.teacherPerm;
    }

    public String getCourseGroupPerm() {
        return this.courseGroupPerm;
    }

    public void setFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.file = file;
    }

    public void setAllPerm(String allPerm) {
        this.allPerm = allPerm;
    }

    public void setTeacherPerm(String teacherPerm) {
        this.teacherPerm = teacherPerm;
    }

    public void setCourseGroupPerm(String courseGroupPerm) {
        this.courseGroupPerm = courseGroupPerm;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SharedFilePermission)) {
            return false;
        }
        SharedFilePermission other = (SharedFilePermission)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$allPerm = this.getAllPerm();
        String other$allPerm = other.getAllPerm();
        if (this$allPerm == null ? other$allPerm != null : !this$allPerm.equals(other$allPerm)) {
            return false;
        }
        String this$teacherPerm = this.getTeacherPerm();
        String other$teacherPerm = other.getTeacherPerm();
        if (this$teacherPerm == null ? other$teacherPerm != null : !this$teacherPerm.equals(other$teacherPerm)) {
            return false;
        }
        String this$courseGroupPerm = this.getCourseGroupPerm();
        String other$courseGroupPerm = other.getCourseGroupPerm();
        return !(this$courseGroupPerm == null ? other$courseGroupPerm != null : !this$courseGroupPerm.equals(other$courseGroupPerm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SharedFilePermission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $allPerm = this.getAllPerm();
        result = result * 59 + ($allPerm == null ? 43 : $allPerm.hashCode());
        String $teacherPerm = this.getTeacherPerm();
        result = result * 59 + ($teacherPerm == null ? 43 : $teacherPerm.hashCode());
        String $courseGroupPerm = this.getCourseGroupPerm();
        result = result * 59 + ($courseGroupPerm == null ? 43 : $courseGroupPerm.hashCode());
        return result;
    }

    public String toString() {
        return "SharedFilePermission(file=" + this.getFile() + ", allPerm=" + this.getAllPerm() + ", teacherPerm=" + this.getTeacherPerm() + ", courseGroupPerm=" + this.getCourseGroupPerm() + ")";
    }

    public SharedFilePermission(@NonNull File file, String allPerm, String teacherPerm, String courseGroupPerm) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.file = file;
        this.allPerm = allPerm;
        this.teacherPerm = teacherPerm;
        this.courseGroupPerm = courseGroupPerm;
    }

    public SharedFilePermission() {
    }
}

