/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import edu.iu.uits.lms.gct.model.UserInit;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="GCT_USER_INIT", uniqueConstraints={@UniqueConstraint(name="UK_GCT_USER_INIT", columnNames={"env", "login_id"})})
@SequenceGenerator(name="GCT_USER_INIT_ID_SEQ", sequenceName="GCT_USER_INIT_ID_SEQ", allocationSize=1)
public class UserInit {
    @Id
    @GeneratedValue(generator="GCT_USER_INIT_ID_SEQ")
    private Long id;
    @Column(name="LOGIN_ID")
    private String loginId;
    @Column(name="GOOGLE_LOGIN_ID")
    private String googleLoginId;
    @Column(name="FOLDER_ID")
    private String folderId;
    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    @Column(name="CREATED")
    private Date createdOn;
    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    @Column(name="MODIFIED")
    private Date modifiedOn;
    @Column(name="ENV", length=5)
    private String env;

    @PreUpdate
    @PrePersist
    public void updateTimeStamps() {
        this.modifiedOn = new Date();
        if (this.createdOn == null) {
            this.createdOn = new Date();
        }
    }

    public static UserInitBuilder builder() {
        return new UserInitBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public String getGoogleLoginId() {
        return this.googleLoginId;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public String getEnv() {
        return this.env;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public void setGoogleLoginId(String googleLoginId) {
        this.googleLoginId = googleLoginId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @JsonFormat(pattern="yyyy-MM-dd h:mm:ss a zzz")
    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserInit)) {
            return false;
        }
        UserInit other = (UserInit)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$loginId = this.getLoginId();
        String other$loginId = other.getLoginId();
        if (this$loginId == null ? other$loginId != null : !this$loginId.equals(other$loginId)) {
            return false;
        }
        String this$googleLoginId = this.getGoogleLoginId();
        String other$googleLoginId = other.getGoogleLoginId();
        if (this$googleLoginId == null ? other$googleLoginId != null : !this$googleLoginId.equals(other$googleLoginId)) {
            return false;
        }
        String this$folderId = this.getFolderId();
        String other$folderId = other.getFolderId();
        if (this$folderId == null ? other$folderId != null : !this$folderId.equals(other$folderId)) {
            return false;
        }
        Date this$createdOn = this.getCreatedOn();
        Date other$createdOn = other.getCreatedOn();
        if (this$createdOn == null ? other$createdOn != null : !((Object)this$createdOn).equals(other$createdOn)) {
            return false;
        }
        Date this$modifiedOn = this.getModifiedOn();
        Date other$modifiedOn = other.getModifiedOn();
        if (this$modifiedOn == null ? other$modifiedOn != null : !((Object)this$modifiedOn).equals(other$modifiedOn)) {
            return false;
        }
        String this$env = this.getEnv();
        String other$env = other.getEnv();
        return !(this$env == null ? other$env != null : !this$env.equals(other$env));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserInit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $loginId = this.getLoginId();
        result = result * 59 + ($loginId == null ? 43 : $loginId.hashCode());
        String $googleLoginId = this.getGoogleLoginId();
        result = result * 59 + ($googleLoginId == null ? 43 : $googleLoginId.hashCode());
        String $folderId = this.getFolderId();
        result = result * 59 + ($folderId == null ? 43 : $folderId.hashCode());
        Date $createdOn = this.getCreatedOn();
        result = result * 59 + ($createdOn == null ? 43 : ((Object)$createdOn).hashCode());
        Date $modifiedOn = this.getModifiedOn();
        result = result * 59 + ($modifiedOn == null ? 43 : ((Object)$modifiedOn).hashCode());
        String $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        return result;
    }

    public String toString() {
        return "UserInit(id=" + this.getId() + ", loginId=" + this.getLoginId() + ", googleLoginId=" + this.getGoogleLoginId() + ", folderId=" + this.getFolderId() + ", createdOn=" + this.getCreatedOn() + ", modifiedOn=" + this.getModifiedOn() + ", env=" + this.getEnv() + ")";
    }

    public UserInit(Long id, String loginId, String googleLoginId, String folderId, Date createdOn, Date modifiedOn, String env) {
        this.id = id;
        this.loginId = loginId;
        this.googleLoginId = googleLoginId;
        this.folderId = folderId;
        this.createdOn = createdOn;
        this.modifiedOn = modifiedOn;
        this.env = env;
    }

    public UserInit() {
    }
}

