/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.services;

import java.io.Serializable;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheListener
implements CacheEntryCreatedListener<Object, Object>,
CacheEntryExpiredListener<Object, Object>,
CacheEntryRemovedListener<Object, Object>,
CacheEntryUpdatedListener<Object, Object>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(CacheListener.class);

    private void onEvent(Iterable<CacheEntryEvent<?, ?>> cacheEntryEvents) {
        for (CacheEntryEvent<?, ?> entryEvent : cacheEntryEvents) {
            log.debug("Cache event = {}, Key = {},  Old value = {}, New value = {}", new Object[]{entryEvent.getEventType(), entryEvent.getKey(), entryEvent.getOldValue(), entryEvent.getValue()});
        }
    }

    public void onCreated(Iterable<CacheEntryEvent<?, ?>> cacheEntryEvents) throws CacheEntryListenerException {
        this.onEvent(cacheEntryEvents);
    }

    public void onExpired(Iterable<CacheEntryEvent<?, ?>> cacheEntryEvents) throws CacheEntryListenerException {
        this.onEvent(cacheEntryEvents);
    }

    public void onRemoved(Iterable<CacheEntryEvent<?, ?>> cacheEntryEvents) throws CacheEntryListenerException {
        this.onEvent(cacheEntryEvents);
    }

    public void onUpdated(Iterable<CacheEntryEvent<?, ?>> cacheEntryEvents) throws CacheEntryListenerException {
        this.onEvent(cacheEntryEvents);
    }
}

