/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.gct.services;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.directory.Directory;
import com.google.api.services.directory.model.Group;
import com.google.api.services.directory.model.Member;
import com.google.api.services.directory.model.Members;
import com.google.api.services.directory.model.MembersHasMember;
import com.google.api.services.directory.model.Users;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import com.google.api.services.drive.model.Permission;
import com.google.api.services.drive.model.PermissionList;
import com.google.api.services.groupssettings.Groupssettings;
import com.google.api.services.groupssettings.model.Groups;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import edu.iu.uits.lms.canvas.helpers.CourseHelper;
import edu.iu.uits.lms.canvas.helpers.EnrollmentHelper;
import edu.iu.uits.lms.canvas.model.ConversationCreateWrapper;
import edu.iu.uits.lms.canvas.model.Course;
import edu.iu.uits.lms.canvas.model.User;
import edu.iu.uits.lms.canvas.model.groups.CourseGroup;
import edu.iu.uits.lms.canvas.services.CanvasService;
import edu.iu.uits.lms.canvas.services.ConversationService;
import edu.iu.uits.lms.canvas.services.CourseService;
import edu.iu.uits.lms.canvas.services.GroupService;
import edu.iu.uits.lms.canvas.services.UserService;
import edu.iu.uits.lms.email.model.EmailDetails;
import edu.iu.uits.lms.email.service.EmailService;
import edu.iu.uits.lms.email.service.LmsEmailTooBigException;
import edu.iu.uits.lms.gct.Constants;
import edu.iu.uits.lms.gct.config.ToolConfig;
import edu.iu.uits.lms.gct.model.CourseGroupWrapper;
import edu.iu.uits.lms.gct.model.CourseInit;
import edu.iu.uits.lms.gct.model.DecoratedCanvasUser;
import edu.iu.uits.lms.gct.model.DropboxInit;
import edu.iu.uits.lms.gct.model.GctProperty;
import edu.iu.uits.lms.gct.model.GroupsInit;
import edu.iu.uits.lms.gct.model.NotificationData;
import edu.iu.uits.lms.gct.model.RosterSyncCourseData;
import edu.iu.uits.lms.gct.model.SerializableGroup;
import edu.iu.uits.lms.gct.model.TokenInfo;
import edu.iu.uits.lms.gct.model.UserInit;
import edu.iu.uits.lms.gct.repository.CourseInitRepository;
import edu.iu.uits.lms.gct.repository.DropboxInitRepository;
import edu.iu.uits.lms.gct.repository.GctPropertyRepository;
import edu.iu.uits.lms.gct.repository.GroupsInitRepository;
import edu.iu.uits.lms.gct.repository.UserInitRepository;
import edu.iu.uits.lms.gct.services.GoogleCourseToolsService;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.mail.MessagingException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GoogleCourseToolsService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(GoogleCourseToolsService.class);
    private static final String APPLICATION_NAME = "LMS Google Course Tools";
    protected static final String PROP_ROOT_FOLDER_KEY = "gct.rootFolderId";
    protected static final String PROP_COURSES_FOLDER_KEY = "gct.coursesFolderId";
    protected static final String PROP_USERS_FOLDER_KEY = "gct.usersFolderId";
    private Drive driveService;
    private Directory directoryService;
    private Groupssettings groupsSettingsService;
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive", "https://www.googleapis.com/auth/admin.directory.group", "https://www.googleapis.com/auth/apps.groups.settings");
    @Value(value="${app.fullFilePath}/gct-creds.json")
    private String CREDENTIALS_FILE_PATH;
    @Autowired
    private ToolConfig toolConfig;
    @Autowired
    private CourseInitRepository courseInitRepository;
    @Autowired
    private GroupsInitRepository groupsInitRepository;
    @Autowired
    private DropboxInitRepository dropboxInitRepository;
    @Autowired
    private UserInitRepository userInitRepository;
    @Autowired
    private GctPropertyRepository gctPropertyRepository;
    @Autowired
    private CourseService courseService;
    @Autowired
    private ConversationService conversationService;
    @Autowired
    private CanvasService canvasService;
    @Autowired
    private UserService userService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private FreeMarkerConfigurer freemarkerConfigurer;
    private static TokenInfo pickerTokenInfo;
    @Resource
    @Lazy
    private GoogleCourseToolsService self;

    public void afterPropertiesSet() {
        try {
            GoogleCredentials credentials;
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
            try (FileInputStream serviceAccountStream = new FileInputStream(this.stripProtocol(this.CREDENTIALS_FILE_PATH));){
                ServiceAccountCredentials saCredentials = ServiceAccountCredentials.fromStream((InputStream)serviceAccountStream);
                credentials = saCredentials.createDelegated(this.toolConfig.getImpersonationAccount()).createScoped((Collection)SCOPES);
                pickerTokenInfo = TokenInfo.builder().clientId(this.toolConfig.getPickerClientId()).projectId(saCredentials.getProjectId()).devKey(this.toolConfig.getPickerApiKey()).canvasOrigin(this.canvasService.getBaseUrl()).build();
                log.debug("Client Id: {}", (Object)saCredentials.getClientId());
            }
            this.driveService = new Drive.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName("LMS Google Course Tools").build();
            this.directoryService = new Directory.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName("LMS Google Course Tools").build();
            this.groupsSettingsService = new Groupssettings.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName("LMS Google Course Tools").build();
            this.initBaseFolders();
        }
        catch (IOException | GeneralSecurityException e) {
            log.error("Unable to initialize service", (Throwable)e);
        }
    }

    public TokenInfo getPickerTokenInfo() {
        return pickerTokenInfo;
    }

    @Cacheable(value={"driveServiceAsUser"}, cacheManager="GoogleCourseToolsCacheManager")
    public Drive getDriveServiceAsUser(String user) {
        try {
            GoogleCredentials credentials;
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            GsonFactory jsonFactory = GsonFactory.getDefaultInstance();
            try (FileInputStream serviceAccountStream = new FileInputStream(this.stripProtocol(this.CREDENTIALS_FILE_PATH));){
                ServiceAccountCredentials saCredentials = ServiceAccountCredentials.fromStream((InputStream)serviceAccountStream);
                credentials = saCredentials.createDelegated(user).createScoped(new String[]{"https://www.googleapis.com/auth/drive"});
                log.debug("Client Id: {}", (Object)saCredentials.getClientId());
            }
            Drive driveService = new Drive.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials)).setApplicationName("LMS Google Course Tools").build();
            return driveService;
        }
        catch (IOException | GeneralSecurityException e) {
            log.error("Unable to initialize service", (Throwable)e);
            return null;
        }
    }

    public boolean titleHasInvalidCharacters(String courseTitle) {
        char[] invalidCharacters = new char[]{'=', '<', '>'};
        return StringUtils.containsAny((CharSequence)courseTitle, (char[])invalidCharacters);
    }

    public File createCourseRootFolder(String courseId, String courseTitle, String emailForAccess) throws IOException {
        GctProperty coursesIdProp = this.gctPropertyRepository.findByKeyAndEnv("gct.coursesFolderId", this.toolConfig.getEnv());
        String courseDisplay = this.toolConfig.getEnvDisplayPrefix() + MessageFormat.format("{0} ({1})", courseTitle, courseId);
        File courseFolder = this.findFolder(courseDisplay, coursesIdProp.getValue());
        if (courseFolder == null) {
            File gctCourseMetadata = new File();
            gctCourseMetadata.setName(courseDisplay);
            gctCourseMetadata.setMimeType("application/vnd.google-apps.folder");
            gctCourseMetadata.setParents(Collections.singletonList(coursesIdProp.getValue()));
            gctCourseMetadata.setDescription("Parent folder for shared folders belonging to the course " + courseDisplay + ". This folder was created by the Google Course Tools app for Canvas.");
            gctCourseMetadata.setWritersCanShare(Boolean.valueOf(false));
            courseFolder = (File)this.driveService.files().create(gctCourseMetadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
        }
        log.info("User folder: {}", (Object)courseFolder);
        Permission folderPermission = new Permission();
        folderPermission.setType(Constants.PERMISSION_TYPE.group.name());
        folderPermission.setRole(Constants.PERMISSION_ROLES.reader.name());
        folderPermission.setEmailAddress(emailForAccess);
        Permission permission = (Permission)this.driveService.permissions().create(courseFolder.getId(), folderPermission).setSendNotificationEmail(Boolean.valueOf(false)).execute();
        log.info("Folder permission: {}", (Object)permission);
        return courseFolder;
    }

    private Permission addOrUpdatePermissionForFile(Drive driveServiceAsUser, String fileId, List<Permission> permissions, Constants.PERMISSION_TYPE permissionType, String role, String emailForAccess) throws IOException {
        Permission existingPermission = GoogleCourseToolsService.findExistingPerm(permissions, (String)emailForAccess);
        Permission perm = new Permission();
        perm.setType(permissionType.name());
        perm.setRole(role);
        perm.setEmailAddress(emailForAccess);
        Permission permission = null;
        if (existingPermission == null) {
            log.debug("new perm");
            permission = (Permission)driveServiceAsUser.permissions().create(fileId, perm).setSendNotificationEmail(Boolean.valueOf(false)).execute();
        } else {
            log.debug("updating perm");
            Permission updPerm = new Permission();
            updPerm.setRole(role);
            permission = (Permission)driveServiceAsUser.permissions().update(fileId, existingPermission.getId(), updPerm).execute();
        }
        log.info("Permission: {}", (Object)permission);
        return permission;
    }

    public File createUserRootFolder(String userEmail, String username) throws IOException {
        GctProperty usersIdProp = this.gctPropertyRepository.findByKeyAndEnv("gct.usersFolderId", this.toolConfig.getEnv());
        File gctUserMetadata = new File();
        gctUserMetadata.setName(this.toolConfig.getEnvDisplayPrefix() + "Google Course Tools (" + username + ")");
        gctUserMetadata.setMimeType("application/vnd.google-apps.folder");
        gctUserMetadata.setParents(Collections.singletonList(usersIdProp.getValue()));
        gctUserMetadata.setDescription("Parent folder for course folders created by the Google Course Tools app for Canvas.  Please do not move or delete.");
        gctUserMetadata.setWritersCanShare(Boolean.valueOf(false));
        File userFolder = (File)this.driveService.files().create(gctUserMetadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
        log.info("User folder: {}", (Object)userFolder);
        Permission folderPermission = new Permission();
        folderPermission.setType(Constants.PERMISSION_TYPE.user.name());
        folderPermission.setRole(Constants.PERMISSION_ROLES.writer.name());
        folderPermission.setEmailAddress(userEmail);
        Permission permission = (Permission)this.driveService.permissions().create(userFolder.getId(), folderPermission).setSendNotificationEmail(Boolean.valueOf(false)).execute();
        log.info("Folder permission: {}", (Object)permission);
        this.addShortcut(userFolder, null, userEmail);
        return userFolder;
    }

    public List<String> initBaseFolders() throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        GctProperty rootIdProp = this.gctPropertyRepository.findByKeyAndEnv("gct.rootFolderId", this.toolConfig.getEnv());
        GctProperty coursesIdProp = this.gctPropertyRepository.findByKeyAndEnv("gct.coursesFolderId", this.toolConfig.getEnv());
        GctProperty usersIdProp = this.gctPropertyRepository.findByKeyAndEnv("gct.usersFolderId", this.toolConfig.getEnv());
        if (rootIdProp == null) {
            File rootFolderMetadata = new File();
            rootFolderMetadata.setName(this.toolConfig.getEnvDisplayPrefix() + "Google Course Tools Admin");
            rootFolderMetadata.setMimeType("application/vnd.google-apps.folder");
            rootFolderMetadata.setDescription("Container folder for Google Course Tools Assets.");
            rootFolderMetadata.setWritersCanShare(Boolean.valueOf(false));
            File rootFolder = (File)this.driveService.files().create(rootFolderMetadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
            log.info("Root folder info: {}", (Object)rootFolder);
            rootIdProp = new GctProperty("gct.rootFolderId", rootFolder.getId(), this.toolConfig.getEnv());
            this.gctPropertyRepository.save((Object)rootIdProp);
            ids.add(rootFolder.getId());
        }
        if (coursesIdProp == null) {
            File coursesFolderMetadata = new File();
            coursesFolderMetadata.setName(this.toolConfig.getEnvDisplayPrefix() + "GCT Courses");
            coursesFolderMetadata.setMimeType("application/vnd.google-apps.folder");
            coursesFolderMetadata.setDescription("Container for course folders created by the Google Course Tools LTI.");
            coursesFolderMetadata.setWritersCanShare(Boolean.valueOf(false));
            coursesFolderMetadata.setParents(Collections.singletonList(rootIdProp.getValue()));
            File coursesFolder = (File)this.driveService.files().create(coursesFolderMetadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
            log.info("Course folder info: {}", (Object)coursesFolder);
            coursesIdProp = new GctProperty("gct.coursesFolderId", coursesFolder.getId(), this.toolConfig.getEnv());
            this.gctPropertyRepository.save((Object)coursesIdProp);
            ids.add(coursesFolder.getId());
        }
        if (usersIdProp == null) {
            File usersFolderMetadata = new File();
            usersFolderMetadata.setName(this.toolConfig.getEnvDisplayPrefix() + "GCT User Folders");
            usersFolderMetadata.setMimeType("application/vnd.google-apps.folder");
            usersFolderMetadata.setParents(Collections.singletonList(rootIdProp.getValue()));
            usersFolderMetadata.setDescription("Container for user folders created by the Google Course Tools LTI.");
            usersFolderMetadata.setWritersCanShare(Boolean.valueOf(false));
            File usersFolder = (File)this.driveService.files().create(usersFolderMetadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
            log.info("Users folder info: {}", (Object)usersFolder);
            usersIdProp = new GctProperty("gct.usersFolderId", usersFolder.getId(), this.toolConfig.getEnv());
            this.gctPropertyRepository.save((Object)usersIdProp);
            ids.add(usersFolder.getId());
        }
        return ids;
    }

    public List<File> getDriveFiles() throws IOException {
        FileList result = (FileList)this.driveService.files().list().setOrderBy("name").execute();
        List files = result.getFiles();
        if (files == null || files.isEmpty()) {
            System.out.println("No files found.");
        } else {
            System.out.println("Files:");
            for (File file : files) {
                System.out.printf("%s (%s)\n", file.getName(), file.getId());
            }
        }
        return files;
    }

    public Map<Constants.GROUP_TYPES, Group> createCourseGroups(String canvasCourseId, String courseName, boolean mailingListActive) throws IOException {
        HashMap<Constants.GROUP_TYPES, Group> groups = new HashMap<Constants.GROUP_TYPES, Group>();
        groups.put(Constants.GROUP_TYPES.ALL, this.createAllGroup(canvasCourseId, courseName, mailingListActive));
        groups.put(Constants.GROUP_TYPES.TEACHER, this.createTeachersGroup(canvasCourseId, courseName));
        return groups;
    }

    private Member addMemberToGroupWithRetry(String groupEmail, String userEmail, Constants.GROUP_ROLES role) throws IOException {
        RetryTemplate retry = new RetryTemplate();
        retry.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(3, Collections.singletonMap(IOException.class, true)));
        retry.setBackOffPolicy((BackOffPolicy)new ExponentialBackOffPolicy());
        return (Member)retry.execute(retryContext -> {
            log.debug("Adding member {} to group {} as {} attempt #{}", new Object[]{userEmail, groupEmail, role.name(), retryContext.getRetryCount() + 1});
            return this.addMemberToGroup(groupEmail, userEmail, role);
        });
    }

    protected String buildValidatedGroupName(String canvasCourseId, String courseName, String groupNamePattern) {
        String groupName = MessageFormat.format(groupNamePattern, this.toolConfig.getEnvDisplayPrefix(), courseName, canvasCourseId);
        int groupNameLength = groupName.length();
        if (groupNameLength > 73) {
            int diff = groupNameLength - 73;
            String truncatedCourseName = courseName.substring(0, courseName.length() - diff);
            groupName = MessageFormat.format(groupNamePattern, this.toolConfig.getEnvDisplayPrefix(), truncatedCourseName, canvasCourseId);
        }
        return groupName;
    }

    protected String buildValidatedGroupName(CourseGroup courseGroup, String groupNamePattern) {
        String groupName = MessageFormat.format(groupNamePattern, this.toolConfig.getEnvDisplayPrefix(), courseGroup.getName(), courseGroup.getCourseId(), courseGroup.getId());
        int groupNameLength = groupName.length();
        if (groupNameLength > 73) {
            int diff = groupNameLength - 73;
            String truncatedCourseName = courseGroup.getName().substring(0, courseGroup.getName().length() - diff);
            groupName = MessageFormat.format(groupNamePattern, this.toolConfig.getEnvDisplayPrefix(), truncatedCourseName, courseGroup.getCourseId(), courseGroup.getId());
        }
        return groupName;
    }

    private Group createGroup(String email, String groupName, String groupDescription) throws IOException {
        Group group;
        try {
            group = this.getGroup(email);
            log.debug("Returning existing group: {}", (Object)email);
        }
        catch (IOException e) {
            Group newGroup = new Group();
            newGroup.setName(groupName);
            newGroup.setDescription(groupDescription);
            newGroup.setEmail(email);
            group = (Group)this.directoryService.groups().insert(newGroup).execute();
            log.debug("Created new group: {}", (Object)email);
        }
        return group;
    }

    protected String escapeQueryValues(String input) {
        return input.replace("'", "\\'");
    }

    private Group createAllGroup(String canvasCourseId, String courseName, boolean mailingListActive) throws IOException {
        String email = this.toolConfig.getEnvDisplayPrefix() + canvasCourseId + "-all-iu-group@iu.edu";
        String groupNamePattern = "{0}{1}-{2} All";
        String groupName = this.buildValidatedGroupName(canvasCourseId, courseName, groupNamePattern);
        String groupDescription = "Google group for all members of " + courseName + "-" + canvasCourseId;
        Group group = this.createGroup(email, groupName, groupDescription);
        Groups groupSettings = (Groups)this.groupsSettingsService.groups().get(group.getEmail()).execute();
        groupSettings.setWhoCanJoin("INVITED_CAN_JOIN");
        groupSettings.setWhoCanViewMembership("ALL_MANAGERS_CAN_VIEW");
        groupSettings.setWhoCanViewGroup("ALL_MEMBERS_CAN_VIEW");
        groupSettings.setAllowExternalMembers("true");
        groupSettings.setPrimaryLanguage("en");
        groupSettings.setArchiveOnly("false");
        groupSettings.setMessageModerationLevel("MODERATE_NONE");
        groupSettings.setSpamModerationLevel("REJECT");
        groupSettings.setReplyTo("REPLY_TO_LIST");
        groupSettings.setIncludeCustomFooter("false");
        groupSettings.setCustomFooterText(null);
        groupSettings.setSendMessageDenyNotification("true");
        groupSettings.setDefaultMessageDenyNotificationText("Your message was not accepted by the Google Group named " + groupName);
        groupSettings.setMembersCanPostAsTheGroup("false");
        groupSettings.setIncludeInGlobalAddressList("true");
        groupSettings.setWhoCanLeaveGroup("NONE_CAN_LEAVE");
        groupSettings.setWhoCanContactOwner("ALL_MANAGERS_CAN_CONTACT");
        groupSettings.setFavoriteRepliesOnTop("true");
        groupSettings.setWhoCanModerateMembers("OWNERS_AND_MANAGERS");
        groupSettings.setWhoCanModerateContent("OWNERS_AND_MANAGERS");
        groupSettings.setWhoCanAssistContent("OWNERS_AND_MANAGERS");
        groupSettings.setCustomRolesEnabledForSettingsToBeMerged("false");
        groupSettings.setEnableCollaborativeInbox("false");
        groupSettings.setWhoCanDiscoverGroup("ALL_MEMBERS_CAN_DISCOVER");
        if (mailingListActive) {
            groupSettings.setWhoCanPostMessage("ALL_MEMBERS_CAN_POST");
            groupSettings.setAllowWebPosting("true");
            groupSettings.setIsArchived("true");
        } else {
            groupSettings.setWhoCanPostMessage("ALL_MANAGERS_CAN_POST");
            groupSettings.setAllowWebPosting("false");
            groupSettings.setIsArchived("false");
        }
        this.groupsSettingsService.groups().update(group.getEmail(), groupSettings).execute();
        return group;
    }

    public void updateGroupMailingListSettings(String groupEmail) throws IOException {
        Groups groupSettings = (Groups)this.groupsSettingsService.groups().get(groupEmail).execute();
        boolean changes = false;
        if (!groupSettings.getWhoCanPostMessage().equals("ALL_MEMBERS_CAN_POST")) {
            groupSettings.setWhoCanPostMessage("ALL_MEMBERS_CAN_POST");
            changes = true;
        }
        if (!groupSettings.getAllowWebPosting().equals("true")) {
            groupSettings.setAllowWebPosting("true");
            changes = true;
        }
        if (!groupSettings.getIsArchived().equals("true")) {
            groupSettings.setIsArchived("true");
            changes = true;
        }
        if (changes) {
            this.groupsSettingsService.groups().update(groupEmail, groupSettings).execute();
        }
    }

    private Group createTeachersGroup(String canvasCourseId, String courseName) throws IOException {
        String email = this.toolConfig.getEnvDisplayPrefix() + canvasCourseId + "-teachers-iu-group@iu.edu";
        String groupNamePattern = "{0}{1}-{2} Teachers";
        String groupName = this.buildValidatedGroupName(canvasCourseId, courseName, groupNamePattern);
        String groupDescription = "Google group for instructors of " + courseName + "-" + canvasCourseId;
        Group group = this.createGroup(email, groupName, groupDescription);
        Groups groupSettings = (Groups)this.groupsSettingsService.groups().get(group.getEmail()).execute();
        groupSettings.setWhoCanJoin("INVITED_CAN_JOIN");
        groupSettings.setWhoCanViewMembership("ALL_MANAGERS_CAN_VIEW");
        groupSettings.setWhoCanViewGroup("ALL_MEMBERS_CAN_VIEW");
        groupSettings.setAllowExternalMembers("true");
        groupSettings.setWhoCanPostMessage("ALL_MANAGERS_CAN_POST");
        groupSettings.setAllowWebPosting("false");
        groupSettings.setPrimaryLanguage("en");
        groupSettings.setIsArchived("true");
        groupSettings.setArchiveOnly("false");
        groupSettings.setMessageModerationLevel("MODERATE_NONE");
        groupSettings.setSpamModerationLevel("REJECT");
        groupSettings.setReplyTo("REPLY_TO_LIST");
        groupSettings.setIncludeCustomFooter("false");
        groupSettings.setCustomFooterText(null);
        groupSettings.setSendMessageDenyNotification("true");
        groupSettings.setDefaultMessageDenyNotificationText("Your message was not accepted by the Google Group named " + groupName);
        groupSettings.setMembersCanPostAsTheGroup("false");
        groupSettings.setIncludeInGlobalAddressList("true");
        groupSettings.setWhoCanLeaveGroup("NONE_CAN_LEAVE");
        groupSettings.setWhoCanContactOwner("ALL_MANAGERS_CAN_CONTACT");
        groupSettings.setFavoriteRepliesOnTop("true");
        groupSettings.setWhoCanModerateMembers("OWNERS_AND_MANAGERS");
        groupSettings.setWhoCanModerateContent("OWNERS_AND_MANAGERS");
        groupSettings.setWhoCanAssistContent("OWNERS_AND_MANAGERS");
        groupSettings.setCustomRolesEnabledForSettingsToBeMerged("false");
        groupSettings.setEnableCollaborativeInbox("false");
        groupSettings.setWhoCanDiscoverGroup("ALL_MEMBERS_CAN_DISCOVER");
        this.groupsSettingsService.groups().update(group.getEmail(), groupSettings).execute();
        return group;
    }

    private Group createGroupForCanvasGroup(CourseGroup courseGroup) throws IOException {
        String email = this.getEmailForCourseGroup(courseGroup);
        String groupNamePattern = "{0}{1}-{2}-{3}";
        String groupName = this.buildValidatedGroupName(courseGroup, groupNamePattern);
        String groupDescription = "Google group for members of " + courseGroup.getName();
        Group group = this.createGroup(email, groupName, groupDescription);
        Groups groupSettings = (Groups)this.groupsSettingsService.groups().get(group.getEmail()).execute();
        groupSettings.setWhoCanJoin("INVITED_CAN_JOIN");
        groupSettings.setWhoCanViewMembership("ALL_MANAGERS_CAN_VIEW");
        groupSettings.setWhoCanViewGroup("ALL_MEMBERS_CAN_VIEW");
        groupSettings.setAllowExternalMembers("true");
        groupSettings.setWhoCanPostMessage("ALL_MANAGERS_CAN_POST");
        groupSettings.setAllowWebPosting("false");
        groupSettings.setPrimaryLanguage("en");
        groupSettings.setIsArchived("true");
        groupSettings.setArchiveOnly("false");
        groupSettings.setMessageModerationLevel("MODERATE_NONE");
        groupSettings.setSpamModerationLevel("REJECT");
        groupSettings.setReplyTo("REPLY_TO_LIST");
        groupSettings.setIncludeCustomFooter("false");
        groupSettings.setCustomFooterText(null);
        groupSettings.setSendMessageDenyNotification("true");
        groupSettings.setDefaultMessageDenyNotificationText("Your message was not accepted by the Google Group named " + groupName);
        groupSettings.setMembersCanPostAsTheGroup("false");
        groupSettings.setIncludeInGlobalAddressList("true");
        groupSettings.setWhoCanLeaveGroup("NONE_CAN_LEAVE");
        groupSettings.setWhoCanContactOwner("ALL_MANAGERS_CAN_CONTACT");
        groupSettings.setFavoriteRepliesOnTop("true");
        groupSettings.setWhoCanModerateMembers("OWNERS_AND_MANAGERS");
        groupSettings.setWhoCanModerateContent("OWNERS_AND_MANAGERS");
        groupSettings.setWhoCanAssistContent("OWNERS_AND_MANAGERS");
        groupSettings.setCustomRolesEnabledForSettingsToBeMerged("false");
        groupSettings.setEnableCollaborativeInbox("false");
        groupSettings.setWhoCanDiscoverGroup("ALL_MEMBERS_CAN_DISCOVER");
        this.groupsSettingsService.groups().update(group.getEmail(), groupSettings).execute();
        return group;
    }

    public Group getGroup(String key) throws IOException {
        Group group = (Group)this.directoryService.groups().get(key).execute();
        return group;
    }

    public List<Group> getGroups() throws IOException {
        com.google.api.services.directory.model.Groups groups = (com.google.api.services.directory.model.Groups)this.directoryService.groups().list().setDomain(this.toolConfig.getDomain()).execute();
        return groups.getGroups();
    }

    public CourseGroupWrapper getOrCreateGroupsForCourse(String courseId, String courseTitle, CourseInit courseInit) throws IOException {
        CourseGroupWrapper cgw = this.getGroupsForCourse(courseId);
        if (cgw == null || !cgw.hasRequiredGroups()) {
            this.createCourseGroups(courseId, courseTitle, courseInit.getMailingListAddress() != null);
            cgw = this.getGroupsForCourseWithRetry(courseId);
        }
        return cgw;
    }

    private CourseGroupWrapper getGroupsForCourseWithRetry(String courseId) throws IOException {
        CourseGroupWrapper cgw = null;
        RetryTemplate retry = new RetryTemplate();
        HashMap<Class, Boolean> exceptionMap = new HashMap<Class, Boolean>();
        exceptionMap.put(IOException.class, true);
        exceptionMap.put(MissingGroupException.class, true);
        retry.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(3, exceptionMap));
        retry.setBackOffPolicy((BackOffPolicy)new ExponentialBackOffPolicy());
        try {
            cgw = (CourseGroupWrapper)retry.execute(retryContext -> {
                log.debug("Getting groups for course {} attempt #{}", (Object)courseId, (Object)retryContext.getRetryCount());
                CourseGroupWrapper groupsForCourse = this.getGroupsForCourse(courseId);
                if (groupsForCourse == null || !groupsForCourse.hasRequiredGroups()) {
                    log.error("Attempt failed.  Retrying...");
                    throw new MissingGroupException();
                }
                return groupsForCourse;
            });
        }
        catch (MissingGroupException e) {
            throw new RuntimeException(e);
        }
        return cgw;
    }

    private CourseGroupWrapper getGroupsForCourse(String courseId) throws IOException {
        ArrayList totalGroups = new ArrayList();
        CourseGroupWrapper cgw = null;
        com.google.api.services.directory.model.Groups groups = (com.google.api.services.directory.model.Groups)this.directoryService.groups().list().setQuery("email:" + this.toolConfig.getEnvDisplayPrefix() + courseId + "-*").setDomain(this.toolConfig.getDomain()).execute();
        if (groups != null && groups.getGroups() != null) {
            totalGroups.addAll(groups.getGroups());
            while (groups.getNextPageToken() != null) {
                groups = (com.google.api.services.directory.model.Groups)this.directoryService.groups().list().setQuery("email:" + this.toolConfig.getEnvDisplayPrefix() + courseId + "-*").setDomain(this.toolConfig.getDomain()).setPageToken(groups.getNextPageToken()).execute();
                if (groups == null || groups.getGroups() == null) continue;
                totalGroups.addAll(groups.getGroups());
            }
            cgw = new CourseGroupWrapper();
            for (Group group : totalGroups) {
                if (group.getEmail().contains("all")) {
                    cgw.setAllGroup(new SerializableGroup(group));
                    continue;
                }
                if (group.getEmail().contains("teachers")) {
                    cgw.setTeacherGroup(new SerializableGroup(group));
                    continue;
                }
                cgw.addCanvasGroup(new SerializableGroup(group));
            }
        }
        return cgw;
    }

    public List<com.google.api.services.directory.model.User> getUsers() throws IOException {
        Users users = (Users)this.directoryService.users().list().setDomain(this.toolConfig.getDomain()).execute();
        return users.getUsers();
    }

    public List<Member> addMembersToGroup(String groupEmail, List<String> userEmails, Constants.GROUP_ROLES role) throws IOException {
        ArrayList<Member> members = new ArrayList<Member>();
        for (String userEmail : userEmails) {
            Member member = this.addMemberToGroup(groupEmail, userEmail, role);
            members.add(member);
        }
        return members;
    }

    public List<Member> getMembersOfGroup(String groupEmail) throws IOException {
        Members members = (Members)this.directoryService.members().list(groupEmail).execute();
        ArrayList<Member> allMembers = new ArrayList<Member>();
        if (members != null && members.getMembers() != null) {
            allMembers.addAll(members.getMembers());
            while (members.getNextPageToken() != null) {
                members = (Members)this.directoryService.members().list(groupEmail).setPageToken(members.getNextPageToken()).execute();
                if (members == null || members.getMembers() == null) continue;
                allMembers.addAll(members.getMembers());
            }
        }
        return allMembers;
    }

    public boolean isUserInGroup(String groupEmail, String userLoginId) {
        try {
            String userEmail = this.loginToEmail(userLoginId);
            Member member = (Member)this.directoryService.members().get(groupEmail, userEmail).execute();
            if (member != null) {
                return true;
            }
        }
        catch (IOException io) {
            return false;
        }
        return false;
    }

    public Map<String, String> getFolderIdByCourseGroup(String canvasCourseId) {
        List allCourseGroups = this.groupsInitRepository.findByCanvasCourseIdAndEnv(canvasCourseId, this.toolConfig.getEnv());
        return allCourseGroups.stream().collect(Collectors.toMap(gi -> this.getEmailForCourseGroup(gi.getCanvasCourseId(), gi.getCanvasGroupId()).toLowerCase(), GroupsInit::getFolderId));
    }

    public GroupsInit getGroupsInit(String canvasCourseId, String folderId) {
        return this.groupsInitRepository.findByCanvasCourseIdAndFolderIdAndEnv(canvasCourseId, folderId, this.toolConfig.getEnv());
    }

    public Member addMemberToGroup(String groupEmail, String userEmail, Constants.GROUP_ROLES role) throws IOException {
        Member member;
        try {
            member = (Member)this.directoryService.members().get(groupEmail, userEmail).execute();
        }
        catch (IOException io) {
            member = new Member();
            member.setEmail(userEmail);
            member.setRole(role.name());
            try {
                return (Member)this.directoryService.members().insert(groupEmail, member).execute();
            }
            catch (IOException ioException) {
                log.error("Unable to add {} to {}.  This usually means the user was already in the group, but not with an ACTIVE status.", (Object)userEmail, (Object)groupEmail);
            }
        }
        return member;
    }

    public void removeMemberFromGroup(String groupEmail, String userEmail) throws IOException {
        MembersHasMember hasMember = (MembersHasMember)this.directoryService.members().hasMember(groupEmail, userEmail).execute();
        if (hasMember.getIsMember().booleanValue()) {
            this.directoryService.members().delete(groupEmail, userEmail).execute();
        }
    }

    private String loginToEmail(String loginId) {
        return loginId + "@iu.edu";
    }

    public String stripEmailDomain(String email) {
        return email.substring(0, email.indexOf("-iu-group@iu.edu"));
    }

    public CourseInit getCourseInit(String courseId) {
        return this.courseInitRepository.findByCourseIdAndEnv(courseId, this.toolConfig.getEnv());
    }

    public DropboxInit getDropboxInit(String courseId, String loginId) {
        return this.dropboxInitRepository.findByCourseIdAndLoginIdAndEnv(courseId, loginId, this.toolConfig.getEnv());
    }

    public DropboxInit getDropboxInitByGoogleLogin(String courseId, String googleLoginId) {
        return this.dropboxInitRepository.findByCourseIdAndGoogleLoginIdAndEnv(courseId, googleLoginId, this.toolConfig.getEnv());
    }

    public UserInit getUserInit(String loginId) {
        return this.userInitRepository.findByLoginIdAndEnv(loginId, this.toolConfig.getEnv());
    }

    public CourseInit courseInitialization(String courseId, String courseTitle, String courseSisId, String courseCode, boolean mailingListActive) throws IOException {
        CourseInit ci = new CourseInit();
        Map groups = this.createCourseGroups(courseId, courseTitle, mailingListActive);
        log.info("Group details: {}", (Object)groups);
        File courseRootFolder = this.createCourseRootFolder(courseId, courseTitle, ((Group)groups.get(Constants.GROUP_TYPES.ALL)).getEmail());
        log.info("Course root folder: {}", (Object)courseRootFolder);
        ci.setCourseId(courseId);
        ci.setCourseFolderId(courseRootFolder.getId());
        ci.setEnv(this.toolConfig.getEnv());
        ci.setSisCourseId(courseSisId);
        ci.setCourseCode(courseCode);
        this.courseInitRepository.save((Object)ci);
        return ci;
    }

    public void addShortcut(String targetId, String parent, String asUserEmail) throws IOException {
        Drive localDriveService = this.driveService;
        if (asUserEmail != null) {
            localDriveService = this.self.getDriveServiceAsUser(asUserEmail);
        }
        File folder = (File)localDriveService.files().get(targetId).execute();
        this.addShortcut(folder, parent, asUserEmail);
    }

    private void addShortcut(File target, String parent, String asUserEmail) throws IOException {
        File shortcut = this.findShortcutForTarget(target.getName(), target.getId(), parent, asUserEmail);
        if (shortcut == null) {
            File newShortcut = new File();
            newShortcut.setName(target.getName());
            newShortcut.setMimeType("application/vnd.google-apps.shortcut");
            if (parent != null) {
                newShortcut.setParents(Collections.singletonList(parent));
            }
            File.ShortcutDetails sd = new File.ShortcutDetails();
            sd.setTargetId(target.getId());
            sd.setTargetMimeType(target.getMimeType());
            newShortcut.setShortcutDetails(sd);
            Drive localDriveService = this.driveService;
            if (asUserEmail != null) {
                localDriveService = this.self.getDriveServiceAsUser(asUserEmail);
            }
            shortcut = (File)localDriveService.files().create(newShortcut).execute();
        }
        log.info("Shortcut Info: {}", (Object)shortcut);
    }

    public void shareAndAddShortcut(String fileId, String destFolderId, CourseGroupWrapper groupsForCourse, String allPerm, String teacherPerm, String courseGroupPerm, String asUser, String emailForCourseGroup) throws IOException {
        String asUserEmail = this.loginToEmail(asUser);
        Drive driveServiceAsUser = this.self.getDriveServiceAsUser(asUserEmail);
        File fileChanges = new File();
        fileChanges.setWritersCanShare(Boolean.valueOf(false));
        File file = (File)driveServiceAsUser.files().update(fileId, fileChanges).setFields("id,name,permissions").execute();
        log.debug("File: {}", (Object)file);
        if (allPerm != null) {
            this.addOrUpdatePermissionForFile(driveServiceAsUser, fileId, file.getPermissions(), Constants.PERMISSION_TYPE.group, allPerm, groupsForCourse.getAllGroup().getEmail());
        }
        if (courseGroupPerm != null) {
            this.addOrUpdatePermissionForFile(driveServiceAsUser, fileId, file.getPermissions(), Constants.PERMISSION_TYPE.group, courseGroupPerm, emailForCourseGroup);
        }
        this.addOrUpdatePermissionForFile(driveServiceAsUser, fileId, file.getPermissions(), Constants.PERMISSION_TYPE.group, teacherPerm, groupsForCourse.getTeacherGroup().getEmail());
        this.addShortcut(file, destFolderId, asUserEmail);
    }

    private File findShortcutForTarget(String itemName, String targetFileId, String parentFolderId, String asUserEmail) {
        Drive localDriveService = this.driveService;
        if (asUserEmail != null) {
            localDriveService = this.self.getDriveServiceAsUser(asUserEmail);
        }
        String query = MessageFormat.format("name = ''{0}'' and parents in ''{1}'' and mimeType = ''{2}''", this.escapeQueryValues(itemName), parentFolderId, "application/vnd.google-apps.shortcut");
        File shortcut = null;
        try {
            FileList fileList = (FileList)localDriveService.files().list().setQ(query).setOrderBy("createdTime").setFields("files/shortcutDetails,files/id").execute();
            shortcut = fileList.getFiles().stream().filter(f -> targetFileId.equals(f.getShortcutDetails().getTargetId())).findFirst().orElse(null);
        }
        catch (IOException e) {
            log.warn("No shortcut found.  Returning null.");
        }
        return shortcut;
    }

    public void saveCourseInit(CourseInit courseInit) {
        this.courseInitRepository.save((Object)courseInit);
    }

    public File createCourseFileFolder(String courseId, String courseTitle, String teacherGroupEmail) throws IOException {
        String courseFolderId = this.courseInitRepository.findByCourseIdAndEnv(courseId, this.toolConfig.getEnv()).getCourseFolderId();
        String courseParentDisplay = MessageFormat.format("{0} ({1})", courseTitle, courseId);
        String courseDisplay = this.toolConfig.getEnvDisplayPrefix() + courseParentDisplay + ": COURSE FILES";
        File courseFileFolder = this.findFolder(courseDisplay, courseFolderId);
        if (courseFileFolder == null) {
            File gctCourseMetadata = new File();
            gctCourseMetadata.setName(courseDisplay);
            gctCourseMetadata.setMimeType("application/vnd.google-apps.folder");
            gctCourseMetadata.setParents(Collections.singletonList(courseFolderId));
            gctCourseMetadata.setDescription("Folder for sharing files with members of " + courseParentDisplay + ". This folder was created by the Google Course Tools app for Canvas.");
            gctCourseMetadata.setWritersCanShare(Boolean.valueOf(false));
            courseFileFolder = (File)this.driveService.files().create(gctCourseMetadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
        }
        log.info("Course files folder: {}", (Object)courseFileFolder);
        Permission folderPermission = new Permission();
        folderPermission.setType(Constants.PERMISSION_TYPE.group.name());
        folderPermission.setRole(Constants.PERMISSION_ROLES.writer.name());
        folderPermission.setEmailAddress(teacherGroupEmail);
        Permission permission = (Permission)this.driveService.permissions().create(courseFileFolder.getId(), folderPermission).setSendNotificationEmail(Boolean.valueOf(false)).execute();
        log.info("Course files folder permission: {}", (Object)permission);
        return courseFileFolder;
    }

    public static String getExistingRoleForGroupPerm(List<Permission> permissions, String groupEmail, String defaultPerm) {
        Permission perm = GoogleCourseToolsService.findExistingPerm(permissions, (String)groupEmail);
        if (perm != null) {
            return perm.getRole();
        }
        return defaultPerm;
    }

    private static Permission findExistingPerm(List<Permission> permissions, String groupEmail) {
        Permission perm = CollectionUtils.emptyIfNull(permissions).stream().filter(p -> Constants.PERMISSION_TYPE.group.name().equals(p.getType()) && groupEmail.equalsIgnoreCase(p.getEmailAddress())).findFirst().orElse(null);
        return perm;
    }

    public File createInstructorFileFolder(String courseId, String courseTitle, String allGroupEmail, String teacherGroupEmail) throws IOException {
        String courseFolderId = this.courseInitRepository.findByCourseIdAndEnv(courseId, this.toolConfig.getEnv()).getCourseFolderId();
        String courseParentDisplay = MessageFormat.format("{0} ({1})", courseTitle, courseId);
        String courseDisplay = this.toolConfig.getEnvDisplayPrefix() + courseParentDisplay + ": INSTRUCTOR FILES";
        File instructorFileFolder = this.findFolder(courseDisplay, courseFolderId);
        if (instructorFileFolder == null) {
            File gctCourseMetadata = new File();
            gctCourseMetadata.setName(courseDisplay);
            gctCourseMetadata.setMimeType("application/vnd.google-apps.folder");
            gctCourseMetadata.setParents(Collections.singletonList(courseFolderId));
            gctCourseMetadata.setDescription("Folder for sharing files with instructors of " + courseParentDisplay + ". This folder was created by the Google Course Tools app for Canvas.");
            gctCourseMetadata.setWritersCanShare(Boolean.valueOf(false));
            instructorFileFolder = (File)this.driveService.files().create(gctCourseMetadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
        }
        log.info("Instructor files folder: {}", (Object)instructorFileFolder);
        this.deleteFolderPermission(instructorFileFolder.getId(), allGroupEmail);
        Permission folderPermission = new Permission();
        folderPermission.setType(Constants.PERMISSION_TYPE.group.name());
        folderPermission.setRole(Constants.PERMISSION_ROLES.writer.name());
        folderPermission.setEmailAddress(teacherGroupEmail);
        Permission permission = (Permission)this.driveService.permissions().create(instructorFileFolder.getId(), folderPermission).setSendNotificationEmail(Boolean.valueOf(false)).execute();
        log.info("Instructor files folder permission: {}", (Object)permission);
        return instructorFileFolder;
    }

    public File createCanvasGroupsFolder(String courseId, String courseTitle, String allGroupEmail, String teacherGroupEmail) throws IOException {
        String courseFolderId = this.courseInitRepository.findByCourseIdAndEnv(courseId, this.toolConfig.getEnv()).getCourseFolderId();
        String courseParentDisplay = MessageFormat.format("{0} ({1})", courseTitle, courseId);
        String folderDisplay = this.toolConfig.getEnvDisplayPrefix() + courseParentDisplay + ": GROUP FILES";
        File groupsFolder = this.findFolder(folderDisplay, courseFolderId);
        if (groupsFolder == null) {
            File metadata = new File();
            metadata.setName(folderDisplay);
            metadata.setMimeType("application/vnd.google-apps.folder");
            metadata.setParents(Collections.singletonList(courseFolderId));
            metadata.setDescription("Parent folder for Canvas Group folders " + courseParentDisplay + ". This folder was created by the Google Course Tools app for Canvas.");
            metadata.setWritersCanShare(Boolean.valueOf(false));
            groupsFolder = (File)this.driveService.files().create(metadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
        }
        log.info("Groups files folder: {}", (Object)groupsFolder);
        Permission folderPermission = new Permission();
        folderPermission.setType(Constants.PERMISSION_TYPE.group.name());
        folderPermission.setRole(Constants.PERMISSION_ROLES.writer.name());
        folderPermission.setEmailAddress(teacherGroupEmail);
        Permission permission = (Permission)this.driveService.permissions().create(groupsFolder.getId(), folderPermission).setSendNotificationEmail(Boolean.valueOf(false)).execute();
        log.info("Groups files folder permission: {}", (Object)permission);
        List courseGroups = this.getCanvasGroupsForCourse(courseId);
        this.createCanvasGroupFolders(groupsFolder.getId(), courseId, allGroupEmail, teacherGroupEmail, courseGroups);
        return groupsFolder;
    }

    public void createCanvasGroupFolders(String parentFolderId, String courseId, String allGroupEmail, String teacherGroupEmail, List<CourseGroup> courseGroups) throws IOException {
        for (CourseGroup cg : courseGroups) {
            Group group = this.createGroupForCanvasGroup(cg);
            List groupUsers = this.groupService.getUsersInGroup(cg.getId(), true);
            List userEmails = groupUsers.stream().map(User::getLoginId).map(arg_0 -> this.loginToEmail(arg_0)).collect(Collectors.toList());
            this.addMembersToGroup(this.getEmailForCourseGroup(cg), userEmails, Constants.GROUP_ROLES.MEMBER);
            List teacherMembers = this.getMembersOfGroup(teacherGroupEmail);
            List teacherEmails = teacherMembers.stream().map(Member::getEmail).collect(Collectors.toList());
            this.addMembersToGroup(this.getEmailForCourseGroup(cg), teacherEmails, Constants.GROUP_ROLES.MANAGER);
            this.createCanvasGroupFolder(parentFolderId, cg, allGroupEmail);
        }
    }

    public String getEmailForCourseGroup(CourseGroup courseGroup) {
        return this.getEmailForCourseGroup(courseGroup.getCourseId(), courseGroup.getId());
    }

    public String getEmailForCourseGroup(String courseId, String groupId) {
        return MessageFormat.format("{0}{1}-{2}-iu-group@iu.edu", this.toolConfig.getEnvDisplayPrefix(), courseId, groupId);
    }

    private void createCanvasGroupFolder(String parentFolderId, CourseGroup courseGroup, String allGroupEmail) throws IOException {
        String courseParentDisplay = MessageFormat.format("{0}-{1}-{2}", courseGroup.getName(), courseGroup.getCourseId(), courseGroup.getId());
        String folderDisplay = this.toolConfig.getEnvDisplayPrefix() + courseParentDisplay + " Files";
        GroupsInit groupsInit = this.groupsInitRepository.findByCanvasCourseIdAndCanvasGroupIdAndEnv(courseGroup.getCourseId(), courseGroup.getId(), this.toolConfig.getEnv());
        if (groupsInit == null) {
            File groupFolder = this.findFolder(folderDisplay, parentFolderId);
            if (groupFolder == null) {
                File metadata = new File();
                metadata.setName(folderDisplay);
                metadata.setMimeType("application/vnd.google-apps.folder");
                metadata.setParents(Collections.singletonList(parentFolderId));
                metadata.setDescription("Folder for members of Canvas group " + courseParentDisplay + ". This folder was created by the Google Course Tools app for Canvas.");
                metadata.setWritersCanShare(Boolean.valueOf(false));
                groupFolder = (File)this.driveService.files().create(metadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
            }
            log.info("Group files folder: {}", (Object)groupFolder);
            this.deleteFolderPermission(groupFolder.getId(), allGroupEmail);
            Permission folderPermission = new Permission();
            folderPermission.setType(Constants.PERMISSION_TYPE.group.name());
            folderPermission.setRole(Constants.PERMISSION_ROLES.writer.name());
            folderPermission.setEmailAddress(this.getEmailForCourseGroup(courseGroup));
            Permission permission = (Permission)this.driveService.permissions().create(groupFolder.getId(), folderPermission).setSendNotificationEmail(Boolean.valueOf(false)).execute();
            log.info("Group files folder permission: {}", (Object)permission);
            groupsInit = GroupsInit.builder().canvasCourseId(courseGroup.getCourseId()).canvasGroupId(courseGroup.getId()).folderId(groupFolder.getId()).env(this.toolConfig.getEnv()).build();
            this.groupsInitRepository.save((Object)groupsInit);
        }
    }

    public File createDropboxFolder(String courseId, String courseTitle) throws IOException {
        String courseFolderId = this.courseInitRepository.findByCourseIdAndEnv(courseId, this.toolConfig.getEnv()).getCourseFolderId();
        String courseParentDisplay = MessageFormat.format("{0} ({1})", courseTitle, courseId);
        String courseDisplay = this.toolConfig.getEnvDisplayPrefix() + courseParentDisplay + ": DROP BOXES";
        File dropBoxFolder = this.findFolder(courseDisplay, courseFolderId);
        if (dropBoxFolder == null) {
            File gctCourseMetadata = new File();
            gctCourseMetadata.setName(courseDisplay);
            gctCourseMetadata.setMimeType("application/vnd.google-apps.folder");
            gctCourseMetadata.setParents(Collections.singletonList(courseFolderId));
            gctCourseMetadata.setDescription("Parent folder for student drop boxes in " + courseParentDisplay + ". This folder was created by the Google Course Tools app for Canvas.");
            gctCourseMetadata.setWritersCanShare(Boolean.valueOf(false));
            dropBoxFolder = (File)this.driveService.files().create(gctCourseMetadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
        }
        log.info("Drop box folder: {}", (Object)dropBoxFolder);
        return dropBoxFolder;
    }

    public void createStudentDropboxFolders(String courseId, String courseTitle, String dropboxFolderId, String allGroupEmail, String teacherGroupEmail) throws IOException {
        List students = this.courseService.getUsersForCourseByType(courseId, Collections.singletonList(EnrollmentHelper.TYPE.student.name()), Collections.singletonList(EnrollmentHelper.STATE.active.name()));
        for (User student : students) {
            DropboxInit dropboxInit = this.dropboxInitRepository.findByCourseIdAndLoginIdAndEnv(courseId, student.getLoginId(), this.toolConfig.getEnv());
            this.createStudentDropboxFolder(courseId, courseTitle, dropboxFolderId, student, allGroupEmail, teacherGroupEmail, dropboxInit);
        }
        this.sendDropboxNotification(courseId, courseTitle, dropboxFolderId);
    }

    private void sendDropboxNotification(String courseId, String courseTitle, String dropboxFolderId) throws IOException {
        List courseInstructors = this.courseService.getUsersForCourseByType(courseId, Collections.singletonList(EnrollmentHelper.TYPE.teacher.name()), null);
        String[] courseInstructorIds = (String[])courseInstructors.stream().map(User::getId).toArray(String[]::new);
        String courseLink = MessageFormat.format("{0}/courses/{1}", this.canvasService.getBaseUrl(), courseId);
        File dbFolder = (File)this.driveService.files().get(dropboxFolderId).setFields("id,webViewLink").execute();
        String dbLink = dbFolder.getWebViewLink();
        HashMap<String, String> emailModel = new HashMap<String, String>();
        emailModel.put("courseTitle", courseTitle);
        emailModel.put("courseLink", courseLink);
        emailModel.put("dropboxFolderLink", dbLink);
        ConversationCreateWrapper wrapper = new ConversationCreateWrapper();
        wrapper.setRecipients(courseInstructorIds);
        wrapper.setContextCode("course_" + courseId);
        wrapper.setGroupConversation(true);
        wrapper.setSubject("Your Google Course Tools Drop Boxes are ready");
        this.sendNotification("dropbox.ftlh", emailModel, wrapper);
    }

    public void sendCourseSetupNotification(CourseInit courseInit, NotificationData notificationData) {
        String courseId = courseInit.getCourseId();
        List courseInstructors = this.courseService.getUsersForCourseByType(courseId, Collections.singletonList(EnrollmentHelper.TYPE.teacher.name()), null);
        String[] courseInstructorIds = (String[])courseInstructors.stream().map(User::getId).toArray(String[]::new);
        HashMap<String, NotificationData> emailModel = new HashMap<String, NotificationData>();
        emailModel.put("notificationData", notificationData);
        ConversationCreateWrapper wrapper = new ConversationCreateWrapper();
        wrapper.setRecipients(courseInstructorIds);
        wrapper.setContextCode("course_" + courseId);
        wrapper.setGroupConversation(true);
        wrapper.setSubject("Google Course Tools for " + notificationData.getCourseTitle());
        this.sendNotification("courseInitializationNotification.ftlh", emailModel, wrapper);
    }

    private void sendNotification(String templateName, Map<String, Object> emailModel, ConversationCreateWrapper wrapper) {
        try {
            Template freemarkerTemplate = this.freemarkerConfigurer.createConfiguration().getTemplate(templateName);
            String body = FreeMarkerTemplateUtils.processTemplateIntoString((Template)freemarkerTemplate, emailModel);
            wrapper.setBody(body);
            this.conversationService.postConversation(wrapper, null, false);
        }
        catch (TemplateException | IOException e) {
            log.error("Unable to send dropbox notification email", e);
        }
    }

    public DropboxInit createStudentDropboxFolder(String courseId, String courseTitle, String dropboxFolderId, String userLoginId, String allGroupEmail, String teacherGroupEmail, DropboxInit dropboxInit) throws IOException {
        User user = this.userService.getUserBySisLoginId(userLoginId);
        boolean created = this.createStudentDropboxFolder(courseId, courseTitle, dropboxFolderId, user, allGroupEmail, teacherGroupEmail, dropboxInit);
        return dropboxInit;
    }

    private boolean createStudentDropboxFolder(String courseId, String courseTitle, String dropboxFolderId, User student, String allGroupEmail, String teacherGroupEmail, DropboxInit dropboxInit) throws IOException {
        boolean userEligible = this.verifyUserEligibility(student.getEmail(), student.getLoginId(), student.getSisUserId());
        if (dropboxInit == null && userEligible) {
            String folderTitlePattern = "{0} ({1}): {2} ({3})";
            String folderName = MessageFormat.format(this.toolConfig.getEnvDisplayPrefix() + folderTitlePattern, student.getSortableName(), student.getLoginId(), courseTitle, courseId);
            File dropBoxFolder = this.findFolder(folderName, dropboxFolderId);
            if (dropBoxFolder == null) {
                File gctCourseMetadata = new File();
                gctCourseMetadata.setName(folderName);
                gctCourseMetadata.setMimeType("application/vnd.google-apps.folder");
                gctCourseMetadata.setParents(Collections.singletonList(dropboxFolderId));
                gctCourseMetadata.setDescription("Student drop box folder. This folder was created by the Google Course Tools app for Canvas.");
                gctCourseMetadata.setWritersCanShare(Boolean.valueOf(false));
                dropBoxFolder = (File)this.driveService.files().create(gctCourseMetadata).setFields("id").execute();
            }
            if (dropBoxFolder != null && dropBoxFolder.getId() != null) {
                String createdFolderId = dropBoxFolder.getId();
                String loginId = student.getLoginId();
                String studentEmail = loginId + "@iu.edu";
                log.info("Created dropbox folder for " + loginId + " and course " + courseId);
                log.info(teacherGroupEmail);
                log.info(allGroupEmail);
                this.deleteFolderPermission(createdFolderId, allGroupEmail);
                Permission studentPerm = new Permission();
                studentPerm.setType(Constants.PERMISSION_TYPE.user.name());
                studentPerm.setRole(Constants.PERMISSION_ROLES.writer.name());
                studentPerm.setEmailAddress(studentEmail);
                Permission studPermission = this.addOrReturnPermission(createdFolderId, studentPerm);
                Permission teacherPerm = new Permission();
                teacherPerm.setType(Constants.PERMISSION_TYPE.group.name());
                teacherPerm.setRole(Constants.PERMISSION_ROLES.writer.name());
                teacherPerm.setEmailAddress(teacherGroupEmail);
                Permission teachPermission = this.addOrReturnPermission(createdFolderId, teacherPerm);
                dropboxInit = DropboxInit.builder().loginId(loginId).googleLoginId(studentEmail).courseId(courseId).folderId(createdFolderId).env(this.toolConfig.getEnv()).build();
                this.dropboxInitRepository.save((Object)dropboxInit);
                return true;
            }
        }
        return false;
    }

    private Permission addOrReturnPermission(String folderId, Permission permission) throws IOException {
        PermissionList permissionList = (PermissionList)this.driveService.permissions().list(folderId).setFields("permissions/id, permissions/emailAddress, permissions/type, permissions/role").execute();
        for (Permission existingPermission : permissionList.getPermissions()) {
            if (!existingPermission.getEmailAddress().toLowerCase().equals(permission.getEmailAddress()) || !existingPermission.getType().equals(permission.getType()) || !existingPermission.getRole().equals(permission.getRole())) continue;
            return existingPermission;
        }
        Permission createdPermission = (Permission)this.driveService.permissions().create(folderId, permission).setSendNotificationEmail(Boolean.valueOf(false)).execute();
        return createdPermission;
    }

    private File findFolder(String folderName, String parentId) throws IOException {
        String query = MessageFormat.format("name = ''{0}'' and parents in ''{1}'' and mimeType = ''{2}''", this.escapeQueryValues(folderName), parentId, "application/vnd.google-apps.folder");
        FileList fileList = (FileList)this.driveService.files().list().setQ(query).setOrderBy("createdTime").execute();
        if (fileList != null && fileList.getFiles() != null && fileList.getFiles().size() > 0) {
            log.warn("At least one folder returned for this name (" + folderName + ") in the folder with id '" + parentId + "'. Using the earliest one created.");
            return (File)fileList.getFiles().get(0);
        }
        return null;
    }

    public static boolean isFolder(File file) {
        return "application/vnd.google-apps.folder".equals(file.getMimeType());
    }

    public File getFolder(String folderId) throws IOException {
        return (File)this.driveService.files().get(folderId).setFields("id,name,description,webViewLink").execute();
    }

    private void deleteFolder(String folderId) throws IOException {
        this.driveService.files().delete(folderId).execute();
    }

    public List<File> getFiles(String[] fileIds, String asUser) throws IOException {
        String userEmail = this.loginToEmail(asUser);
        ArrayList<File> files = new ArrayList<File>();
        Drive localDriveService = this.driveService;
        if (asUser != null) {
            localDriveService = this.self.getDriveServiceAsUser(userEmail);
        }
        for (String fileId : fileIds) {
            File file = (File)localDriveService.files().get(fileId).setFields("id,name,kind,mimeType,permissions,iconLink").execute();
            files.add(file);
        }
        return files;
    }

    public File createFileRepositoryFolder(String courseId, String courseTitle, String allGroupEmail) throws IOException {
        String courseFolderId = this.courseInitRepository.findByCourseIdAndEnv(courseId, this.toolConfig.getEnv()).getCourseFolderId();
        String courseParentDisplay = MessageFormat.format("{0} ({1})", courseTitle, courseId);
        String courseDisplay = this.toolConfig.getEnvDisplayPrefix() + courseParentDisplay + ": FILE REPOSITORY";
        File fileRepositoryFolder = this.findFolder(courseDisplay, courseFolderId);
        if (fileRepositoryFolder == null) {
            File gctCourseMetadata = new File();
            gctCourseMetadata.setName(courseDisplay);
            gctCourseMetadata.setMimeType("application/vnd.google-apps.folder");
            gctCourseMetadata.setParents(Collections.singletonList(courseFolderId));
            gctCourseMetadata.setDescription("Folder for files and folders shared by class members. This folder was created by the Google Course Tools app for Canvas.");
            gctCourseMetadata.setWritersCanShare(Boolean.valueOf(false));
            fileRepositoryFolder = (File)this.driveService.files().create(gctCourseMetadata).setEnforceSingleParent(Boolean.valueOf(true)).execute();
        }
        log.info("File repository folder: {}", (Object)fileRepositoryFolder);
        this.deleteFolderPermission(fileRepositoryFolder.getId(), allGroupEmail);
        Permission folderPermission = new Permission();
        folderPermission.setType(Constants.PERMISSION_TYPE.group.name());
        folderPermission.setRole(Constants.PERMISSION_ROLES.writer.name());
        folderPermission.setEmailAddress(allGroupEmail);
        Permission permission = (Permission)this.driveService.permissions().create(fileRepositoryFolder.getId(), folderPermission).setSendNotificationEmail(Boolean.valueOf(false)).execute();
        log.info("File repository folder permission: {}", (Object)permission);
        return fileRepositoryFolder;
    }

    private void deleteFolderPermission(String folderId, String emailToDelete) throws IOException {
        PermissionList permissionList = (PermissionList)this.driveService.permissions().list(folderId).setFields("permissions/id, permissions/emailAddress, permissions/type, permissions/role").execute();
        for (Permission existingPermission : permissionList.getPermissions()) {
            if (!existingPermission.getEmailAddress().toLowerCase().contains(emailToDelete)) continue;
            this.driveService.permissions().delete(folderId, existingPermission.getId()).execute();
        }
    }

    public boolean verifyUserEligibility(String email, String loginId, String sisUserId) {
        String calculatedEmail = this.loginToEmail(loginId);
        boolean validEmail = email != null && loginId != null && email.equalsIgnoreCase(calculatedEmail);
        boolean validSisId = sisUserId != null && sisUserId.length() == 10 && (sisUserId.startsWith("0") || sisUserId.startsWith("2"));
        return validEmail || validSisId;
    }

    public UserInit userInitialization(String courseId, String loginId, CourseInit courseInit, String courseTitle, boolean isInstructor, boolean isTa, boolean isDesigner) {
        String userEmail = this.loginToEmail(loginId);
        try {
            UserInit ui;
            CourseGroupWrapper groups = this.getOrCreateGroupsForCourse(courseId, courseTitle, courseInit);
            String teacherGroupEmail = groups.getTeacherGroup().getEmail();
            String allGroupEmail = groups.getAllGroup().getEmail();
            boolean addToCanvasGroupAsManager = false;
            boolean removeFromCanvasGroupAsManager = false;
            if (isInstructor) {
                allMember = this.addMemberToGroup(allGroupEmail, userEmail, Constants.GROUP_ROLES.MANAGER);
                log.info("All Membership details: {}", (Object)allMember);
                teacherMember = this.addMemberToGroup(teacherGroupEmail, userEmail, Constants.GROUP_ROLES.MANAGER);
                log.info("Teacher Membership details: {}", (Object)teacherMember);
                addToCanvasGroupAsManager = true;
            } else {
                allMember = this.addMemberToGroup(allGroupEmail, userEmail, Constants.GROUP_ROLES.MEMBER);
                log.info("All Membership details: {}", (Object)allMember);
                if (isTa) {
                    if (courseInit.isTaTeacher()) {
                        teacherMember = this.addMemberToGroup(teacherGroupEmail, userEmail, Constants.GROUP_ROLES.MEMBER);
                        log.info("Teacher Membership details: {}", (Object)teacherMember);
                        addToCanvasGroupAsManager = true;
                    } else {
                        this.removeMemberFromGroup(teacherGroupEmail, userEmail);
                        removeFromCanvasGroupAsManager = true;
                    }
                } else if (isDesigner) {
                    if (courseInit.isDeTeacher()) {
                        teacherMember = this.addMemberToGroup(teacherGroupEmail, userEmail, Constants.GROUP_ROLES.MEMBER);
                        log.info("Teacher Membership details: {}", (Object)teacherMember);
                        addToCanvasGroupAsManager = true;
                    } else {
                        this.removeMemberFromGroup(teacherGroupEmail, userEmail);
                        removeFromCanvasGroupAsManager = true;
                    }
                }
            }
            if (courseInit.getGroupsFolderId() != null) {
                boolean finalAddToCanvasGroupAsManager = addToCanvasGroupAsManager;
                boolean finalRemoveFromCanvasGroupAsManager = removeFromCanvasGroupAsManager;
                Runnable groupsFoldersRosterSyncRunnable = () -> {
                    long threadId = Thread.currentThread().getId();
                    try {
                        List canvasCourseGroups = this.getCanvasGroupsForCourse(courseId);
                        this.syncCanvasAndGoogleGroups(canvasCourseGroups, loginId);
                        for (CourseGroup canvasGroup : canvasCourseGroups) {
                            String groupEmail = this.getEmailForCourseGroup(canvasGroup);
                            if (finalAddToCanvasGroupAsManager) {
                                Member member = this.addMemberToGroup(groupEmail, userEmail, Constants.GROUP_ROLES.MANAGER);
                                log.info("Canvas Group {} Membership details: {}", (Object)groupEmail, (Object)member);
                            }
                            if (!finalRemoveFromCanvasGroupAsManager) continue;
                            this.removeMemberFromGroup(groupEmail, userEmail);
                        }
                        this.createCanvasGroupFolders(courseInit.getGroupsFolderId(), courseId, allGroupEmail, teacherGroupEmail, canvasCourseGroups);
                    }
                    catch (IOException e) {
                        log.error("Error in group/sync thread", (Throwable)e);
                    }
                    log.debug("*** thread(" + threadId + ") work done");
                };
                new Thread(groupsFoldersRosterSyncRunnable).start();
            }
            if ((ui = this.userInitRepository.findByLoginIdAndEnv(loginId, this.toolConfig.getEnv())) == null) {
                File userRootFolder = this.createUserRootFolder(userEmail, loginId);
                ui = UserInit.builder().loginId(loginId).folderId(userRootFolder.getId()).googleLoginId(userEmail).env(this.toolConfig.getEnv()).build();
                this.userInitRepository.save((Object)ui);
            }
            this.addShortcut(courseInit.getCourseFolderId(), ui.getFolderId(), null);
            return ui;
        }
        catch (IOException e) {
            log.error("Error with user initialization", (Throwable)e);
            return null;
        }
    }

    public void rosterSyncBatch() {
        ArrayList<String> successes = new ArrayList<String>();
        ArrayList<Object> errors = new ArrayList<Object>();
        ArrayList<String> inactivated = new ArrayList<String>();
        List courses = this.courseInitRepository.findBySyncStatusAndEnvOrderByCourseId(CourseInit.SYNC_STATUS.ACTIVE, this.toolConfig.getEnv());
        int numCourses = courses.size();
        int counter = 0;
        for (CourseInit courseInit : courses) {
            String courseId = courseInit.getCourseId();
            log.info("Processing {} ({}/{})", new Object[]{courseId, ++counter, numCourses});
            Course course = this.courseService.getCourse(courseId);
            if (course != null && course.getCourseCode() != null && course.getCourseCode().equals(courseInit.getCourseCode())) {
                String courseDisplay = MessageFormat.format("{0} ({1})", course.getName(), courseId);
                try {
                    CourseGroupWrapper groups = this.getOrCreateGroupsForCourse(courseId, course.getName(), courseInit);
                    String allGroupEmail = groups.getAllGroup().getEmail();
                    String teacherGroupEmail = groups.getTeacherGroup().getEmail();
                    RosterSyncCourseData data = new RosterSyncCourseData(courseId, course.getName(), allGroupEmail, teacherGroupEmail);
                    RetryTemplate retry = new RetryTemplate();
                    retry.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(3, Collections.singletonMap(IOException.class, true)));
                    retry.setBackOffPolicy((BackOffPolicy)new ExponentialBackOffPolicy());
                    retry.execute(retryContext -> {
                        log.debug("Roster Sync for {} #{}", (Object)courseDisplay, (Object)retryContext.getRetryCount());
                        this.rosterSync(data, false);
                        return null;
                    });
                    boolean isCourseLocked = CourseHelper.isLocked((Course)course, (boolean)false);
                    if (isCourseLocked) {
                        courseInit.setSyncStatus(CourseInit.SYNC_STATUS.INACTIVE);
                        this.courseInitRepository.save((Object)courseInit);
                        inactivated.add(courseDisplay);
                    }
                    successes.add(courseDisplay);
                }
                catch (IOException e) {
                    log.error("Error performing roster sync for courseInit: " + courseInit.getId(), (Throwable)e);
                    errors.add(courseDisplay);
                }
                continue;
            }
            log.warn("{} is not a legit canvas course in this environment", (Object)courseId);
            errors.add(courseId + " is not a legit canvas course in this environment");
        }
        this.sendBatchNotificationForRosterSync(successes, errors, inactivated);
    }

    private void syncCanvasAndGoogleGroups(List<CourseGroup> canvasCourseGroups, String userLoginToSync) throws IOException {
        log.debug("syncCanvasAndGoogleGroups() for {}", (Object)userLoginToSync);
        for (CourseGroup cg : canvasCourseGroups) {
            Group canvasGroup = this.createGroupForCanvasGroup(cg);
            log.debug("{}", (Object)canvasGroup.getEmail());
            List groupUsers = this.groupService.getUsersInGroup(cg.getId(), true);
            List userEmails = groupUsers.stream().map(User::getLoginId).filter(userLoginToSync::equals).map(arg_0 -> this.loginToEmail(arg_0)).collect(Collectors.toList());
            List groupMembers = this.getMembersOfGroup(canvasGroup.getEmail()).stream().filter(m -> m.getRole().equals(Constants.GROUP_ROLES.MEMBER.name())).map(Member::getEmail).filter(email -> email.equals(this.loginToEmail(userLoginToSync))).collect(Collectors.toList());
            List toRemove = (List)CollectionUtils.removeAll(groupMembers, userEmails);
            log.debug("Canvas group ({}) roster: {}", (Object)canvasGroup.getEmail(), userEmails);
            log.debug("Google group ({}) roster: {}", (Object)canvasGroup.getEmail(), groupMembers);
            log.debug("Users to be removed: {}", (Object)toRemove);
            List toAdd = (List)CollectionUtils.removeAll(userEmails, groupMembers);
            for (String userToRemove : toRemove) {
                this.removeMemberFromGroup(canvasGroup.getEmail(), userToRemove);
            }
            log.debug("Users to be added: {}", (Object)toAdd);
            this.addMembersToGroup(canvasGroup.getEmail(), toAdd, Constants.GROUP_ROLES.MEMBER);
        }
    }

    public List<CourseGroup> getCanvasGroupsForCourse(String courseId) {
        return this.groupService.getGroupsForCourse(courseId);
    }

    public void rosterSync(RosterSyncCourseData courseDetail, boolean sendNotificationForCourse) throws IOException {
        log.debug("Roster sync for course: {} ({})", (Object)courseDetail.getCourseTitle(), (Object)courseDetail.getCourseId());
        List users = this.courseService.getUsersForCourseByTypeOptionalEnrollments(courseDetail.getCourseId(), null, Collections.singletonList(EnrollmentHelper.STATE.active.name()), true);
        CourseInit courseInit = this.getCourseInit(courseDetail.getCourseId());
        this.createCourseGroups(courseDetail.getCourseId(), courseDetail.getCourseTitle(), courseInit.getMailingListAddress() != null);
        ArrayList<String> canvasGroupEmails = new ArrayList<String>();
        if (courseInit.getGroupsFolderId() != null) {
            List canvasCourseGroups = this.getCanvasGroupsForCourse(courseDetail.getCourseId());
            for (Object cg : canvasCourseGroups) {
                Group canvasGroup = this.createGroupForCanvasGroup((CourseGroup)cg);
                log.debug("Syncing canvas group {}...", (Object)canvasGroup.getEmail());
                List groupUsers = this.groupService.getUsersInGroup(cg.getId(), true);
                List userEmails = groupUsers.stream().map(User::getLoginId).map(arg_0 -> this.loginToEmail(arg_0)).collect(Collectors.toList());
                canvasGroupEmails.add(canvasGroup.getEmail().toLowerCase());
                List groupMembers = this.getMembersOfGroup(canvasGroup.getEmail()).stream().filter(m -> m.getRole().equals(Constants.GROUP_ROLES.MEMBER.name())).map(Member::getEmail).collect(Collectors.toList());
                List toRemove = (List)CollectionUtils.removeAll(groupMembers, userEmails);
                toRemove.removeIf(email -> !email.endsWith("@iu.edu"));
                log.debug("Canvas group ({}) roster: {}", (Object)canvasGroup.getEmail(), userEmails);
                log.debug("Google group ({}) roster: {}", (Object)canvasGroup.getEmail(), groupMembers);
                log.debug("Users to be removed: {}", (Object)toRemove);
                List toAdd = (List)CollectionUtils.removeAll(userEmails, groupMembers);
                Iterator iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    String userToRemove = (String)iterator.next();
                    this.removeMemberFromGroup(canvasGroup.getEmail(), userToRemove);
                }
                log.debug("Users to be added: {}", (Object)toAdd);
                this.addMembersToGroup(canvasGroup.getEmail(), toAdd, Constants.GROUP_ROLES.MEMBER);
            }
            List groupsInits = this.groupsInitRepository.findByCanvasCourseIdAndEnv(courseDetail.getCourseId(), this.toolConfig.getEnv());
            for (GroupsInit gi : groupsInits) {
                String groupEmail = this.getEmailForCourseGroup(gi.getCanvasCourseId(), gi.getCanvasGroupId());
                if (canvasGroupEmails.contains(groupEmail.toLowerCase())) continue;
                List groupMembers = new ArrayList();
                try {
                    groupMembers = this.getMembersOfGroup(groupEmail);
                }
                catch (IOException e) {
                    log.warn("Unable to get members of {} Group", (Object)groupEmail);
                }
                List membersOfGroup = groupMembers.stream().map(Member::getEmail).collect(Collectors.toList());
                log.debug("Removing {} members of the {} group since it no longer exists in Canvas", (Object)membersOfGroup.size(), (Object)groupEmail);
                for (String toRemove : membersOfGroup) {
                    log.debug("Removing {} from {}", (Object)toRemove, (Object)groupEmail);
                    this.removeMemberFromGroup(groupEmail, toRemove);
                }
            }
        }
        File courseFolder = this.getFolder(courseInit.getCourseFolderId());
        List decoratedCanvasUsers = users.stream().filter(u -> this.verifyUserEligibility(u.getEmail(), u.getLoginId(), u.getSisUserId())).map(DecoratedCanvasUser::new).collect(Collectors.toList());
        Map userMap = decoratedCanvasUsers.stream().collect(Collectors.toMap(DecoratedCanvasUser::getEmail, Function.identity()));
        log.debug("User Map: {}", userMap);
        Set<String> courseEmails = userMap.keySet();
        log.debug("Users (email): {}", courseEmails);
        List allGroupMembers = this.getMembersOfGroup(courseDetail.getAllGroupEmail());
        List allGroupEmails = allGroupMembers.stream().map(Member::getEmail).collect(Collectors.toList());
        List teacherGroupMembers = this.getMembersOfGroup(courseDetail.getTeacherGroupEmail());
        List teacherGroupEmails = teacherGroupMembers.stream().map(Member::getEmail).collect(Collectors.toList());
        log.debug("Users in ALL: {}", allGroupEmails);
        log.debug("Users in TEACHER: {}", teacherGroupEmails);
        List toRemoveFromAll = (List)CollectionUtils.removeAll(allGroupEmails, courseEmails);
        toRemoveFromAll.removeIf(email -> !email.endsWith("@iu.edu"));
        log.debug("Users to remove from ALL: {}", (Object)toRemoveFromAll);
        List missingFromAll = (List)CollectionUtils.removeAll(courseEmails, allGroupEmails);
        log.debug("Users missing from ALL: {}", (Object)missingFromAll);
        HashMap<String, UserInit> userInitMap = new HashMap<String, UserInit>();
        for (String userEmail : toRemoveFromAll) {
            DropboxInit dropboxInit;
            File shortcut;
            this.removeMemberFromGroup(courseDetail.getAllGroupEmail(), userEmail);
            UserInit userInit = userInitMap.computeIfAbsent(userEmail, key -> this.userInitRepository.findByGoogleLoginIdAndEnv(key, this.toolConfig.getEnv()));
            if (userInit != null && (shortcut = this.findShortcutForTarget(courseFolder.getName(), courseFolder.getId(), userInit.getFolderId(), null)) != null) {
                this.deleteFolder(shortcut.getId());
            }
            if (courseInit.getDropboxFolderId() == null || (dropboxInit = this.getDropboxInitByGoogleLogin(courseDetail.getCourseId(), userEmail)) == null) continue;
            this.deleteFolderPermission(dropboxInit.getFolderId(), userEmail);
        }
        for (String userEmail : missingFromAll) {
            DropboxInit dropboxInit;
            DecoratedCanvasUser decoratedCanvasUser = (DecoratedCanvasUser)userMap.get(userEmail);
            Constants.GROUP_ROLES groupRole = decoratedCanvasUser.isTeacher() ? Constants.GROUP_ROLES.MANAGER : Constants.GROUP_ROLES.MEMBER;
            this.addMemberToGroup(courseDetail.getAllGroupEmail(), userEmail, groupRole);
            if (!decoratedCanvasUser.isStudent() || courseInit.getDropboxFolderId() == null || (dropboxInit = this.getDropboxInit(courseDetail.getCourseId(), decoratedCanvasUser.getLoginId())) != null) continue;
            dropboxInit = this.createStudentDropboxFolder(courseDetail.getCourseId(), courseDetail.getCourseTitle(), courseInit.getDropboxFolderId(), decoratedCanvasUser.getLoginId(), courseDetail.getAllGroupEmail(), courseDetail.getTeacherGroupEmail(), dropboxInit);
        }
        List toRemoveFromTeachers = (List)CollectionUtils.removeAll(teacherGroupEmails, courseEmails);
        toRemoveFromTeachers.removeIf(email -> !email.endsWith("@iu.edu"));
        List moreUsersToRemoveFromTeachers = decoratedCanvasUsers.stream().filter(dcu -> teacherGroupEmails.contains(dcu.getEmail()) && !dcu.isTeacher() && (!courseInit.isDeTeacher() && dcu.isDesigner() || !courseInit.isTaTeacher() && dcu.isTa())).map(DecoratedCanvasUser::getEmail).collect(Collectors.toList());
        toRemoveFromTeachers.addAll(moreUsersToRemoveFromTeachers);
        log.debug("Users to remove from TEACHER: {}", (Object)toRemoveFromTeachers);
        List filteredCourseInstructors = decoratedCanvasUsers.stream().filter(dcu -> dcu.isTeacher() || courseInit.isDeTeacher() && dcu.isDesigner() || courseInit.isTaTeacher() && dcu.isTa()).map(DecoratedCanvasUser::getEmail).collect(Collectors.toList());
        log.debug("Filtered Instructor types: {}", filteredCourseInstructors);
        List missingFromTeachers = (List)CollectionUtils.removeAll(filteredCourseInstructors, teacherGroupEmails);
        log.debug("Users missing from TEACHER: {}", (Object)missingFromTeachers);
        for (String userEmail : toRemoveFromTeachers) {
            this.removeMemberFromGroup(courseDetail.getTeacherGroupEmail(), userEmail);
            for (String canvasGroupEmail : canvasGroupEmails) {
                this.removeMemberFromGroup(canvasGroupEmail, userEmail);
            }
        }
        for (String userEmail : missingFromTeachers) {
            Constants.GROUP_ROLES groupRole;
            DecoratedCanvasUser dcu2 = (DecoratedCanvasUser)userMap.get(userEmail);
            Constants.GROUP_ROLES gROUP_ROLES = groupRole = dcu2.isTeacher() ? Constants.GROUP_ROLES.MANAGER : Constants.GROUP_ROLES.MEMBER;
            if (!dcu2.isTeacher() && (!dcu2.isDesigner() || !courseInit.isDeTeacher()) && (!dcu2.isTa() || !courseInit.isTaTeacher())) continue;
            this.addMemberToGroup(courseDetail.getTeacherGroupEmail(), userEmail, groupRole);
            for (String canvasGroupEmail : canvasGroupEmails) {
                this.addMemberToGroup(canvasGroupEmail, userEmail, Constants.GROUP_ROLES.MANAGER);
            }
        }
        if (sendNotificationForCourse) {
            this.sendRosterSyncNotification(courseDetail.getCourseId(), courseDetail.getCourseTitle());
        }
    }

    private void sendRosterSyncNotification(String courseId, String courseTitle) {
        List courseInstructors = this.courseService.getUsersForCourseByType(courseId, Collections.singletonList(EnrollmentHelper.TYPE.teacher.name()), null);
        String[] courseInstructorIds = (String[])courseInstructors.stream().map(User::getId).toArray(String[]::new);
        String courseLink = MessageFormat.format("{0}/courses/{1}", this.canvasService.getBaseUrl(), courseId);
        HashMap<String, String> emailModel = new HashMap<String, String>();
        emailModel.put("courseTitle", courseTitle);
        emailModel.put("courseLink", courseLink);
        ConversationCreateWrapper wrapper = new ConversationCreateWrapper();
        wrapper.setRecipients(courseInstructorIds);
        wrapper.setContextCode("course_" + courseId);
        wrapper.setGroupConversation(true);
        wrapper.setSubject("Google Course Tools Roster Sync Completed");
        this.sendNotification("courseRosterSync.ftlh", emailModel, wrapper);
    }

    private void sendBatchNotificationForRosterSync(List<String> successes, List<String> errors, List<String> inactivated) {
        HashMap<String, Object> emailModel = new HashMap<String, Object>();
        Date runDate = new Date();
        emailModel.put("runTime", runDate);
        emailModel.put("env", this.toolConfig.getEnv());
        emailModel.put("successes", successes);
        emailModel.put("errors", errors);
        emailModel.put("inactivated", inactivated);
        try {
            Template freemarkerTemplate = this.freemarkerConfigurer.createConfiguration().getTemplate("batchRosterSync.ftlh");
            String body = FreeMarkerTemplateUtils.processTemplateIntoString((Template)freemarkerTemplate, emailModel);
            EmailDetails details = new EmailDetails();
            details.setRecipients(new String[]{this.toolConfig.getBatchNotificationEmail()});
            details.setSubject(this.emailService.getStandardHeader() + " GCT Roster Sync");
            details.setBody(body);
            this.emailService.sendEmail(details);
        }
        catch (LmsEmailTooBigException | TemplateException | IOException | MessagingException e) {
            log.error("Unable to send batch roster sync email", e);
        }
    }

    public String buildGroupUrlFromEmail(String groupEmail, boolean includeSettingsPath) {
        Object groupUrlTemplate = "https://groups.google.com/a/iu.edu/g/{0}";
        if (includeSettingsPath) {
            groupUrlTemplate = (String)groupUrlTemplate + "/settings";
        }
        String groupIdentifier = groupEmail.substring(0, groupEmail.indexOf("@"));
        return MessageFormat.format((String)groupUrlTemplate, groupIdentifier);
    }

    public String authWrapUrl(String url) {
        String googleAuthUrlTemplate = this.toolConfig.getGoogleAuthUrlTemplate();
        return MessageFormat.format(googleAuthUrlTemplate, url);
    }

    private String stripProtocol(String inputPath) {
        return inputPath.replace("file:", "");
    }
}

