/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.config;

import java.util.concurrent.TimeUnit;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Profile(value={"ehcache"})
@Configuration
@EnableCaching
public class CanvasEhCacheConfig {
    private static final Logger log = LoggerFactory.getLogger(CanvasEhCacheConfig.class);

    @Bean(name={"CanvasServicesCacheManager"})
    public CacheManager canvasCacheManager() {
        log.debug("canvasCacheManager() init");
        int ttl = 3600;
        int courseServiceTtl = 300;
        MutableConfiguration mutableLongConfiguration = new MutableConfiguration().setTypes(Object.class, Object.class).setStoreByValue(false).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 3600L))).setManagementEnabled(true).setStatisticsEnabled(true);
        MutableConfiguration mutableMediumAccessedConfiguration = new MutableConfiguration().setTypes(Object.class, Object.class).setStoreByValue(false).setExpiryPolicyFactory(AccessedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, 300L))).setManagementEnabled(true).setStatisticsEnabled(true);
        CachingProvider provider = Caching.getCachingProvider((String)"org.ehcache.jsr107.EhcacheCachingProvider");
        javax.cache.CacheManager cacheManager = provider.getCacheManager();
        this.createCacheIfMissing(cacheManager, "EnrollmentTerms", (MutableConfiguration<Object, Object>)mutableMediumAccessedConfiguration);
        this.createCacheIfMissing(cacheManager, "parentAccounts", (MutableConfiguration<Object, Object>)mutableLongConfiguration);
        return new JCacheCacheManager(cacheManager);
    }

    private void createCacheIfMissing(javax.cache.CacheManager cacheManager, String cacheName, MutableConfiguration<Object, Object> cacheConfig) {
        if (cacheManager.getCache(cacheName, Object.class, Object.class) == null) {
            cacheManager.createCache(cacheName, cacheConfig);
        }
    }
}

