/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.config;

import edu.iu.uits.lms.canvas.config.CanvasConfiguration;
import edu.iu.uits.lms.canvas.security.CanvasTokenAuthorizationInterceptor;
import java.net.URI;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class CanvasEnvironmentConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CanvasEnvironmentConfiguration.class);
    @Autowired
    CanvasConfiguration canvasConfiguration;

    @Bean(name={"CanvasRestTemplate"})
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory()));
        restTemplate.getInterceptors().add(new CanvasTokenAuthorizationInterceptor(this.canvasConfiguration.getToken()));
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestWithBodyFactory());
        return restTemplate;
    }

    @Bean(name={"restTemplateNoBuffer"})
    public RestTemplate restTemplateNoBuffer() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setBufferRequestBody(false);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        restTemplate.getInterceptors().add(new CanvasTokenAuthorizationInterceptor(this.canvasConfiguration.getToken()));
        return restTemplate;
    }

    private static final class HttpComponentsClientHttpRequestWithBodyFactory
    extends HttpComponentsClientHttpRequestFactory {
        private HttpComponentsClientHttpRequestWithBodyFactory() {
        }

        protected HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
            if (httpMethod == HttpMethod.GET) {
                return new HttpGetRequestWithEntity(uri);
            }
            return super.createHttpUriRequest(httpMethod, uri);
        }
    }

    private static final class HttpGetRequestWithEntity
    extends HttpEntityEnclosingRequestBase {
        public HttpGetRequestWithEntity(URI uri) {
            super.setURI(uri);
        }

        public String getMethod() {
            return HttpMethod.GET.name();
        }
    }
}

