/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.config;

import edu.iu.uits.lms.canvas.config.CanvasConfiguration;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

@Profile(value={"redis-cache"})
@Configuration
@EnableCaching
public class CanvasRedisCacheConfig {
    private static final Logger log = LoggerFactory.getLogger(CanvasRedisCacheConfig.class);
    @Autowired
    private CanvasConfiguration canvasConfiguration;
    @Autowired
    private JedisConnectionFactory redisConnectionFactory;

    @Bean
    public RedisCacheConfiguration cacheConfiguration() {
        int ttl = 300;
        return RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(300L)).disableCachingNullValues().prefixCacheNameWith(this.canvasConfiguration.getEnv() + "-canvasservices");
    }

    @Bean
    public RedisCacheConfiguration cacheLongConfiguration() {
        int ttl = 3600;
        return RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofSeconds(3600L)).disableCachingNullValues().prefixCacheNameWith(this.canvasConfiguration.getEnv() + "-canvasservices");
    }

    @Bean(name={"CanvasServicesCacheManager"})
    public CacheManager cacheManager() {
        log.debug("cacheManager()");
        log.debug("Redis hostname: {}", (Object)this.redisConnectionFactory.getHostName());
        return RedisCacheManager.builder((RedisConnectionFactory)this.redisConnectionFactory).withCacheConfiguration("EnrollmentTerms", this.cacheConfiguration()).withCacheConfiguration("parentAccounts", this.cacheLongConfiguration()).build();
    }
}

