/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.helpers;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanvasDateFormatUtil {
    private static final Logger log = LoggerFactory.getLogger(CanvasDateFormatUtil.class);
    public static final String CANVAS_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    public static final String CANVAS_DATE_ONLY_FORMAT = "yyyy-MM-dd";
    public static final String DISPLAY_FORMAT_WITH_TZ = "MMM d yyy h:mm:ss a z";
    public static final String DEFAULT_TIME_ZONE = "America/Indianapolis";

    public static Date string2Date(String dateString) {
        return CanvasDateFormatUtil.string2Date(dateString, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static Date string2Date(String dateString, DateTimeFormatter format) {
        if (dateString != null) {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateString, format);
            return Date.from(zonedDateTime.toInstant());
        }
        return null;
    }

    public static OffsetDateTime string2OffsetDateTime(String dateString) {
        return CanvasDateFormatUtil.string2OffsetDateTime(dateString, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static OffsetDateTime string2OffsetDateTime(String dateString, DateTimeFormatter format) {
        if (dateString != null) {
            return OffsetDateTime.parse(dateString, format);
        }
        return null;
    }

    public static Date string2DateOnly(String dateString) {
        if (dateString != null) {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateString, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            Instant withTime = Instant.from(zonedDateTime.toInstant());
            Instant withoutTime = withTime.truncatedTo(ChronoUnit.DAYS);
            return Date.from(withoutTime);
        }
        return null;
    }

    public static OffsetDateTime getAdjustedDate(int daysDiff) {
        OffsetDateTime adjustedDate = OffsetDateTime.now(ZoneOffset.UTC).plusDays(daysDiff);
        log.debug(daysDiff + " days adjusted from today: " + adjustedDate);
        return adjustedDate;
    }

    public static OffsetDateTime getCalculatedCourseEndDate() {
        OffsetDateTime adjustedZDT = OffsetDateTime.now(ZoneId.of(DEFAULT_TIME_ZONE)).withHour(23).withMinute(59).withSecond(0).withNano(0).plusYears(1L).minusDays(1L);
        log.debug("Yesterday, one year from now, at 11:59 pm Indy time: " + adjustedZDT);
        return adjustedZDT;
    }

    public static String formatISODateForDisplay(String isoDateString, String timeZone, String format) {
        String formattedDate = "";
        if (isoDateString != null) {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(isoDateString, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            formattedDate = CanvasDateFormatUtil.formatZDTForDisplay(zonedDateTime, timeZone, format);
        }
        return formattedDate;
    }

    public static String formatDateForDisplay(Date date, String timeZone, String format) {
        String formattedDate = "";
        if (date != null) {
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.of(DEFAULT_TIME_ZONE));
            formattedDate = CanvasDateFormatUtil.formatZDTForDisplay(zonedDateTime, timeZone, format);
        }
        return formattedDate;
    }

    public static String formatZDTForDisplay(ZonedDateTime zdt, String timeZone, String format) {
        String formattedDate = "";
        if (zdt != null) {
            ZoneId zoneId = ZoneId.of(DEFAULT_TIME_ZONE);
            if (timeZone != null && !timeZone.trim().isEmpty()) {
                zoneId = ZoneId.of(timeZone);
            }
            ZonedDateTime localized = zdt.withZoneSameInstant(zoneId);
            formattedDate = localized.format(DateTimeFormatter.ofPattern(format));
        }
        return formattedDate;
    }
}

