/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.helpers;

import edu.iu.uits.lms.canvas.helpers.CanvasDateFormatUtil;
import edu.iu.uits.lms.canvas.helpers.TermHelper;
import edu.iu.uits.lms.canvas.model.CanvasTerm;
import edu.iu.uits.lms.canvas.model.Course;
import java.time.OffsetDateTime;
import java.util.Date;

public class CourseHelper {
    public static boolean isLocked(Course course, boolean includeStartDate) {
        boolean locked = false;
        Date courseEndDate = CourseHelper.getEndDate(course);
        CanvasTerm term = course.getTerm();
        Date now = new Date();
        Date termEndDate = TermHelper.getEndDate(term);
        if (includeStartDate && CourseHelper.getStartDate(course) != null && now.before(CourseHelper.getStartDate(course))) {
            locked = true;
        } else if (termEndDate != null && now.after(termEndDate)) {
            if (courseEndDate == null || now.after(courseEndDate) || now.before(courseEndDate) && !course.isRestrictEnrollmentsToCourseDates()) {
                locked = true;
            }
        } else if (course.isRestrictEnrollmentsToCourseDates() && courseEndDate != null && now.after(courseEndDate)) {
            locked = true;
        }
        return locked;
    }

    public static boolean isPublished(Course course) {
        return course.getWorkflowState() != null && WORKFLOW_STATE.AVAILABLE.getText().equals(course.getWorkflowState());
    }

    public static Date getStartDate(Course course) {
        return CanvasDateFormatUtil.string2Date(course.getStartAt());
    }

    public static Date getEndDate(Course course) {
        return CanvasDateFormatUtil.string2Date(course.getEndAt());
    }

    public static Date getCreatedDate(Course course) {
        return CanvasDateFormatUtil.string2Date(course.getCreatedAt());
    }

    public static OffsetDateTime getStartOffsetDateTime(Course course) {
        return CanvasDateFormatUtil.string2OffsetDateTime(course.getStartAt());
    }

    public static OffsetDateTime getEndOffsetDateTime(Course course) {
        return CanvasDateFormatUtil.string2OffsetDateTime(course.getEndAt());
    }

    public static OffsetDateTime getCreatedOffsetDateTime(Course course) {
        return CanvasDateFormatUtil.string2OffsetDateTime(course.getCreatedAt());
    }

    public static boolean isCourseActive(Course course) {
        return !CourseHelper.isLocked(course, true);
    }

    public static enum WORKFLOW_STATE {
        UNPUBLISHED("unpublished"),
        AVAILABLE("available"),
        COMPLETED("completed"),
        DELETED("deleted");

        private String text;

        private WORKFLOW_STATE(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static enum FEATURE_FLAG_STATE {
        off,
        allowed,
        on;

    }
}

