/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.helpers;

public class ImportHelper {
    public static final String PENDING_TYPE = "pending";
    public static final String IN_PROGRESS_TYPE = "in-progress";
    public static final String DONE_TYPE = "done";

    public static String getTypeFromState(String state) {
        String result = null;
        switch (state) {
            case "initializing": 
            case "created": {
                result = PENDING_TYPE;
                break;
            }
            case "importing": 
            case "cleanup_batch": 
            case "restoring": {
                result = IN_PROGRESS_TYPE;
                break;
            }
            case "imported": 
            case "imported_with_messages": 
            case "aborted": 
            case "failed": 
            case "failed_with_messages": 
            case "partially_restored": 
            case "restored": {
                result = DONE_TYPE;
            }
        }
        return result;
    }

    public static enum CANVAS_UPLOAD_STATE {
        initializing("pending"),
        created("pending"),
        importing("in-progress"),
        cleanup_batch("in-progress"),
        restoring("in-progress"),
        imported("done"),
        imported_with_messages("done"),
        aborted("done"),
        failed("done"),
        failed_with_messages("done"),
        partially_restored("done"),
        restored("done");

        private String type;

        private CANVAS_UPLOAD_STATE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

