/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.helpers;

import edu.iu.uits.lms.canvas.helpers.CanvasDateFormatUtil;
import edu.iu.uits.lms.canvas.model.CanvasTerm;
import java.time.OffsetDateTime;
import java.util.Date;

public class TermHelper {
    public static String TERM_NO_EXPIRATION = "noexp";

    public static Date getStartDate(CanvasTerm term) {
        return CanvasDateFormatUtil.string2Date(term.getStartAt());
    }

    public static Date getEndDate(CanvasTerm term) {
        return CanvasDateFormatUtil.string2Date(term.getEndAt());
    }

    public static Date getStartDate(CanvasTerm.TermOverride termOverride) {
        return CanvasDateFormatUtil.string2Date(termOverride.getStartAt());
    }

    public static Date getEndDate(CanvasTerm.TermOverride termOverride) {
        return CanvasDateFormatUtil.string2Date(termOverride.getEndAt());
    }

    public static OffsetDateTime getStartOffsetDateTime(CanvasTerm term) {
        return CanvasDateFormatUtil.string2OffsetDateTime(term.getStartAt());
    }

    public static OffsetDateTime getEndOffsetDateTime(CanvasTerm term) {
        return CanvasDateFormatUtil.string2OffsetDateTime(term.getEndAt());
    }

    public static OffsetDateTime getStartOffsetDateTime(CanvasTerm.TermOverride termOverride) {
        return CanvasDateFormatUtil.string2OffsetDateTime(termOverride.getStartAt());
    }

    public static OffsetDateTime getEndOffsetDateTime(CanvasTerm.TermOverride termOverride) {
        return CanvasDateFormatUtil.string2OffsetDateTime(termOverride.getEndAt());
    }

    public static boolean isActive(CanvasTerm term) {
        Date now = new Date();
        return "active".equals(term.getWorkflowState()) && (term.getEndAt() == null || TermHelper.getEndDate(term).after(now));
    }
}

