/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.Account;
import edu.iu.uits.lms.canvas.model.AccountAdmin;
import edu.iu.uits.lms.canvas.model.AccountAdminCreate;
import edu.iu.uits.lms.canvas.model.CanvasRole;
import edu.iu.uits.lms.canvas.model.Saml;
import edu.iu.uits.lms.canvas.model.SsoSettings;
import edu.iu.uits.lms.canvas.model.SsoSettingsWrapper;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class AccountService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(AccountService.class);
    private static final String CANVAS_BASE_URI = "{url}";
    private static final String ACCOUNTS_BASE_URI = "{url}/accounts";
    private static final String ACCOUNT_URI = "{url}/accounts/{id}";
    private static final String COURSE_ACCOUNTS_URI = "{url}/course_accounts";
    private static final String ROLES_URI = "{url}/accounts/{id}/roles";
    private static final String ACCOUNT_ADMINS_URI = "{url}/accounts/{id}/admins";
    private static final String ACCOUNT_ADMINS_SPECIFIC_URI = "{url}/accounts/{id}/admins/{userid}";
    private static final String SUBACCOUNTS_URI = "{url}/accounts/{id}/sub_accounts";
    private static final String SSO_SETTINGS_URI = "{url}/accounts/{id}/sso_settings";
    private static final String SAML_URI = "{url}/accounts/{id}/authentication_providers/{samlId}";
    private static final UriTemplate ACCOUNT_TEMPLATE = new UriTemplate("{url}/accounts/{id}");
    private static final UriTemplate COURSE_ACCOUNTS_TEMPLATE = new UriTemplate("{url}/course_accounts");
    private static final UriTemplate ROLES_TEMPLATE = new UriTemplate("{url}/accounts/{id}/roles");
    private static final UriTemplate ACCOUNT_ADMINS_TEMPLATE = new UriTemplate("{url}/accounts/{id}/admins");
    private static final UriTemplate ACCOUNT_ADMINS_SPECIFIC_TEMPLATE = new UriTemplate("{url}/accounts/{id}/admins/{userid}");
    private static final UriTemplate SUBACCOUNTS_TEMPLATE = new UriTemplate("{url}/accounts/{id}/sub_accounts");
    private static final UriTemplate SSO_SETTINGS_TEMPLATE = new UriTemplate("{url}/accounts/{id}/sso_settings");
    private static final UriTemplate SAML_TEMPLATE = new UriTemplate("{url}/accounts/{id}/authentication_providers/{samlId}");

    public List<CanvasRole> getAllRoles() {
        URI uri = ROLES_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), this.canvasConfiguration.getAccountId()});
        log.debug("{}", (Object)uri);
        return this.doGet(uri, CanvasRole[].class);
    }

    public List<CanvasRole> getRolesForAccount(String accountId, boolean showInherited) {
        URI uri = ROLES_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId});
        log.debug("{}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("show_inherited", new Object[]{showInherited});
        return this.doGet(builder.build().toUri(), CanvasRole[].class);
    }

    @Cacheable(value={"parentAccounts"}, cacheManager="CanvasServicesCacheManager")
    public List<Account> getParentAccounts(String accountId) {
        ArrayList<Account> parentAccounts = new ArrayList<Account>();
        Account account = this.getAccount(accountId);
        while (account != null && account.getParentAccountId() != null) {
            account = this.getAccount(account.getParentAccountId());
            parentAccounts.add(account);
        }
        return parentAccounts;
    }

    public Account getAccount(String accountId) {
        URI uri = ACCOUNT_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId});
        log.debug("uri: {}", (Object)uri);
        try {
            ResponseEntity accountResponseEntity = this.restTemplate.getForEntity(uri, Account.class);
            log.debug("accountResponseEntity: {}", (Object)accountResponseEntity);
            if (accountResponseEntity != null) {
                return (Account)accountResponseEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error: ", (Throwable)hcee);
        }
        return null;
    }

    public List<Account> getAccountsForUser(String userLoginId) {
        URI uri = COURSE_ACCOUNTS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl()});
        log.debug("uri: {}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("as_user_id", new Object[]{"sis_login_id:" + userLoginId});
        builder.queryParam("per_page", new Object[]{"100"});
        return this.doGet(builder.build().toUri(), Account[].class);
    }

    public boolean isAccountAdmin(String accountId, String userId) {
        URI uri = ACCOUNT_ADMINS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId});
        log.debug("uri: {}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("user_id[]", new Object[]{userId});
        List accountAdmins = this.doGet(builder.build().toUri(), AccountAdmin[].class);
        for (AccountAdmin accountAdmin : accountAdmins) {
            if (!"active".equals(accountAdmin.getWorkflow_state())) continue;
            return true;
        }
        return false;
    }

    public boolean elevateToAccountAdmin(String accountId, String userId) {
        if (this.isAccountAdmin(accountId, userId)) {
            return true;
        }
        URI uri = ACCOUNT_ADMINS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId});
        log.debug("uri: {}", (Object)uri);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            AccountAdminCreate accountAdminCreate = new AccountAdminCreate(userId, false);
            HttpEntity accountAdminCreateRequestEntity = new HttpEntity((Object)accountAdminCreate, (MultiValueMap)headers);
            ResponseEntity accountAdminCreateResponseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, accountAdminCreateRequestEntity, AccountAdmin.class);
            log.debug("accountAdminCreateResponseEntity: {}", (Object)accountAdminCreateResponseEntity);
            if (accountAdminCreateResponseEntity.getStatusCode() == HttpStatus.OK) {
                return true;
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("uh oh", (Throwable)hcee);
        }
        return false;
    }

    public boolean revokeAsAccountAdmin(String accountId, String userId) {
        if (!this.isAccountAdmin(accountId, userId)) {
            return true;
        }
        try {
            URI uri = ACCOUNT_ADMINS_SPECIFIC_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId, userId});
            log.debug("uri: {}", (Object)uri);
            ResponseEntity accountAdminDeleteResponseEntity = this.restTemplate.exchange(uri, HttpMethod.DELETE, null, AccountAdmin.class);
            log.debug("accountAdminDeleteResponseEntity: {}", (Object)accountAdminDeleteResponseEntity);
            if (accountAdminDeleteResponseEntity.getStatusCode() == HttpStatus.OK) {
                return true;
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("uh oh", (Throwable)hcee);
        }
        return false;
    }

    public List<Account> getSubAccounts() {
        URI uri = SUBACCOUNTS_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), this.canvasConfiguration.getAccountId()});
        log.debug("uri: {}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("recursive", new Object[]{"true"});
        builder.queryParam("per_page", new Object[]{"50"});
        return this.doGet(builder.build().toUri(), Account[].class);
    }

    public Account setSisAccountId(String accountId, String sisAccountId) {
        if (accountId == null || accountId.isEmpty() || sisAccountId == null || sisAccountId.isEmpty()) {
            throw new RuntimeException("Null parameters");
        }
        URI uri = ACCOUNT_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), accountId});
        log.debug("uri: {}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("account[sis_account_id]", new Object[]{sisAccountId});
        try {
            ResponseEntity response = this.restTemplate.exchange(builder.build().toUri(), HttpMethod.PUT, null, Account.class);
            log.debug("{}", (Object)response);
            if (response.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + response.getStatusCode() + ", reason: " + response.getStatusCode().getReasonPhrase() + ", body: " + response.getBody());
            }
            return (Account)response.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.error("cannot set sisAccountId", (Throwable)hcee);
            throw new RuntimeException("cannot set sisAccountId", hcee);
        }
    }

    public SsoSettings getSsoSettings(String canvasServer) {
        URI uri = SSO_SETTINGS_TEMPLATE.expand(new Object[]{canvasServer, this.canvasConfiguration.getAccountId()});
        log.debug("{}", (Object)uri);
        try {
            SsoSettingsWrapper ssoSettingsWrapperResponse;
            ResponseEntity ssoSettingsResponseEntity = this.restTemplate.getForEntity(uri, SsoSettingsWrapper.class);
            log.debug("{}", (Object)ssoSettingsResponseEntity);
            if (ssoSettingsResponseEntity != null && (ssoSettingsWrapperResponse = (SsoSettingsWrapper)ssoSettingsResponseEntity.getBody()) != null) {
                return ssoSettingsWrapperResponse.getSsoSettings();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error getting SsoSettings", (Throwable)hcee);
        }
        return null;
    }

    public SsoSettings setSsoSettings(String canvasServer, SsoSettingsWrapper ssoSettingsWrapper) {
        URI uri = SSO_SETTINGS_TEMPLATE.expand(new Object[]{canvasServer, this.canvasConfiguration.getAccountId()});
        log.debug("{}", (Object)uri);
        try {
            SsoSettingsWrapper ssoSettingsWrapperResponse;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity ssoSettingsWrapperRequestEntity = new HttpEntity((Object)ssoSettingsWrapper, (MultiValueMap)headers);
            ResponseEntity ssoSettingsResponseEntity = this.restTemplate.exchange(uri, HttpMethod.PUT, ssoSettingsWrapperRequestEntity, SsoSettingsWrapper.class);
            log.debug("{}", (Object)ssoSettingsResponseEntity);
            if (ssoSettingsResponseEntity != null && (ssoSettingsWrapperResponse = (SsoSettingsWrapper)ssoSettingsResponseEntity.getBody()) != null) {
                return ssoSettingsWrapperResponse.getSsoSettings();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error setting SsoSettings", (Throwable)hcee);
        }
        return null;
    }

    public Saml getSaml(String canvasServer, String samlId) {
        URI uri = SAML_TEMPLATE.expand(new Object[]{canvasServer, this.canvasConfiguration.getAccountId(), samlId});
        log.debug("{}", (Object)uri);
        try {
            ResponseEntity samlResponseEntity = this.restTemplate.getForEntity(uri, Saml.class);
            log.debug("{}", (Object)samlResponseEntity);
            if (samlResponseEntity != null) {
                return (Saml)samlResponseEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error getting Saml", (Throwable)hcee);
        }
        return null;
    }

    public void setSaml(String canvasServer, String samlId, Saml newSamlObject) {
        URI uri = SAML_TEMPLATE.expand(new Object[]{canvasServer, this.canvasConfiguration.getAccountId(), samlId});
        log.debug("{}", (Object)uri);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        try {
            HttpEntity requestEntity = new HttpEntity((Object)newSamlObject, (MultiValueMap)headers);
            ResponseEntity samlResponseEntity = this.restTemplate.exchange(uri, HttpMethod.PUT, requestEntity, Saml.class);
            log.debug("{}", (Object)samlResponseEntity);
            ResponseEntity responseEntity = samlResponseEntity;
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("Request to Canvas was not successful. Response code: " + responseEntity.getStatusCode() + ", reason: " + responseEntity.getStatusCode().getReasonPhrase() + ", body: " + responseEntity.getBody());
            }
        }
        catch (RuntimeException re) {
            log.error("Error setting Saml", (Throwable)re);
        }
    }
}

