/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.Announcement;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.io.File;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

@Service
public class AnnouncementService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementService.class);
    private static final String BASE_URI = "{url}/courses/{course_id}/discussion_topics";
    private static final String ANNOUNCEMENT_URI = "{url}/courses/{course_id}/discussion_topics/{announcement_id}";
    private static final UriTemplate BASE_TEMPLATE = new UriTemplate("{url}/courses/{course_id}/discussion_topics");
    private static final UriTemplate ANNOUNCEMENT_TEMPLATE = new UriTemplate("{url}/courses/{course_id}/discussion_topics/{announcement_id}");

    public Announcement getAnnouncement(String announcementId, String courseId) {
        URI uri = ANNOUNCEMENT_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, announcementId});
        log.debug("uri: {}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("only_announcements", new Object[]{true});
        ResponseEntity announcementEntity = this.restTemplate.getForEntity(builder.build().toUri(), Announcement.class);
        log.debug("announcementEntity: {}", (Object)announcementEntity);
        return (Announcement)announcementEntity.getBody();
    }

    public List<Announcement> getAnnouncementsForCourse(String courseId) {
        URI uri = BASE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        log.debug("uri: {}", (Object)uri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        builder.queryParam("only_announcements", new Object[]{true});
        return this.doGet(builder.build().toUri(), Announcement[].class);
    }

    public Announcement createAnnouncement(String courseId, Announcement announcement, boolean isPodcastEnabled, String asUser, String fileName, File file) {
        URI uri = BASE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)uri);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"title", (Object)announcement.getTitle());
        map.add((Object)"message", (Object)announcement.getMessage());
        map.add((Object)"podcast_enabled", (Object)isPodcastEnabled);
        map.add((Object)"podcast_has_student_posts", (Object)announcement.isPodcastHasStudentPosts());
        map.add((Object)"allow_rating", (Object)announcement.isAllowRating());
        map.add((Object)"only_graders_can_rate", (Object)announcement.isOnlyGradersCanRate());
        map.add((Object)"sort_by_rating", (Object)announcement.isSortByRating());
        map.add((Object)"published", (Object)announcement.isPublished());
        map.add((Object)"is_announcement", (Object)true);
        if (asUser != null) {
            map.add((Object)"as_user_id", (Object)asUser);
        }
        if (file != null && file.length() > 0L) {
            final String attachmentFileName = fileName != null ? fileName : file.getName();
            FileSystemResource fileAsResource = new FileSystemResource(file){

                public String getFilename() {
                    return attachmentFileName;
                }
            };
            map.add((Object)"attachment", (Object)fileAsResource);
        }
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            ResponseEntity announcementsEntity = this.restTemplate.postForEntity(builder.build().toUri(), (Object)requestEntity, Announcement.class);
            HttpStatus responseStatus = announcementsEntity.getStatusCode();
            if (HttpStatus.OK.equals((Object)responseStatus)) {
                return (Announcement)announcementsEntity.getBody();
            }
            throw new RuntimeException("Error creating announcement. Request to Canvas was not successful. Response code: " + responseStatus + ", reason: " + responseStatus.getReasonPhrase() + ", entity: " + (HttpEntity)announcementsEntity);
        }
        catch (Exception ex) {
            log.error("An error occurred attempting to create an announcement in Canvas for course: " + courseId, (Throwable)ex);
            throw new RuntimeException("Announcement was not created for course: " + courseId);
        }
    }
}

