/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.uits.lms.canvas.services;

import edu.iu.uits.lms.canvas.model.Assignment;
import edu.iu.uits.lms.canvas.model.AssignmentSubmission;
import edu.iu.uits.lms.canvas.services.SpringBaseService;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.util.UriTemplate;

@Service
public class AssignmentService
extends SpringBaseService {
    private static final Logger log = LoggerFactory.getLogger(AssignmentService.class);
    private static final String CANVAS_BASE_URI = "{url}";
    private static final String BASE_URI = "{url}/courses/{course_id}/assignments";
    private static final String ASSIGNMENT_URI = "{url}/courses/{course_id}/assignments/{assignment_id}";
    private static final String SUBMISSION_URI = "{url}/courses/{course_id}/assignments/{assignment_id}/submissions/{user_id}";
    private static final UriTemplate BASE_TEMPLATE = new UriTemplate("{url}/courses/{course_id}/assignments");
    private static final UriTemplate ASSIGNMENT_TEMPLATE = new UriTemplate("{url}/courses/{course_id}/assignments/{assignment_id}");
    private static final UriTemplate SUBMISSION_TEMPLATE = new UriTemplate("{url}/courses/{course_id}/assignments/{assignment_id}/submissions/{user_id}");

    public Assignment getAssignmentByAssignmentId(String courseId, String assignmentId) {
        URI uri = ASSIGNMENT_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, assignmentId});
        log.debug("{}", (Object)uri);
        try {
            ResponseEntity assignmentEntity = this.restTemplate.getForEntity(uri, Assignment.class);
            log.debug("{}", (Object)assignmentEntity);
            if (assignmentEntity != null) {
                return (Assignment)assignmentEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error getting assignment " + assignmentId + " for course " + courseId, (Throwable)hcee);
        }
        return null;
    }

    public AssignmentSubmission getAssignmentSubmissionByUserId(String courseId, String assignmentId, String userId) {
        String userIdPath = "sis_login_id:" + userId;
        URI uri = SUBMISSION_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId, assignmentId, userIdPath});
        log.debug("{}", (Object)uri);
        try {
            ResponseEntity assignmentSubmissionEntity = this.restTemplate.getForEntity(uri, AssignmentSubmission.class);
            log.debug("{}", (Object)assignmentSubmissionEntity);
            if (assignmentSubmissionEntity != null) {
                return (AssignmentSubmission)assignmentSubmissionEntity.getBody();
            }
        }
        catch (HttpClientErrorException hcee) {
            log.error("Error getting submission for assignment " + assignmentId + " for user " + userId + " in course " + courseId, (Throwable)hcee);
        }
        return null;
    }

    public List<Assignment> getAssignments(String courseId) {
        URI uri = BASE_TEMPLATE.expand(new Object[]{this.canvasConfiguration.getBaseApiUrl(), courseId});
        log.debug("{}", (Object)uri);
        return this.doGet(uri, Assignment[].class);
    }
}

